/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.Glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.GlossaryCategory.GlossaryCategory;
import org.odpi.openmetadata.accessservices.subjectarea.generated.entities.RelatedMedia.RelatedMedia;
import org.odpi.openmetadata.accessservices.subjectarea.generated.enums.MediaUsage;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Antonym.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryAnchor.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.CategoryHierarchyLink.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ISARelationship.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.MediaReference.MediaReference;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.PreferredTerm.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.RelatedTerm.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ReplacementTerm.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.SemanticAssignment.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Synonym.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermAnchor.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermCategorization.TermCategorization;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermHASARelationship.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermISATypeOFRelationship.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.TermTYPEDBYRelationship.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.Translation.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.UsedInContext.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.generated.relationships.ValidValue.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.generated.server.SubjectAreaBeansToAccessOMRS;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.HasAMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.IsaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.IsaTypeOfMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermReplacementMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TypedByMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaUtils {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaUtils.class);
    private static final String className = SubjectAreaUtils.class.getName();

    public static boolean isTopLevelGlossaryObject(String entityName) {
        boolean isTopLevelGlossaryObject = false;
        if (entityName.equals("Glossary") || entityName.equals("Node") || entityName.equals("GlossaryCategory")) {
            isTopLevelGlossaryObject = true;
        }
        return isTopLevelGlossaryObject;
    }

    public static boolean isGovernanceActionClassification(String classificationName) {
        boolean isGovernanceActionClassification = false;
        if (classificationName.equals("Confidence") || classificationName.equals("Confidentiality") || classificationName.equals("Retention") || classificationName.equals("Criticality")) {
            isGovernanceActionClassification = true;
        }
        return isGovernanceActionClassification;
    }

    public static InstanceType createTemplateFromTypeDef(TypeDef typeDef) {
        InstanceType template = new InstanceType();
        template.setTypeDefName(typeDef.getName());
        template.setTypeDefCategory(typeDef.getCategory());
        template.setTypeDefDescription(typeDef.getDescription());
        template.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
        template.setTypeDefGUID(typeDef.getGUID());
        ArrayList<TypeDefLink> supertypes = new ArrayList<TypeDefLink>();
        supertypes.add(typeDef.getSuperType());
        template.setTypeDefSuperTypes(supertypes);
        template.setTypeDefVersion(typeDef.getVersion());
        template.setValidStatusList(typeDef.getValidInstanceStatusList());
        return template;
    }

    public static boolean isTerm(String typeName) {
        return typeName.equals("GlossaryTerm");
    }

    public static boolean isCategory(String typeName) {
        return typeName.equals("GlossaryCategory");
    }

    public static boolean isGlossary(String typeName) {
        return typeName.equals("Glossary");
    }

    public static void addStringToInstanceProperty(String key, String value, InstanceProperties instanceProperties) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)value);
        instanceProperties.setProperty(key, (InstancePropertyValue)primitivePropertyValue);
    }

    public static Set<IconSummary> getIconSummarySet(String userId, SubjectAreaBeansToAccessOMRS subjectAreaBeansToAccessOMRS, Set<Line> mediaReferenceRelationshipSet) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException {
        HashSet<IconSummary> icons = new HashSet<IconSummary>();
        HashSet<String> relatedMediaGuidSet = new HashSet<String>();
        if (mediaReferenceRelationshipSet != null && !mediaReferenceRelationshipSet.isEmpty()) {
            for (Line line : mediaReferenceRelationshipSet) {
                MediaReference mediaReference = (MediaReference)line;
                if (!SubjectAreaUtils.isEffective(line)) continue;
                String mediaGuid = mediaReference.getEntity2Guid();
                relatedMediaGuidSet.add(mediaGuid);
            }
        }
        for (String relatedMediaguid : relatedMediaGuidSet) {
            IconSummary icon;
            RelatedMedia relatedMedia = subjectAreaBeansToAccessOMRS.getRelatedMediaById(userId, relatedMediaguid);
            if (!SubjectAreaUtils.isEffective(relatedMedia) || (icon = SubjectAreaUtils.extractIconSummaryFromRelatedMedia(relatedMedia)) == null) continue;
            icons.add(icon);
        }
        return icons;
    }

    private static boolean isEffective(RelatedMedia relatedMedia) {
        return SubjectAreaUtils.isEffective(relatedMedia.getEffectiveFromTime(), relatedMedia.getEffectiveToTime());
    }

    public static boolean isEffective(Line line) {
        return SubjectAreaUtils.isEffective(line.getEffectiveFromTime(), line.getEffectiveToTime());
    }

    public static boolean isEffective(Date from, Date to) {
        boolean isEffective = true;
        long currentDate = new Date().getTime();
        if (from != null && currentDate < from.getTime()) {
            isEffective = false;
        }
        if (to != null && currentDate > to.getTime()) {
            isEffective = false;
        }
        return isEffective;
    }

    public static GlossarySummary getGlossarySummaryForTerm(String userId, SubjectAreaBeansToAccessOMRS subjectAreaBeansToAccessOMRS, Line line) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException, FunctionNotSupportedException {
        TermAnchor termAnchorRelationship = (TermAnchor)line;
        String glossaryGuid = termAnchorRelationship.getEntity1Guid();
        Glossary glossary = subjectAreaBeansToAccessOMRS.getGlossaryById(userId, glossaryGuid);
        GlossarySummary glossarySummary = SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary);
        if (glossarySummary != null) {
            String mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid();
            Set<Line> mediaReferenceRelationships = subjectAreaBeansToAccessOMRS.getGlossaryRelationships(userId, glossaryGuid, mediaReferenceTypeGuid, 0, null, null, null, 0);
            Set<IconSummary> icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaBeansToAccessOMRS, mediaReferenceRelationships);
            glossarySummary.setIcons(icons);
        }
        return glossarySummary;
    }

    public static GlossarySummary getGlossarySummaryForCategory(String userId, SubjectAreaBeansToAccessOMRS subjectAreaBeansToAccessOMRS, Line line) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException, FunctionNotSupportedException {
        CategoryAnchor categoryAnchorRelationship = (CategoryAnchor)line;
        String glossaryGuid = categoryAnchorRelationship.getEntity1Guid();
        Glossary glossary = subjectAreaBeansToAccessOMRS.getGlossaryById(userId, glossaryGuid);
        GlossarySummary glossarySummary = SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary);
        String mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid();
        Set<Line> mediaReferenceRelationships = subjectAreaBeansToAccessOMRS.getGlossaryRelationships(userId, glossaryGuid, mediaReferenceTypeGuid, 0, null, null, null, 0);
        Set<IconSummary> icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaBeansToAccessOMRS, mediaReferenceRelationships);
        glossarySummary.setIcons(icons);
        return glossarySummary;
    }

    public static CategorySummary getParentCategorySummary(String userId, SubjectAreaBeansToAccessOMRS subjectAreaBeansToAccessOMRS, Set<Line> lines) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException, FunctionNotSupportedException {
        CategorySummary parentCategorySummary = null;
        Iterator<Line> iterator = lines.iterator();
        while (iterator.hasNext() && parentCategorySummary == null) {
            CategoryHierarchyLink parentRelationship = (CategoryHierarchyLink)iterator.next();
            if (!SubjectAreaUtils.isEffective(parentRelationship)) continue;
            String parentCategoryGuid = parentRelationship.getEntity1Guid();
            GlossaryCategory glossaryCategory = subjectAreaBeansToAccessOMRS.getGlossaryCategoryById(userId, parentCategoryGuid);
            parentCategorySummary = SubjectAreaUtils.extractCategorySummaryFromGlossaryCategory(glossaryCategory);
            String mediaReferenceTypeGuid = TypeGuids.getMediaReferenceTypeGuid();
            Set<Line> mediaReferenceRelationships = subjectAreaBeansToAccessOMRS.getGlossaryCategoryRelationships(userId, parentCategoryGuid, mediaReferenceTypeGuid, 0, null, null, null, 0);
            Set<IconSummary> icons = SubjectAreaUtils.getIconSummarySet(userId, subjectAreaBeansToAccessOMRS, mediaReferenceRelationships);
            parentCategorySummary.setIcons(icons);
        }
        return parentCategorySummary;
    }

    private static CategorySummary extractCategorySummaryFromGlossaryCategory(GlossaryCategory glossaryCategory) {
        CategorySummary categorySummary = new CategorySummary();
        categorySummary.setQualifiedName(glossaryCategory.getQualifiedName());
        categorySummary.setName(glossaryCategory.getDisplayName());
        categorySummary.setGuid(glossaryCategory.getSystemAttributes().getGUID());
        return categorySummary;
    }

    public static IconSummary extractIconSummaryFromRelatedMedia(RelatedMedia relatedMedia) {
        IconSummary icon = null;
        if (relatedMedia.getMediaUsage().contains(MediaUsage.Icon.getOrdinal())) {
            icon = new IconSummary();
            icon.setGuid(relatedMedia.getSystemAttributes().getGUID());
            icon.setQualifiedName(relatedMedia.getQualifiedName());
            icon.setUrl(relatedMedia.getUrl());
            icon.setQualifiedName(relatedMedia.getQualifiedName());
            icon.setLabel(relatedMedia.getDisplayName());
        }
        return icon;
    }

    public static GlossarySummary extractGlossarySummaryFromGlossary(Glossary glossary) {
        if (glossary == null) {
            return null;
        }
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossary.getSystemAttributes().getGUID());
        glossarySummary.setQualifiedName(glossary.getQualifiedName());
        glossarySummary.setName(glossary.getDisplayName());
        return glossarySummary;
    }

    public static void checkStatusNotDeleted(Status status, SubjectAreaErrorCode errorCode) throws InvalidParameterException {
        String methodName = "checkStatusNotDeleted";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: checkStatusNotDeleted");
        }
        Object response = null;
        if (status.equals((Object)Status.DELETED)) {
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "checkStatusNotDeleted"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "checkStatusNotDeleted", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: checkStatusNotDeleted");
        }
    }

    public static Status convertInstanceStatusToStatus(InstanceStatus instanceStatus) {
        Status status = null;
        if (instanceStatus == null) {
            status = Status.ACTIVE;
        } else {
            switch (instanceStatus) {
                case ACTIVE: {
                    status = Status.ACTIVE;
                    break;
                }
                case DELETED: {
                    status = Status.DELETED;
                    break;
                }
                case DRAFT: {
                    status = Status.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    status = Status.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    status = Status.PREPARED;
                    break;
                }
                case PROPOSED: {
                    status = Status.PROPOSED;
                    break;
                }
                case APPROVED: {
                    status = Status.APPROVED;
                }
            }
        }
        return status;
    }

    public static InstanceStatus convertStatusToInstanceStatus(Status status) {
        InstanceStatus instanceStatus = null;
        if (status == null) {
            instanceStatus = InstanceStatus.ACTIVE;
        } else {
            switch (status) {
                case ACTIVE: {
                    instanceStatus = InstanceStatus.ACTIVE;
                    break;
                }
                case DELETED: {
                    instanceStatus = InstanceStatus.DELETED;
                    break;
                }
                case DRAFT: {
                    instanceStatus = InstanceStatus.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    instanceStatus = InstanceStatus.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    instanceStatus = InstanceStatus.PREPARED;
                    break;
                }
                case PROPOSED: {
                    instanceStatus = InstanceStatus.PROPOSED;
                    break;
                }
                case APPROVED: {
                    instanceStatus = InstanceStatus.APPROVED;
                }
            }
        }
        return instanceStatus;
    }

    public static List<Line> convertOMRSLinesToOMASLines(Set<Line> omrsLines) {
        ArrayList<Line> omasLines = new ArrayList<Line>();
        for (Line omrsLine : omrsLines) {
            String omrsName = omrsLine.getName();
            org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship omasLine = null;
            switch (omrsName) {
                case "TermHASARelationship": {
                    omasLine = HasAMapper.mapOMRSRelationshipBeanToTermHASARelationship((TermHASARelationship)omrsLine);
                    break;
                }
                case "RelatedTerm": {
                    omasLine = RelatedTermMapper.mapOMRSRelationshipBeanToRelatedTerm((RelatedTerm)omrsLine);
                    break;
                }
                case "Synonym": {
                    omasLine = SynonymMapper.mapOMRSRelationshipBeanToSynonym((Synonym)omrsLine);
                    break;
                }
                case "Antonym": {
                    omasLine = AntonymMapper.mapOMRSRelationshipBeanToAntonym((Antonym)omrsLine);
                    break;
                }
                case "Translation": {
                    omasLine = TranslationMapper.mapOMRSRelationshipBeanToTranslation((Translation)omrsLine);
                    break;
                }
                case "ISARelationship": {
                    omasLine = IsaMapper.mapOMRSRelationshipBeanToISARelationship((ISARelationship)omrsLine);
                    break;
                }
                case "PreferredTerm": {
                    omasLine = PreferredTermMapper.mapOMRSRelationshipBeanToPreferredTerm((PreferredTerm)omrsLine);
                    break;
                }
                case "TermISATypeOFRelationship": {
                    omasLine = IsaTypeOfMapper.mapOMRSRelationshipBeanToTermISATypeOFRelationship((TermISATypeOFRelationship)omrsLine);
                    break;
                }
                case "ReplacementTerm": {
                    omasLine = TermReplacementMapper.mapOMRSRelationshipBeanToReplacementTerm((ReplacementTerm)omrsLine);
                    break;
                }
                case "TermTYPEDBYRelationship": {
                    omasLine = TypedByMapper.mapOMRSRelationshipBeanToTermTYPEDBYRelationship((TermTYPEDBYRelationship)omrsLine);
                    break;
                }
                case "UsedInContext": {
                    omasLine = UsedInContextMapper.mapOMRSRelationshipBeanToUsedInContext((UsedInContext)omrsLine);
                    break;
                }
                case "ValidValue": {
                    omasLine = ValidValueMapper.mapOMRSRelationshipBeanToValidValue((ValidValue)omrsLine);
                    break;
                }
                case "LibraryCategoryReferenceRelationshipRelationship": {
                    break;
                }
                case "LibraryTermReferenceRelationshipRelationship": {
                    break;
                }
                case "SemanticAssignment": {
                    omasLine = SemanticAssignmentMapper.mapOMRSRelationshipBeanToSemanticAssignment((SemanticAssignment)omrsLine);
                    break;
                }
                case "TermCategorization": {
                    omasLine = TermCategorizationMapper.mapOMRSRelationshipBeanToTermCategorization((TermCategorization)omrsLine);
                    break;
                }
                case "TermAnchor": {
                    omasLine = TermAnchorMapper.mapOMRSRelationshipBeanToTermAnchor((TermAnchor)omrsLine);
                    break;
                }
                case "CategoryAnchor": {
                    omasLine = CategoryAnchorMapper.mapOMRSRelationshipBeanToCategoryAnchor((CategoryAnchor)omrsLine);
                }
            }
            if (omasLine == null) continue;
            omasLines.add((Line)omasLine);
        }
        return omasLines;
    }

    public static org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder convertOMASToOMRSSequencingOrder(SequencingOrder sequencingOrder) {
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = null;
        if (sequencingOrder == null) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
        } else if (sequencingOrder.equals((Object)SequencingOrder.ANY)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
        } else if (sequencingOrder.equals((Object)SequencingOrder.CREATION_DATE_RECENT)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT;
        } else if (sequencingOrder.equals((Object)SequencingOrder.CREATION_DATE_OLDEST)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_OLDEST;
        } else if (sequencingOrder.equals((Object)SequencingOrder.LAST_UPDATE_RECENT)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_RECENT;
        } else if (sequencingOrder.equals((Object)SequencingOrder.LAST_UPDATE_OLDEST)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_OLDEST;
        } else if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_ASCENDING;
        } else if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_DESCENDING;
        } else if (sequencingOrder.equals((Object)SequencingOrder.GUID)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.GUID;
        }
        return omrsSequencingOrder;
    }
}

