/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.initialization;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaRegistration;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaServicesInstanceMap;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SubjectAreaInstanceHandler {
    private static SubjectAreaServicesInstanceMap instanceMap = new SubjectAreaServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.SUBJECT_AREA_OMAS;

    public SubjectAreaInstanceHandler() {
        SubjectAreaRegistration.registerAccessService();
    }

    public String getAccessServiceName(String serverName) throws MetadataServerUncontactableException {
        SubjectAreaServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getAccessServiceName();
        }
        String methodName = "getAccessServiceName";
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getAccessServiceName"});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAccessServiceName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws MetadataServerUncontactableException {
        SubjectAreaServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public OMRSRepositoryConnector getRepositoryConnector(String serverName) throws MetadataServerUncontactableException {
        SubjectAreaServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

