/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.handlers;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.GUIDNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ErrorHandler {
    static String className = ErrorHandler.class.getName();

    public static SubjectAreaOMASAPIResponse handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        UserNotAuthorizedException oe = new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
        return OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleUnknownAsset(Throwable error, String assetGUID, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetGUID, methodName, serviceName, serverName, error.getMessage()});
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), assetGUID);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleInvalidParameterException(org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_PARAMETER;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        InvalidParameterException oe = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        oe.setRelatedProperties(e.getRelatedProperties());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleTypeDefNotKnownException(String typeName, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.TYPEDEF_NOT_KNOWN;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, typeName});
        InvalidParameterException oe = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handlePropertyErrorException(PropertyErrorException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.INVALID_PARAMETER;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        InvalidParameterException oe = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        oe.setRelatedProperties(e.getRelatedProperties());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleClassificationErrorException(ClassificationErrorException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CLASSIFICATION_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        ClassificationException oe = new ClassificationException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertClassificationException((ClassificationException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleStatusNotSupportedException(StatusNotSupportedException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.STATUS_NOT_SUPPORTED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException oe = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertStatusNotsupportedException((org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotKnownError(String guid, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ENTITY_NOT_KNOWN_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, guid});
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityProxyOnlyException(EntityProxyOnlyException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{e.getMessage(), e.getErrorMessage(), methodName, serviceName, serverName});
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleTypeErrorException(TypeErrorException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.TYPEDEF_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        InvalidParameterException oe = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleFunctionNotSupportedException(org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.FUNCTION_NOT_SUPPORTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        FunctionNotSupportedException oe = new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handlePagingErrorException(PagingErrorException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.PAGING_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        InvalidParameterException oe = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRelationshipNotKnownException(String guid, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName});
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotKnownException(String guid, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName});
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotDeletedException(String guid, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        GUIDNotDeletedException oe = new GUIDNotDeletedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        return OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRelationshipNotDeletedException(String guid, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        GUIDNotDeletedException oe = new GUIDNotDeletedException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        return OMASExceptionToResponse.convertGUIDNotDeletedException((GUIDNotDeletedException)oe);
    }

    public SubjectAreaOMASAPIResponse handleMetadataServerUnContactable(MetadataServerUncontactableException e, String methodName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public SubjectAreaOMASAPIResponse handleEntityNotPurgedException(String obsoleteGuid, String restAPIName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
        GUIDNotPurgedException oe = new GUIDNotPurgedException(errorCode.getHTTPErrorCode(), className, restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), obsoleteGuid);
        return OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)oe);
    }

    public SubjectAreaOMASAPIResponse handleRelationshipNotPurgedException(String obsoleteGuid, String restAPIName, String serverName, String serviceName) {
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
        GUIDNotPurgedException oe = new GUIDNotPurgedException(errorCode.getHTTPErrorCode(), className, restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), obsoleteGuid);
        return OMASExceptionToResponse.convertGUIDNotPurgedException((GUIDNotPurgedException)oe);
    }
}

