/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMapper.class);
    private static final String className = ClassificationMapper.class.getName();
    protected final OMRSRepositoryHelper repositoryHelper;
    protected final OMRSAPIHelper omrsapiHelper;

    protected ClassificationMapper(OMRSAPIHelper omrsapiHelper) {
        this.omrsapiHelper = omrsapiHelper;
        this.repositoryHelper = omrsapiHelper.getOMRSRepositoryHelper();
    }

    public org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification mapOmrsToBean(Classification omrsClassification) {
        String classificationTypeName = omrsClassification.getName();
        if (this.isTypeCorrect(classificationTypeName)) {
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = this.createOmasClassification();
            SystemAttributes systemAttributes = ClassificationMapper.createSystemAttributesFromOMRSClassification(omrsClassification);
            omasClassification.setSystemAttributes(systemAttributes);
            InstanceProperties omrsClassificationProperties = omrsClassification.getProperties();
            if (omrsClassificationProperties != null && omrsClassificationProperties.getInstanceProperties() != null && !omrsClassificationProperties.getInstanceProperties().isEmpty()) {
                omasClassification.setEffectiveFromTime(omrsClassificationProperties.getEffectiveFromTime());
                omasClassification.setEffectiveToTime(omrsClassificationProperties.getEffectiveToTime());
                Set<String> attributeNameSet = this.mapKnownAttributesToOmrs(omasClassification, omrsClassificationProperties);
                Iterator omrsPropertyIterator = omrsClassificationProperties.getPropertyNames();
                while (omrsPropertyIterator.hasNext()) {
                    String name = (String)omrsPropertyIterator.next();
                    InstancePropertyValue value = omrsClassificationProperties.getPropertyValue(name);
                    if (attributeNameSet.contains(name)) continue;
                    String attributeValue = null;
                    switch (value.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(new HashMap());
                            }
                            attributeValue = primitivePropertyValue.valueAsString();
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(new HashMap());
                            }
                            attributeValue = enumPropertyValue.valueAsString();
                            break;
                        }
                        case MAP: {
                            MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                            if (null == omasClassification.getAdditionalProperties()) {
                                omasClassification.setAdditionalProperties(new HashMap());
                            }
                            attributeValue = mapPropertyValue.getMapValues().toString();
                            break;
                        }
                    }
                    omasClassification.getAdditionalProperties().put(name, attributeValue);
                }
            }
            return omasClassification;
        }
        return null;
    }

    public Classification mapBeanToOmrs(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        SystemAttributes systemAttributes = omasClassification.getSystemAttributes();
        Classification omrsClassification = new Classification();
        SubjectAreaUtils.populateSystemAttributesForInstanceAuditHeader(systemAttributes, (InstanceAuditHeader)omrsClassification);
        omrsClassification.setName(omasClassification.getClassificationName());
        omrsClassification.setProperties(this.updateOMRSAttributes(omasClassification));
        return omrsClassification;
    }

    protected abstract org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification createOmasClassification();

    protected abstract Set<String> mapKnownAttributesToOmrs(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification var1, InstanceProperties var2);

    protected boolean isTypeCorrect(String actualTypeName) {
        return this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), actualTypeName, this.getTypeName());
    }

    abstract String getTypeName();

    protected abstract InstanceProperties updateOMRSAttributes(org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification var1);

    public static SystemAttributes createSystemAttributesFromOMRSClassification(Classification omrsClassification) {
        SystemAttributes systemAttributes = new SystemAttributes();
        Status status = SubjectAreaUtils.convertInstanceStatusToStatus(omrsClassification.getStatus());
        systemAttributes.setStatus(status);
        systemAttributes.setCreatedBy(omrsClassification.getCreatedBy());
        systemAttributes.setUpdatedBy(omrsClassification.getUpdatedBy());
        systemAttributes.setCreateTime(omrsClassification.getCreateTime());
        systemAttributes.setUpdateTime(omrsClassification.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(omrsClassification.getVersion()));
        return systemAttributes;
    }
}

