/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications;

import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.ConfidenceLevel;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfidenceMapper
extends ClassificationMapper {
    private static final Logger log = LoggerFactory.getLogger(ConfidenceMapper.class);
    private static final String className = ConfidenceMapper.class.getName();
    private static final String typeName = "Confidence";

    public ConfidenceMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected Set<String> mapKnownAttributesToOmrs(Classification omasClassification, InstanceProperties omrsClassificationProperties) {
        EnumPropertyValue enumPropertyValue;
        Confidence confidence = (Confidence)omasClassification;
        String stringValue = this.repositoryHelper.getStringProperty(this.omrsapiHelper.getServiceName(), "steward", omrsClassificationProperties, "");
        confidence.setSteward(stringValue);
        stringValue = this.repositoryHelper.getStringProperty(this.omrsapiHelper.getServiceName(), "notes", omrsClassificationProperties, "");
        confidence.setNotes(stringValue);
        Integer intValue = this.repositoryHelper.getIntProperty(this.omrsapiHelper.getServiceName(), "confidence", omrsClassificationProperties, "");
        confidence.setConfidence(intValue);
        Map instancePropertyMap = omrsClassificationProperties.getInstanceProperties();
        InstancePropertyValue instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("level");
        if (instancePropertyValue != null) {
            enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            ConfidenceLevel level = ConfidenceLevel.valueOf((String)enumPropertyValue.getSymbolicName());
            confidence.setLevel(level);
        }
        if ((instancePropertyValue = (InstancePropertyValue)instancePropertyMap.get("status")) != null) {
            enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            GovernanceClassificationStatus status = GovernanceClassificationStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            confidence.setStatus(status);
        }
        return Confidence.getPropertyNames();
    }

    @Override
    protected String getTypeName() {
        return typeName;
    }

    @Override
    protected Classification createOmasClassification() {
        return new Confidence();
    }

    @Override
    protected InstanceProperties updateOMRSAttributes(Classification omasClassification) {
        EnumPropertyValue enumPropertyValue;
        InstanceProperties instanceProperties = new InstanceProperties();
        Confidence confidence = (Confidence)omasClassification;
        if (confidence.getSteward() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "steward", confidence.getSteward(), "updateOMRSAttributes");
        }
        if (confidence.getSource() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "source", confidence.getSource(), "updateOMRSAttributes");
        }
        if (confidence.getNotes() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "notes", confidence.getNotes(), "updateOMRSAttributes");
        }
        if (confidence.getConfidence() != null) {
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
            primitivePropertyValue.setPrimitiveValue((Object)confidence.getConfidence());
            instanceProperties.setProperty("confidence", (InstancePropertyValue)primitivePropertyValue);
        }
        if (confidence.getLevel() != null) {
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(confidence.getLevel().getOrdinal());
            enumPropertyValue.setSymbolicName(confidence.getLevel().getName());
            instanceProperties.setProperty("level", (InstancePropertyValue)enumPropertyValue);
        }
        if (confidence.getStatus() != null) {
            enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(confidence.getStatus().getOrdinal());
            enumPropertyValue.setSymbolicName(confidence.getStatus().getName());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
        return instanceProperties;
    }
}

