/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermMapper
extends EntityDetailMapper
implements INodeMapper {
    private static final Logger log = LoggerFactory.getLogger(TermMapper.class);
    private static final String className = TermMapper.class.getName();
    public static final String GLOSSARY_TERM = "GlossaryTerm";

    public TermMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    public Node mapEntityDetailToNode(EntityDetail entityDetail) throws InvalidParameterException {
        String methodName = "mapEntityDetailToNode";
        String entityTypeName = entityDetail.getType().getTypeDefName();
        if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), entityTypeName, GLOSSARY_TERM)) {
            Term term = new Term();
            this.mapEntityDetailToNode((Node)term, entityDetail);
            return term;
        }
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.MAPPER_ENTITY_GUID_TYPE_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, entityDetail.getGUID(), "Term"});
        log.error(errorMessage);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    @Override
    protected boolean mapPrimitiveToNode(Node node, String propertyName, Object value) {
        String stringValue = (String)value;
        Term term = (Term)node;
        boolean foundProperty = true;
        if (propertyName.equals("summary")) {
            term.setSummary(stringValue);
        } else if (propertyName.equals("abbreviation")) {
            term.setAbbreviation(stringValue);
        } else if (propertyName.equals("examples")) {
            term.setExamples(stringValue);
        } else if (propertyName.equals("usage")) {
            term.setUsage(stringValue);
        } else {
            foundProperty = false;
        }
        return foundProperty;
    }

    @Override
    protected void mapNodeToInstanceProperties(Node node, InstanceProperties instanceProperties) {
        Term term = (Term)node;
        if (term.getSummary() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getSummary(), "summary");
        }
        if (term.getAbbreviation() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getAbbreviation(), "abbreviation");
        }
        if (term.getExamples() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getExamples(), "examples");
        }
        if (term.getUsage() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, term.getUsage(), "usage");
        }
        if (node.getName() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "displayName");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Node node, Classification omasClassification) {
        Term term = (Term)node;
        boolean handled = false;
        GovernanceActions governanceActions = term.getGovernanceActions();
        if (governanceActions == null) {
            governanceActions = new GovernanceActions();
        }
        String classificationName = omasClassification.getClassificationName();
        String sourceName = this.omrsapiHelper.getServiceName();
        if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Confidentiality")) {
            governanceActions.setConfidentiality((Confidentiality)omasClassification);
            term.setGovernanceActions(governanceActions);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Confidence")) {
            governanceActions.setConfidence((Confidence)omasClassification);
            term.setGovernanceActions(governanceActions);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Criticality")) {
            governanceActions.setCriticality((Criticality)omasClassification);
            term.setGovernanceActions(governanceActions);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "Retention")) {
            governanceActions.setRetention((Retention)omasClassification);
            term.setGovernanceActions(governanceActions);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "SpineObject")) {
            term.setSpineObject(true);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "SpineAttribute")) {
            term.setSpineAttribute(true);
            handled = true;
        } else if (this.repositoryHelper.isTypeOf(sourceName, classificationName, "ObjectIdentifier")) {
            term.setObjectIdentifier(true);
            handled = true;
        }
        return handled;
    }

    @Override
    protected List<Classification> getInlinedClassifications(Node node) {
        ArrayList<Classification> inlinedClassifications = new ArrayList<Classification>();
        Term term = (Term)node;
        GovernanceActions governanceActions = term.getGovernanceActions();
        if (governanceActions != null) {
            Criticality criticality = governanceActions.getCriticality();
            Confidence confidence = governanceActions.getConfidence();
            Confidentiality confidentiality = governanceActions.getConfidentiality();
            Retention retention = governanceActions.getRetention();
            if (criticality != null) {
                inlinedClassifications.add((Classification)criticality);
            }
            if (confidence != null) {
                inlinedClassifications.add((Classification)confidence);
            }
            if (confidentiality != null) {
                inlinedClassifications.add((Classification)confidentiality);
            }
            if (retention != null) {
                inlinedClassifications.add((Classification)retention);
            }
        }
        if (term.isSpineObject()) {
            inlinedClassifications.add((Classification)new SpineObject());
        }
        if (term.isSpineAttribute()) {
            inlinedClassifications.add((Classification)new SpineAttribute());
        }
        if (term.isObjectIdentifier()) {
            inlinedClassifications.add((Classification)new SpineObject());
        }
        return inlinedClassifications;
    }

    @Override
    protected String getTypeName() {
        return GLOSSARY_TERM;
    }
}

