/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.graph;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeMapper.class);
    private static final String className = NodeTypeMapper.class.getName();

    public static String mapNodeTypeToEntityTypeGuid(NodeType nodeType) throws InvalidParameterException {
        String entityTypeName = nodeType.name();
        if (nodeType.name().equals("Term") || nodeType.name().equals("Activity")) {
            entityTypeName = "GlossaryTerm";
        } else if (nodeType.name().equals("Category") || nodeType.name().equals("SubjectAreaDefinition")) {
            entityTypeName = "GlossaryCategory";
        } else if (nodeType.name().equals("Taxonomy") || nodeType.name().equals("CanonicalGlossary") || nodeType.name().equals("TaxonomyAndCanonicalGlossary")) {
            entityTypeName = "Glossary";
        } else if (nodeType.name().equals("GlossaryProject")) {
            entityTypeName = "Project";
        }
        return OpenMetadataTypesArchiveAccessor.getInstance().getEntityDefByName(entityTypeName).getGUID();
    }

    public static NodeType mapEntityTypeGuidToNodeType(String guid) {
        String nodeTypeName = OpenMetadataTypesArchiveAccessor.getInstance().getEntityDefByGuid(guid).getName();
        if (nodeTypeName.equals("GlossaryTerm")) {
            nodeTypeName = "Term";
        }
        if (nodeTypeName.equals("GlossaryCategory")) {
            nodeTypeName = "Category";
        }
        NodeType nodeType = null;
        for (NodeType nodeTypeToCheck : NodeType.values()) {
            if (!nodeTypeToCheck.name().equals(nodeTypeName)) continue;
            nodeType = nodeTypeToCheck;
            break;
        }
        return nodeType;
    }
}

