/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryAnchorMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(CategoryAnchorMapper.class);
    private static final String className = CategoryAnchorMapper.class.getName();
    public static final String CATEGORY_ANCHOR = "CategoryAnchor";

    public CategoryAnchorMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected String getProxy1Guid(Line line) {
        CategoryAnchorRelationship categoryAnchor = (CategoryAnchorRelationship)line;
        return categoryAnchor.getGlossaryGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        CategoryAnchorRelationship categoryAnchor = (CategoryAnchorRelationship)line;
        return categoryAnchor.getCategoryGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), CATEGORY_ANCHOR).getGUID();
    }

    @Override
    protected String getTypeName() {
        return CATEGORY_ANCHOR;
    }

    @Override
    protected Line getLineInstance() {
        return new CategoryAnchorRelationship();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        CategoryAnchorRelationship categoryAnchorRelationship = (CategoryAnchorRelationship)line;
        categoryAnchorRelationship.setGlossaryGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        CategoryAnchorRelationship categoryAnchorRelationship = (CategoryAnchorRelationship)line;
        categoryAnchorRelationship.setCategoryGuid(guid);
    }
}

