/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryHierarchyLinkMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(CategoryHierarchyLinkMapper.class);
    private static final String className = CategoryHierarchyLinkMapper.class.getName();
    public static final String CATEGORY_HIERARCHY_LINK = "CategoryHierarchyLink";

    public CategoryHierarchyLinkMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected String getProxy1Guid(Line line) {
        CategoryHierarchyLink categoryHierarchyLink = (CategoryHierarchyLink)line;
        return categoryHierarchyLink.getSuperCategoryGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        CategoryHierarchyLink categoryHierarchyLink = (CategoryHierarchyLink)line;
        return categoryHierarchyLink.getSubCategoryGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), CATEGORY_HIERARCHY_LINK).getGUID();
    }

    @Override
    protected String getTypeName() {
        return CATEGORY_HIERARCHY_LINK;
    }

    @Override
    protected Line getLineInstance() {
        return new CategoryHierarchyLink();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        CategoryHierarchyLink categoryHierarchyLink = (CategoryHierarchyLink)line;
        categoryHierarchyLink.setSuperCategoryGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        CategoryHierarchyLink categoryHierarchyLink = (CategoryHierarchyLink)line;
        categoryHierarchyLink.setSubCategoryGuid(guid);
    }
}

