/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScopeRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectScopeMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(ProjectScopeMapper.class);
    private static final String className = ProjectScopeMapper.class.getName();
    public static final String PROJECT_SCOPE = "ProjectScope";

    public ProjectScopeMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected String getProxy1Guid(Line line) {
        ProjectScopeRelationship projectScope = (ProjectScopeRelationship)line;
        return projectScope.getProjectGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        ProjectScopeRelationship projectScope = (ProjectScopeRelationship)line;
        return projectScope.getNodeGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), PROJECT_SCOPE).getGUID();
    }

    @Override
    protected String getTypeName() {
        return PROJECT_SCOPE;
    }

    @Override
    protected Line getLineInstance() {
        return new ProjectScopeRelationship();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        ProjectScopeRelationship ProjectScopeRelationship2 = (ProjectScopeRelationship)line;
        ProjectScopeRelationship2.setProjectGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        ProjectScopeRelationship ProjectScopeRelationship2 = (ProjectScopeRelationship)line;
        ProjectScopeRelationship2.setNodeGuid(guid);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        ProjectScopeRelationship projectScope = (ProjectScopeRelationship)line;
        if (projectScope.getScopeDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, projectScope.getScopeDescription(), "scopeDescription");
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        ProjectScopeRelationship projectScope = (ProjectScopeRelationship)line;
        boolean foundProperty = false;
        if (propertyName.equals("scopeDescription")) {
            projectScope.setScopeDescription(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }
}

