/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermAnchorMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(TermAnchorMapper.class);
    private static final String className = TermAnchorMapper.class.getName();
    public static final String TERM_ANCHOR = "TermAnchor";

    public TermAnchorMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected String getProxy1Guid(Line line) {
        TermAnchorRelationship termAnchor = (TermAnchorRelationship)line;
        return termAnchor.getGlossaryGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        TermAnchorRelationship termAnchor = (TermAnchorRelationship)line;
        return termAnchor.getTermGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), TERM_ANCHOR).getGUID();
    }

    @Override
    protected String getTypeName() {
        return TERM_ANCHOR;
    }

    @Override
    protected Line getLineInstance() {
        return new TermAnchorRelationship();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        TermAnchorRelationship termAnchorRelationship = (TermAnchorRelationship)line;
        termAnchorRelationship.setGlossaryGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        TermAnchorRelationship termAnchorRelationship = (TermAnchorRelationship)line;
        termAnchorRelationship.setTermGuid(guid);
    }
}

