/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermHASARelationshipMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(TermHASARelationshipMapper.class);
    private static final String className = TermHASARelationshipMapper.class.getName();
    public static final String TERM_HASA_RELATIONSHIP = "TermHASARelationship";

    public TermHASARelationshipMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        if (termHASARelationship.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termHASARelationship.getDescription(), "description");
        }
        if (termHASARelationship.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termHASARelationship.getSteward(), "steward");
        }
        if (termHASARelationship.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termHASARelationship.getSource(), "source");
        }
        if (termHASARelationship.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(termHASARelationship.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            termHASARelationship.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            termHASARelationship.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            termHASARelationship.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToLine(Line line, String propertyName, EnumPropertyValue enumPropertyValue) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            termHASARelationship.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        return termHASARelationship.getOwningTermGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        return termHASARelationship.getOwnedTermGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), TERM_HASA_RELATIONSHIP).getGUID();
    }

    @Override
    protected String getTypeName() {
        return TERM_HASA_RELATIONSHIP;
    }

    @Override
    protected Line getLineInstance() {
        return new TermHASARelationship();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        termHASARelationship.setOwningTermGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        TermHASARelationship termHASARelationship = (TermHASARelationship)line;
        termHASARelationship.setOwnedTermGuid(guid);
    }
}

