/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermTYPEDBYRelationshipMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(TermTYPEDBYRelationshipMapper.class);
    private static final String className = TermTYPEDBYRelationshipMapper.class.getName();
    public static final String TERM_TYPEDBY_RELATIONSHIP = "TermTYPEDBYRelationship";

    public TermTYPEDBYRelationshipMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        if (termTYPEDBYRelationship.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termTYPEDBYRelationship.getDescription(), "description");
        }
        if (termTYPEDBYRelationship.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termTYPEDBYRelationship.getSteward(), "steward");
        }
        if (termTYPEDBYRelationship.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termTYPEDBYRelationship.getSource(), "source");
        }
        if (termTYPEDBYRelationship.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(termTYPEDBYRelationship.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            termTYPEDBYRelationship.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            termTYPEDBYRelationship.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            termTYPEDBYRelationship.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToLine(Line line, String propertyName, EnumPropertyValue enumPropertyValue) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            termTYPEDBYRelationship.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        return termTYPEDBYRelationship.getAttributeGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        return termTYPEDBYRelationship.getTypeGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), TERM_TYPEDBY_RELATIONSHIP).getGUID();
    }

    @Override
    protected String getTypeName() {
        return TERM_TYPEDBY_RELATIONSHIP;
    }

    @Override
    protected Line getLineInstance() {
        return new TermTYPEDBYRelationship();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        termTYPEDBYRelationship.setAttributeGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        TermTYPEDBYRelationship termTYPEDBYRelationship = (TermTYPEDBYRelationship)line;
        termTYPEDBYRelationship.setTypeGuid(guid);
    }
}

