/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(TranslationMapper.class);
    private static final String className = TranslationMapper.class.getName();
    public static final String TRANSLATION = "Translation";

    public TranslationMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        Translation translation = (Translation)line;
        if (translation.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, translation.getDescription(), "description");
        }
        if (translation.getExpression() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, translation.getExpression(), "expression");
        }
        if (translation.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, translation.getSteward(), "steward");
        }
        if (translation.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, translation.getSource(), "source");
        }
        if (translation.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(translation.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        Translation translation = (Translation)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            translation.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("expression")) {
            translation.setExpression(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            translation.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            translation.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        Translation translation = (Translation)line;
        return translation.getTranslation1Guid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        Translation translation = (Translation)line;
        return translation.getTranslation2Guid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), TRANSLATION).getGUID();
    }

    @Override
    protected String getTypeName() {
        return TRANSLATION;
    }

    @Override
    protected Line getLineInstance() {
        return new Translation();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        Translation translation = (Translation)line;
        translation.setTranslation1Guid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        Translation translation = (Translation)line;
        translation.setTranslation2Guid(guid);
    }
}

