/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidValueMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(ValidValueMapper.class);
    private static final String className = ValidValueMapper.class.getName();
    public static final String VALID_VALUE = "ValidValue";

    public ValidValueMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        ValidValue validValue = (ValidValue)line;
        if (validValue.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, validValue.getDescription(), "description");
        }
        if (validValue.getExpression() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, validValue.getExpression(), "expression");
        }
        if (validValue.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, validValue.getSteward(), "steward");
        }
        if (validValue.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, validValue.getSource(), "source");
        }
        if (validValue.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(validValue.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        ValidValue validValue = (ValidValue)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            validValue.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("expression")) {
            validValue.setExpression(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            validValue.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            validValue.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToLine(Line line, String propertyName, EnumPropertyValue enumPropertyValue) {
        ValidValue validValue = (ValidValue)line;
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            validValue.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        ValidValue validValue = (ValidValue)line;
        return validValue.getTermGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        ValidValue validValue = (ValidValue)line;
        return validValue.getValidValueGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), VALID_VALUE).getGUID();
    }

    @Override
    protected String getTypeName() {
        return VALID_VALUE;
    }

    @Override
    protected Line getLineInstance() {
        return new ValidValue();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        ValidValue validValue = (ValidValue)line;
        validValue.setTermGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        ValidValue validValue = (ValidValue)line;
        validValue.setValidValueGuid(guid);
    }
}

