/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryRESTServices.class);
    private static final String className = SubjectAreaCategoryRESTServices.class.getName();

    public SubjectAreaCategoryRESTServices() {
    }

    public SubjectAreaCategoryRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createCategory(String serverName, String userId, Category suppliedCategory) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "createCategory")) == null) {
            try {
                EntityDetail entityDetail;
                String suppliedCategoryName;
                InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
                SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
                glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
                String suppliedCategoryParentGuid = null;
                if (suppliedCategory.getParentCategory() != null) {
                    suppliedCategoryParentGuid = suppliedCategory.getParentCategory().getGuid();
                }
                if ((suppliedCategoryName = suppliedCategory.getName()) == null || suppliedCategoryName.equals("")) {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createCategory"});
                    log.error(errorMessage);
                    throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createCategory", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
                SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation(serverName, userId, "createCategory", suppliedGlossary, glossaryRESTServices);
                if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary) && (response = this.oMRSAPIHelper.callOMRSAddEntity("createCategory", userId, entityDetail = new CategoryMapper(this.oMRSAPIHelper).mapNodeToEntityDetail((Node)suppliedCategory))).getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    entityDetail = entityDetailResponse.getEntityDetail();
                    String categoryGuid = entityDetail.getGUID();
                    Glossary associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                    String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                    CategoryAnchorRelationship categoryAnchor = new CategoryAnchorRelationship();
                    categoryAnchor.setGlossaryGuid(glossaryGuid);
                    categoryAnchor.setCategoryGuid(categoryGuid);
                    Relationship categoryAnchorRelationship = new CategoryAnchorMapper(this.oMRSAPIHelper).mapLineToRelationship((Line)categoryAnchor);
                    response = this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, categoryAnchorRelationship);
                    if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                        if (suppliedCategoryParentGuid != null) {
                            CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
                            categoryHierarchyLink.setSuperCategoryGuid(suppliedCategoryParentGuid);
                            categoryHierarchyLink.setSubCategoryGuid(categoryGuid);
                            Relationship relationship = new CategoryHierarchyLinkMapper(this.oMRSAPIHelper).mapLineToRelationship((Line)categoryHierarchyLink);
                            response = this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, relationship);
                        }
                        if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                            response = this.getCategory(serverName, userId, categoryGuid);
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = this.initializeAPI(serverName, userId, "getCategory");
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getCategory", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getCategory", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                EntityDetail gotEntityDetail = entityDetailResponse.getEntityDetail();
                CategoryMapper categoryMapper = new CategoryMapper(this.oMRSAPIHelper);
                Category gotCategory = (Category)categoryMapper.mapEntityDetailToNode(gotEntityDetail);
                String anchorTypeGuid = TypeGuids.getCategoryAnchorTypeGuid();
                response = this.oMRSAPIHelper.callGetRelationshipsForEntity("getCategory", userId, guid, anchorTypeGuid, 0, null, null, null, 0);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                    RelationshipsResponse relationshipsResponse = (RelationshipsResponse)response;
                    List<Relationship> glossaryRelationships = relationshipsResponse.getRelationships();
                    if (glossaryRelationships.iterator().hasNext()) {
                        Relationship glossaryRelationship = glossaryRelationships.iterator().next();
                        CategoryAnchorRelationship categoryAnchor = (CategoryAnchorRelationship)new CategoryAnchorMapper(this.oMRSAPIHelper).mapRelationshipToLine(glossaryRelationship);
                        response = SubjectAreaUtils.getGlossarySummaryForCategory("getCategory", userId, this.oMRSAPIHelper, (Line)categoryAnchor);
                        if (response.getResponseCategory().equals((Object)ResponseCategory.GlossarySummary)) {
                            GlossarySummaryResponse glossarySummaryResponse = (GlossarySummaryResponse)response;
                            GlossarySummary glossarySummary = glossarySummaryResponse.getGlossarySummary();
                            gotCategory.setGlossary(glossarySummary);
                            response = this.getResponse(gotCategory);
                        }
                    } else {
                        response = this.getResponse(gotCategory);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getResponse(Category gotCategory) {
        CategoryResponse response;
        if (gotCategory.getNodeType() == NodeType.SubjectAreaDefinition) {
            SubjectAreaDefinition subjectAreaDefinition = (SubjectAreaDefinition)gotCategory;
            response = new SubjectAreaDefinitionResponse(subjectAreaDefinition);
        } else {
            response = new CategoryResponse(gotCategory);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findCategory(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "findCategory")) == null && (response = this.oMRSAPIHelper.findEntitiesByPropertyValue("findCategory", userId, "GlossaryCategory", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findCategory")).getResponseCategory() == ResponseCategory.OmrsEntityDetails) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entitydetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Category> categories = new ArrayList<Category>();
            if (entitydetails == null) {
                response = new CategoriesResponse(categories);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entitydetails.iterator();
                while (iterator.hasNext() && (response = this.getCategory(serverName, userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Category) {
                    CategoryResponse categoryResponse = (CategoryResponse)response;
                    Category category = categoryResponse.getCategory();
                    categories.add(category);
                }
                if (response.getResponseCategory() == ResponseCategory.Category) {
                    response = new CategoriesResponse(categories);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String restAPIName = "getCategoryRelationships";
        return this.getRelationshipsFromGuid(serverName, restAPIName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateCategory(String serverName, String userId, String guid, Category suppliedCategory, boolean isReplace) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "updateCategory")) == null) {
            try {
                InputValidator.validateUserIdNotNull((String)className, (String)"updateCategory", (String)userId);
                InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
                InputValidator.validateGUIDNotNull((String)className, (String)"updateCategory", (String)guid, (String)"guid");
                response = this.getCategory(serverName, userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                    Status status;
                    Category originalCategory = ((CategoryResponse)response).getCategory();
                    if (originalCategory.getSystemAttributes() != null) {
                        status = originalCategory.getSystemAttributes().getStatus();
                        SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY);
                    }
                    if (suppliedCategory.getSystemAttributes() != null) {
                        status = suppliedCategory.getSystemAttributes().getStatus();
                        SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED);
                    }
                    Category updateCategory = originalCategory;
                    if (isReplace) {
                        updateCategory.setName(suppliedCategory.getName());
                        updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                        updateCategory.setDescription(suppliedCategory.getDescription());
                        updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                    } else {
                        if (suppliedCategory.getName() != null) {
                            updateCategory.setName(suppliedCategory.getName());
                        }
                        if (suppliedCategory.getQualifiedName() != null) {
                            updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                        }
                        if (suppliedCategory.getDescription() != null) {
                            updateCategory.setDescription(suppliedCategory.getDescription());
                        }
                        if (suppliedCategory.getAdditionalProperties() != null) {
                            updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                        }
                    }
                    Date termFromTime = suppliedCategory.getEffectiveFromTime();
                    Date termToTime = suppliedCategory.getEffectiveToTime();
                    updateCategory.setEffectiveFromTime(termFromTime);
                    updateCategory.setEffectiveToTime(termToTime);
                    CategoryMapper mapper = new CategoryMapper(this.oMRSAPIHelper);
                    EntityDetail updateEntityDetail = mapper.mapNodeToEntityDetail((Node)updateCategory);
                    String categoryGuid = updateCategory.getSystemAttributes().getGUID();
                    response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateCategory", userId, updateEntityDetail);
                    if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                        response = this.getCategory(serverName, userId, categoryGuid);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String serverName, String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userId=" + userId + ", guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "deleteCategory")) == null) {
            OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"deleteCategory", (String)guid, (String)"guid");
                String source = this.oMRSAPIHelper.getServiceName();
                String typeDefName = "GlossaryCategory";
                String typeDefGuid = repositoryHelper.getTypeDefByName(source, typeDefName).getGUID();
                if (isPurge.booleanValue()) {
                    response = this.oMRSAPIHelper.callOMRSPurgeEntity("deleteCategory", userId, typeDefName, typeDefGuid, guid);
                } else {
                    response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteCategory", userId, typeDefName, typeDefGuid, guid);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                        CategoryMapper categoryMapper = new CategoryMapper(this.oMRSAPIHelper);
                        Category deletedCategory = (Category)categoryMapper.mapEntityDetailToNode(entityDetail);
                        response = this.getResponse(deletedCategory);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = this.initializeAPI(serverName, userId, "restoreCategory");
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreCategory", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreCategory", userId, guid);
            if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                response = this.getCategory(serverName, userId, guid);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

