/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalTaxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGlossaryRESTServices.class);
    private static final String className = SubjectAreaGlossaryRESTServices.class.getName();

    public SubjectAreaGlossaryRESTServices() {
    }

    public SubjectAreaGlossaryRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "createGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createGlossary,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "createGlossary")) == null) {
            SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
                String suppliedGlossaryName = suppliedGlossary.getName();
                if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createGlossary"});
                    log.error(errorMessage);
                    throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
                EntityDetail glossaryEntityDetail = glossaryMapper.mapNodeToEntityDetail((Node)suppliedGlossary);
                response = this.oMRSAPIHelper.callOMRSAddEntity("createGlossary", userId, glossaryEntityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                    response = this.getGlossaryByGuid(serverName, userId, entityDetail.getGUID());
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createGlossary,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryByGuid(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGlossary,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "getGlossary")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"getGlossary", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getGlossary", userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getResponse(response);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGlossary,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findGlossary(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "findGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findGlossary,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "findGlossary")) == null && (response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType(this.oMRSAPIHelper, "findGlossary", userId, "Glossary", asOfTime, offset, pageSize) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findGlossary", userId, "Glossary", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findGlossary")).getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entityDetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Glossary> glossaries = new ArrayList<Glossary>();
            if (entityDetails == null) {
                response = new GlossariesResponse(glossaries);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entityDetails.iterator();
                while (iterator.hasNext() && (response = this.getGlossaryByGuid(serverName, userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Glossary) {
                    GlossaryResponse glossaryResponse = (GlossaryResponse)response;
                    Glossary glossary = glossaryResponse.getGlossary();
                    glossaries.add(glossary);
                }
                if (response.getResponseCategory() == ResponseCategory.Glossary) {
                    response = new GlossariesResponse(glossaries);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findGlossary,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        return this.getRelationshipsFromGuid(serverName, methodName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateGlossary(String serverName, String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateGlossary,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        response = this.initializeAPI(serverName, userId, "updateGlossary");
        if (response == null) {
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
                InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossary", (String)guid, (String)"guid");
                response = this.getGlossaryByGuid(serverName, userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                    Glossary originalGlossary;
                    Glossary updateGlossary = originalGlossary = ((GlossaryResponse)response).getGlossary();
                    if (isReplace) {
                        updateGlossary.setName(suppliedGlossary.getName());
                        updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                        updateGlossary.setDescription(suppliedGlossary.getDescription());
                        updateGlossary.setUsage(suppliedGlossary.getUsage());
                        updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                    } else {
                        if (suppliedGlossary.getName() != null) {
                            updateGlossary.setName(suppliedGlossary.getName());
                        }
                        if (suppliedGlossary.getQualifiedName() != null) {
                            updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                        }
                        if (suppliedGlossary.getDescription() != null) {
                            updateGlossary.setDescription(suppliedGlossary.getDescription());
                        }
                        if (suppliedGlossary.getUsage() != null) {
                            updateGlossary.setUsage(suppliedGlossary.getUsage());
                        }
                        if (suppliedGlossary.getAdditionalProperties() != null) {
                            updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                        }
                    }
                    Date termFromTime = suppliedGlossary.getEffectiveFromTime();
                    Date termToTime = suppliedGlossary.getEffectiveToTime();
                    updateGlossary.setEffectiveFromTime(termFromTime);
                    updateGlossary.setEffectiveToTime(termToTime);
                    GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
                    EntityDetail entityDetail = glossaryMapper.mapNodeToEntityDetail((Node)updateGlossary);
                    String glossaryGuid = entityDetail.getGUID();
                    response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateGlossary", userId, entityDetail);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        response = this.getGlossaryByGuid(serverName, userId, glossaryGuid);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteGlossary(String serverName, String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteGlossary,userId=" + userId + ", guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "deleteGlossary")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossary", (String)guid, (String)"guid");
                ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
                statusList.add(InstanceStatus.ACTIVE);
                OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
                String source = this.oMRSAPIHelper.getServiceName();
                String glossaryTypeDefName = "Glossary";
                String glossaryTypeDefGuid = repositoryHelper.getTypeDefByName(source, glossaryTypeDefName).getGUID();
                if (isPurge.booleanValue()) {
                    this.oMRSAPIHelper.callOMRSPurgeEntity("deleteGlossary", userId, glossaryTypeDefName, glossaryTypeDefGuid, guid);
                    response = new VoidResponse();
                } else {
                    String termAnchorGuid = repositoryHelper.getTypeDefByName("deleteGlossary", "TermAnchor").getGUID();
                    String categoryAnchorGuid = repositoryHelper.getTypeDefByName("deleteGlossary", "TermAnchor").getGUID();
                    response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteGlossary", userId, guid, termAnchorGuid, 0, statusList, null, null, null, 1);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                        RelationshipsResponse termAnchorRelationshipsResponse = (RelationshipsResponse)response;
                        List<Relationship> termRelationships = termAnchorRelationshipsResponse.getRelationships();
                        response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteGlossary", userId, guid, categoryAnchorGuid, 0, statusList, null, null, null, 1);
                        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                            RelationshipsResponse categoryAnchorRelationshipsResponse = (RelationshipsResponse)response;
                            List<Relationship> categoryRelationships = categoryAnchorRelationshipsResponse.getRelationships();
                            if ((termRelationships == null || termRelationships.isEmpty()) && (categoryRelationships == null || categoryRelationships.isEmpty())) {
                                response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteGlossary", userId, glossaryTypeDefName, glossaryTypeDefGuid, guid);
                                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                                    response = this.getResponse(response);
                                }
                            } else {
                                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE;
                                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "deleteGlossary", guid});
                                log.error(errorMessage);
                                InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "deleteGlossary", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
                            }
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteGlossary,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreGlossary(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "restoreGlossary";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreGlossary,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "restoreGlossary")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossary", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreGlossary", userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getGlossaryByGuid(serverName, userId, guid);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreGlossary,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
        Glossary glossary = null;
        try {
            glossary = glossaryMapper.mapEntityDetailToNode(entityDetail);
            if (glossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                CanonicalTaxonomy canonicalTaxonomy = (CanonicalTaxonomy)glossary;
                response = new GlossaryResponse((Glossary)canonicalTaxonomy);
            } else if (glossary.getNodeType() == NodeType.Taxonomy) {
                Taxonomy taxonomy = (Taxonomy)glossary;
                response = new GlossaryResponse((Glossary)taxonomy);
            } else if (glossary.getNodeType() == NodeType.CanonicalGlossary) {
                CanonicalGlossary canonicalGlossary = (CanonicalGlossary)glossary;
                response = new GlossaryResponse((Glossary)canonicalGlossary);
            } else {
                response = new GlossaryResponse(glossary);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }
}

