/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGraphRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaProjectRESTServices.class);
    private static final String className = SubjectAreaProjectRESTServices.class.getName();

    public SubjectAreaProjectRESTServices() {
    }

    public SubjectAreaProjectRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createProject(String serverName, String userId, Project suppliedProject) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "createProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProject,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "createProject")) == null) {
            SubjectAreaProjectRESTServices ProjectRESTServices = new SubjectAreaProjectRESTServices();
            ProjectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "createProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
                String suppliedProjectName = suppliedProject.getName();
                if (suppliedProjectName == null || suppliedProjectName.equals("")) {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.PROJECT_CREATE_WITHOUT_NAME;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createProject"});
                    log.error(errorMessage);
                    throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createProject", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                ProjectMapper ProjectMapper2 = new ProjectMapper(this.oMRSAPIHelper);
                suppliedProject.setNodeType(NodeType.GlossaryProject);
                EntityDetail projectEntityDetail = ProjectMapper2.mapNodeToEntityDetail((Node)suppliedProject);
                response = this.oMRSAPIHelper.callOMRSAddEntity("createProject", userId, projectEntityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                    response = this.getProjectByGuid(serverName, userId, entityDetail.getGUID());
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectByGuid(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProject,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "getProject")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"getProject", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getProject", userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getResponse(response);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProject,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findProject(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "findProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findProject,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "findProject")) == null && (response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType(this.oMRSAPIHelper, "findProject", userId, "Project", asOfTime, offset, pageSize) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findProject", userId, "Project", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findProject")).getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entityDetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Project> projects = new ArrayList<Project>();
            if (entityDetails == null) {
                response = new ProjectsResponse(projects);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entityDetails.iterator();
                while (iterator.hasNext() && (response = this.getProjectByGuid(serverName, userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Project) {
                    ProjectResponse projectResponse = (ProjectResponse)response;
                    Project project = projectResponse.getProject();
                    projects.add(project);
                }
                if (response.getResponseCategory() == ResponseCategory.Project) {
                    response = new ProjectsResponse(projects);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findProject,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        return this.getRelationshipsFromGuid(serverName, methodName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse getProjectTerms(String serverName, String userId, String guid, Date asOfTime) {
        String methodName = "getProjectTerms";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        SubjectAreaGraphRESTServices subjectAreaGraphRESTServices = new SubjectAreaGraphRESTServices(this.oMRSAPIHelper);
        String nodeFilter = new HashSet<NodeType>(Arrays.asList(NodeType.Project, NodeType.Term, NodeType.GlossaryProject, NodeType.Activity)).toString();
        String lineFilter = new HashSet<LineType>(Arrays.asList(LineType.ProjectScope)).toString();
        SubjectAreaOMASAPIResponse response = subjectAreaGraphRESTServices.getGraph(serverName, userId, guid, asOfTime, nodeFilter, lineFilter, null, 1);
        ArrayList<Term> terms = null;
        if (response.getResponseCategory() == ResponseCategory.Graph) {
            Set nodes;
            GraphResponse graphResponse = (GraphResponse)response;
            Graph graph = graphResponse.getGraph();
            if (graph != null && (nodes = graph.getNodes()) != null) {
                for (Node node : nodes) {
                    if (node.getNodeType() != NodeType.Term) continue;
                    if (terms == null) {
                        terms = new ArrayList<Term>();
                    }
                    terms.add((Term)node);
                }
            }
            response = new TermsResponse(terms);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateProject(String serverName, String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProject,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        response = this.initializeAPI(serverName, userId, "updateProject");
        if (response == null) {
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "updateProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
                InputValidator.validateGUIDNotNull((String)className, (String)"updateProject", (String)guid, (String)"guid");
                response = this.getProjectByGuid(serverName, userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.Project)) {
                    Project originalProject;
                    Project updateProject = originalProject = ((ProjectResponse)response).getProject();
                    if (isReplace) {
                        updateProject.setName(suppliedProject.getName());
                        updateProject.setQualifiedName(suppliedProject.getQualifiedName());
                        updateProject.setDescription(suppliedProject.getDescription());
                        updateProject.setStartDate(suppliedProject.getStartDate());
                        updateProject.setPlannedEndDate(suppliedProject.getPlannedEndDate());
                        updateProject.setStatus(suppliedProject.getStatus());
                        updateProject.setAdditionalProperties(suppliedProject.getAdditionalProperties());
                    } else {
                        if (suppliedProject.getName() != null) {
                            updateProject.setName(suppliedProject.getName());
                        }
                        if (suppliedProject.getQualifiedName() != null) {
                            updateProject.setQualifiedName(suppliedProject.getQualifiedName());
                        }
                        if (suppliedProject.getDescription() != null) {
                            updateProject.setDescription(suppliedProject.getDescription());
                        }
                        if (suppliedProject.getStartDate() != null) {
                            updateProject.setStartDate(suppliedProject.getStartDate());
                        }
                        if (suppliedProject.getPlannedEndDate() != null) {
                            updateProject.setPlannedEndDate(suppliedProject.getPlannedEndDate());
                        }
                        if (suppliedProject.getStatus() != null) {
                            updateProject.setStatus(suppliedProject.getStatus());
                        }
                        if (suppliedProject.getAdditionalProperties() != null) {
                            updateProject.setAdditionalProperties(suppliedProject.getAdditionalProperties());
                        }
                    }
                    Date termFromTime = suppliedProject.getEffectiveFromTime();
                    Date termToTime = suppliedProject.getEffectiveToTime();
                    updateProject.setEffectiveFromTime(termFromTime);
                    updateProject.setEffectiveToTime(termToTime);
                    ProjectMapper ProjectMapper2 = new ProjectMapper(this.oMRSAPIHelper);
                    EntityDetail entityDetail = ProjectMapper2.mapNodeToEntityDetail((Node)updateProject);
                    String ProjectGuid = entityDetail.getGUID();
                    response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateProject", userId, entityDetail);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        response = this.getProjectByGuid(serverName, userId, ProjectGuid);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteProject(String serverName, String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProject,userId=" + userId + ", guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "deleteProject")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"deleteProject", (String)guid, (String)"guid");
                ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
                statusList.add(InstanceStatus.ACTIVE);
                OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
                String source = this.oMRSAPIHelper.getServiceName();
                String ProjectTypeDefName = "Project";
                String ProjectTypeDefGuid = repositoryHelper.getTypeDefByName(source, ProjectTypeDefName).getGUID();
                if (isPurge.booleanValue()) {
                    this.oMRSAPIHelper.callOMRSPurgeEntity("deleteProject", userId, ProjectTypeDefName, ProjectTypeDefGuid, guid);
                    response = new VoidResponse();
                } else {
                    response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteProject", userId, ProjectTypeDefName, ProjectTypeDefGuid, guid);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        response = this.getResponse(response);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteProject,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreProject(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "restoreProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProject,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "restoreProject")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"restoreProject", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreProject", userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getProjectByGuid(serverName, userId, guid);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreProject,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        ProjectMapper ProjectMapper2 = new ProjectMapper(this.oMRSAPIHelper);
        try {
            Project project = ProjectMapper2.mapEntityDetailToNode(entityDetail);
            if (project.getNodeType() == NodeType.GlossaryProject) {
                GlossaryProject glossaryProject = (GlossaryProject)project;
                response = new ProjectResponse((Project)glossaryProject);
            } else {
                response = new ProjectResponse(project);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }
}

