/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.initialization.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineBundle;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineBundleFactory;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ResponseFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRESTServicesInstance.class);
    private static final String className = SubjectAreaRESTServicesInstance.class.getName();
    protected OMRSAPIHelper oMRSAPIHelper = null;
    protected static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    protected SubjectAreaOMASAPIResponse initializeAPI(String serverName, String userId, String restAPIName) {
        return this.initializeAPI(serverName, userId, null, null, restAPIName);
    }

    protected SubjectAreaOMASAPIResponse initializeAPI(String serverName, String userId, Date from, Date to, String restAPIName) {
        SubjectAreaOMASAPIResponse response = null;
        OMRSRepositoryConnector omrsConnector = null;
        try {
            if (this.oMRSAPIHelper == null) {
                this.oMRSAPIHelper = new OMRSAPIHelper(instanceHandler.getAccessServiceName(serverName));
            }
            omrsConnector = instanceHandler.getRepositoryConnector(serverName);
            this.oMRSAPIHelper.setOMRSRepositoryConnector(omrsConnector, restAPIName);
            InputValidator.validateUserIdNotNull((String)className, (String)restAPIName, (String)userId);
            InputValidator.validateEffectiveDate((String)className, (String)restAPIName, (Date)to, (Date)from);
        }
        catch (MetadataServerUncontactableException e) {
            response = OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)e);
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String serverName, String restAPIName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "getRelationshipsFromGuid")) == null) {
            try {
                RelationshipsResponse relationshipsResponse;
                InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)guid, (String)"guid");
                if (offset == null) {
                    offset = new Integer(0);
                }
                if (pageSize == null) {
                    pageSize = new Integer(0);
                }
                if (sequencingProperty != null) {
                    sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
                }
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
                List<Relationship> omrsRelationships = null;
                response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships())).getResponseCategory() == ResponseCategory.Lines) {
                    LinesResponse linesResponse = (LinesResponse)response;
                    List linesToReturn = linesResponse.getLines();
                    if (pageSize > 0) {
                        int sizeToGet = 0;
                        if (omrsRelationships.size() > linesToReturn.size()) {
                            sizeToGet = omrsRelationships.size() - linesToReturn.size();
                        }
                        offset = offset + omrsRelationships.size();
                        while (sizeToGet > 0) {
                            List moreLines;
                            List<Relationship> moreOmrsRelationships;
                            response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, sizeToGet);
                            sizeToGet = 0;
                            if (response.getResponseCategory() != ResponseCategory.OmrsRelationships || (moreOmrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) == null || moreOmrsRelationships.size() <= 0 || (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships)).getResponseCategory() != ResponseCategory.Lines || (moreLines = (linesResponse = (LinesResponse)response).getLines()) == null || moreLines.isEmpty()) continue;
                            linesToReturn.addAll(moreLines);
                            sizeToGet = moreOmrsRelationships.size() - moreLines.size();
                            offset = offset + moreOmrsRelationships.size();
                        }
                        response = new LinesResponse(linesToReturn);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",entity guid=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            RelationshipsResponse relationshipsResponse;
            List<Relationship> omrsRelationships;
            InputValidator.validateUserIdNotNull((String)className, (String)"getRelationshipsFromGuid", (String)userId);
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)entityGuid, (String)"entityGuid");
            response = this.oMRSAPIHelper.callGetRelationshipsForEntity(restAPIName, userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) != null) {
                HashSet<Relationship> relationshipSet = new HashSet<Relationship>(omrsRelationships);
                response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ",guid=" + entityGuid);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse createLine(String serverName, String restAPIName, String userId, String className, Line line) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "createLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",className=" + className);
        }
        if ((response = this.initializeAPI(serverName, userId, methodName)) == null) {
            ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
            ILineBundle bundle = factory.getInstance(className);
            ILineMapper mapper = bundle.getMapper();
            try {
                Relationship omrsRelationship = mapper.mapLineToRelationship(line);
                response = this.oMRSAPIHelper.callOMRSAddRelationship(restAPIName, userId, omrsRelationship);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    Relationship createdOMRSRelationship = ((RelationshipResponse)response).getRelationship();
                    Line createdLine = mapper.mapRelationshipToLine(createdOMRSRelationship);
                    response = new ResponseFactory().getInstance(className, createdLine);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getLine(String serverName, String restAPIName, String userId, String className, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, methodName)) == null) {
            ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
            ILineBundle bundle = factory.getInstance(className);
            ILineMapper mapper = bundle.getMapper();
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, guid);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    Relationship createdOMRSRelationship = ((RelationshipResponse)response).getRelationship();
                    Line gotLine = mapper.mapRelationshipToLine(createdOMRSRelationship);
                    response = new ResponseFactory().getInstance(className, gotLine);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse updateLine(String serverName, String restAPIName, String userId, String className, Line line, boolean isReplace) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "updateLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",className=" + className, (Object)(",isReplace=" + isReplace));
        }
        if ((response = this.initializeAPI(serverName, userId, methodName)) == null) {
            ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
            ILineBundle bundle = factory.getInstance(className);
            ILineMapper mapper = bundle.getMapper();
            try {
                String relationshipGuid = line.getGuid();
                InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)relationshipGuid, (String)"termGuid");
                response = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, relationshipGuid);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    Relationship originalRelationship = ((RelationshipResponse)response).getRelationship();
                    Relationship relationshipToUpdate = mapper.mapLineToRelationship(line);
                    if (!isReplace && relationshipToUpdate.getProperties() != null && relationshipToUpdate.getProperties().getPropertyCount() > 0) {
                        Map updateInstanceProperties = relationshipToUpdate.getProperties().getInstanceProperties();
                        if (originalRelationship.getProperties() != null) {
                            Map orgInstanceProperties = originalRelationship.getProperties().getInstanceProperties();
                            for (String orgPropertyName : orgInstanceProperties.keySet()) {
                                if (updateInstanceProperties.keySet().contains(orgPropertyName)) continue;
                                updateInstanceProperties.put(orgPropertyName, orgInstanceProperties.get(orgPropertyName));
                            }
                        }
                        InstanceProperties instancePropertiesToUpdate = new InstanceProperties();
                        instancePropertiesToUpdate.setInstanceProperties(updateInstanceProperties);
                        instancePropertiesToUpdate.setEffectiveFromTime(line.getEffectiveFromTime());
                        instancePropertiesToUpdate.setEffectiveToTime(line.getEffectiveToTime());
                        relationshipToUpdate.setProperties(instancePropertiesToUpdate);
                    }
                    if (relationshipToUpdate.getProperties() == null || relationshipToUpdate.getProperties().getPropertyCount() == 0) {
                        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.LINE_UPDATE_ATTEMPTED_WITH_NO_PROPERTIES;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName});
                        log.error(errorMessage);
                        response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction()));
                    } else {
                        response = this.oMRSAPIHelper.callOMRSUpdateRelationship(restAPIName, userId, relationshipToUpdate);
                        if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                            Relationship updatedOmrsRelationship = ((RelationshipResponse)response).getRelationship();
                            Line updatedLine = mapper.mapRelationshipToLine(updatedOmrsRelationship);
                            response = new ResponseFactory().getInstance(className, updatedLine);
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteLine(String serverName, String restAPIName, String userId, String className, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid + ",isPurge=" + isPurge);
        }
        if ((response = this.initializeAPI(serverName, userId, methodName)) == null) {
            OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
            ILineBundle bundle = factory.getInstance(className);
            ILineMapper mapper = bundle.getMapper();
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
                StringTokenizer st = new StringTokenizer(className, ".");
                String typeName = bundle.getTypeName();
                String source = this.oMRSAPIHelper.getServiceName();
                String typeGuid = repositoryHelper.getTypeDefByName(source, typeName).getGUID();
                if (isPurge.booleanValue()) {
                    response = this.oMRSAPIHelper.callOMRSPurgeRelationship(restAPIName, userId, typeGuid, typeName, guid);
                } else {
                    response = this.oMRSAPIHelper.callOMRSDeleteRelationship(restAPIName, userId, typeGuid, typeName, guid);
                    if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                        Relationship omrsRelationship = ((RelationshipResponse)response).getRelationship();
                        Line deletedLine = mapper.mapRelationshipToLine(omrsRelationship);
                        response = new ResponseFactory().getInstance(className, deletedLine);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse restoreLine(String serverName, String restAPIName, String userId, String className, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, methodName)) == null) {
            ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
            ILineBundle bundle = factory.getInstance(className);
            ILineMapper mapper = bundle.getMapper();
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSRestoreRelationship(restAPIName, userId, guid);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    Relationship omrsRelationship = ((RelationshipResponse)response).getRelationship();
                    Line restoredLine = mapper.mapRelationshipToLine(omrsRelationship);
                    response = new ResponseFactory().getInstance(className, restoredLine);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

