/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.AbstractConcept;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ActivityDescription;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidence;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Confidentiality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ContextDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Criticality;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.DataValue;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.ObjectIdentifier;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Retention;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SpineObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.accessservices.subjectarea.validators.RestValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaTermRESTServices.class);
    private static final String className = SubjectAreaTermRESTServices.class.getName();
    public static final Set<String> SUBJECT_AREA_TERM_CLASSIFICATIONS = new HashSet<String>(Arrays.asList(SpineObject.class.getSimpleName(), SpineAttribute.class.getSimpleName(), ObjectIdentifier.class.getSimpleName(), Confidentiality.class.getSimpleName(), Confidence.class.getSimpleName(), Criticality.class.getSimpleName(), Retention.class.getSimpleName(), AbstractConcept.class.getSimpleName(), ActivityDescription.class.getSimpleName(), DataValue.class.getSimpleName(), ContextDefinition.class.getSimpleName()));

    public SubjectAreaTermRESTServices() {
    }

    public SubjectAreaTermRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createTerm(String serverName, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createTerm,userId=" + userId);
        }
        Glossary associatedGlossary = null;
        SubjectAreaOMASAPIResponse response = this.initializeAPI(serverName, userId, "createTerm");
        if (response == null) {
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
                SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
                glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
                String suppliedTermName = suppliedTerm.getName();
                if (suppliedTermName == null || suppliedTermName.equals("")) {
                    SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "createTerm"});
                    log.error(errorMessage);
                    throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "createTerm", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
                EntityDetail suppliedTermEntityDetail = termMapper.mapNodeToEntityDetail((Node)suppliedTerm);
                GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
                SubjectAreaOMASAPIResponse glossaryResponse = RestValidator.validateGlossarySummaryDuringCreation(serverName, userId, "createTerm", suppliedGlossary, glossaryRESTServices);
                if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                    associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                    response = this.oMRSAPIHelper.callOMRSAddEntity("createTerm", userId, suppliedTermEntityDetail);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                        EntityDetail createdTermEntityDetail = entityDetailResponse.getEntityDetail();
                        String termGuid = createdTermEntityDetail.getGUID();
                        String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                        TermAnchorRelationship termAnchor = new TermAnchorRelationship();
                        termAnchor.setGlossaryGuid(glossaryGuid);
                        termAnchor.setTermGuid(termGuid);
                        TermAnchorMapper termAnchorMapper = new TermAnchorMapper(this.oMRSAPIHelper);
                        Relationship relationship = termAnchorMapper.mapLineToRelationship((Line)termAnchor);
                        response = this.oMRSAPIHelper.callOMRSAddRelationship("createTerm", userId, relationship);
                        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationship)) {
                            response = this.getTermByGuid(serverName, userId, termGuid);
                        }
                    }
                } else {
                    response = glossaryResponse;
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermByGuid(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getTermByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getTermByGuid,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "getTermByGuid")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getTermByGuid", userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail gotEntityDetail = entityDetailResponse.getEntityDetail();
                    TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
                    Term gotTerm = (Term)termMapper.mapEntityDetailToNode(gotEntityDetail);
                    String anchorTypeGuid = TypeGuids.getTermAnchorTypeGuid();
                    response = this.oMRSAPIHelper.callGetRelationshipsForEntity("getTermByGuid", userId, guid, anchorTypeGuid, 0, null, null, null, 0);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                        RelationshipsResponse relationshipsResponse = (RelationshipsResponse)response;
                        List<Relationship> glossaryRelationships = relationshipsResponse.getRelationships();
                        if (glossaryRelationships.iterator().hasNext()) {
                            Relationship glossaryRelationship = glossaryRelationships.iterator().next();
                            TermAnchorRelationship termAnchor = (TermAnchorRelationship)new TermAnchorMapper(this.oMRSAPIHelper).mapRelationshipToLine(glossaryRelationship);
                            response = SubjectAreaUtils.getGlossarySummaryForTerm("getTermByGuid", userId, this.oMRSAPIHelper, termAnchor, gotTerm);
                            if (response.getResponseCategory().equals((Object)ResponseCategory.GlossarySummary)) {
                                GlossarySummaryResponse glossarySummaryResponse = (GlossarySummaryResponse)response;
                                GlossarySummary glossarySummary = glossarySummaryResponse.getGlossarySummary();
                                gotTerm.setGlossary(glossarySummary);
                                response = new TermResponse(gotTerm);
                            } else if (response == null) {
                                response = new TermResponse(gotTerm);
                            }
                        } else {
                            response = new TermResponse(gotTerm);
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String restAPIName = "getTermRelationships";
        return this.getRelationshipsFromGuid(serverName, restAPIName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse findTerm(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "findTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findTerm,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "findTerm")) == null && (response = this.oMRSAPIHelper.findEntitiesByPropertyValue("findTerm", userId, "GlossaryTerm", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findTerm")).getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entitydetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Term> terms = new ArrayList<Term>();
            if (entitydetails == null) {
                response = new TermsResponse(terms);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entitydetails.iterator();
                while (iterator.hasNext() && (response = this.getTermByGuid(serverName, userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Term) {
                    TermResponse termResponse = (TermResponse)response;
                    Term term = termResponse.getTerm();
                    terms.add(term);
                }
                if (response.getResponseCategory() == ResponseCategory.Term) {
                    response = new TermsResponse(terms);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findTerm,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTerm(String serverName, String userId, String guid, Term suppliedTerm, boolean isReplace) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "updateTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateTerm,userId=" + userId);
        }
        if ((response = this.initializeAPI(serverName, userId, "updateTerm")) == null) {
            TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
            try {
                InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term});
                InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
                response = this.getTermByGuid(serverName, userId, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.Term)) {
                    Term originalTerm = ((TermResponse)response).getTerm();
                    Term updateTerm = new Term();
                    updateTerm.setSystemAttributes(originalTerm.getSystemAttributes());
                    if (isReplace) {
                        updateTerm.setName(suppliedTerm.getName());
                        updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                        updateTerm.setDescription(suppliedTerm.getDescription());
                        updateTerm.setUsage(suppliedTerm.getUsage());
                        updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                        updateTerm.setExamples(suppliedTerm.getExamples());
                        updateTerm.setSpineObject(suppliedTerm.isSpineObject());
                        updateTerm.setSpineAttribute(suppliedTerm.isSpineAttribute());
                        updateTerm.setObjectIdentifier(suppliedTerm.isObjectIdentifier());
                        updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                    } else {
                        if (suppliedTerm.getName() == null) {
                            updateTerm.setName(originalTerm.getName());
                        } else {
                            updateTerm.setName(suppliedTerm.getName());
                        }
                        if (suppliedTerm.getQualifiedName() == null) {
                            updateTerm.setQualifiedName(originalTerm.getQualifiedName());
                        } else {
                            updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                        }
                        if (suppliedTerm.getDescription() == null) {
                            updateTerm.setDescription(originalTerm.getDescription());
                        } else {
                            updateTerm.setDescription(suppliedTerm.getDescription());
                        }
                        if (suppliedTerm.getUsage() == null) {
                            updateTerm.setUsage(originalTerm.getUsage());
                        } else {
                            updateTerm.setUsage(suppliedTerm.getUsage());
                        }
                        if (suppliedTerm.getAbbreviation() == null) {
                            updateTerm.setAbbreviation(originalTerm.getAbbreviation());
                        } else {
                            updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                        }
                        if (suppliedTerm.getAdditionalProperties() == null) {
                            updateTerm.setAdditionalProperties(originalTerm.getAdditionalProperties());
                        } else {
                            updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                        }
                        if (suppliedTerm.getExamples() == null) {
                            updateTerm.setExamples(originalTerm.getExamples());
                        } else {
                            updateTerm.setExamples(suppliedTerm.getExamples());
                        }
                    }
                    GovernanceActions suppliedGovernanceActions = suppliedTerm.getGovernanceActions();
                    updateTerm.setGovernanceActions(suppliedGovernanceActions);
                    Date termFromTime = suppliedTerm.getEffectiveFromTime();
                    Date termToTime = suppliedTerm.getEffectiveToTime();
                    updateTerm.setEffectiveFromTime(termFromTime);
                    updateTerm.setEffectiveToTime(termToTime);
                    EntityDetail updateEntityDetail = termMapper.mapNodeToEntityDetail((Node)updateTerm);
                    response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateTerm", userId, updateEntityDetail);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        if (updateEntityDetail.getClassifications() != null && !updateEntityDetail.getClassifications().isEmpty()) {
                            Classification classification;
                            Iterator iterator = updateEntityDetail.getClassifications().iterator();
                            while (iterator.hasNext() && (response = this.oMRSAPIHelper.callOMRSClassifyEntity("updateTerm", userId, guid, (classification = (Classification)iterator.next()).getName(), classification.getProperties())).getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                            }
                        }
                        if (updateEntityDetail.getClassifications() != null && !updateEntityDetail.getClassifications().isEmpty()) {
                            Set currentClassificationNames = updateEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toSet());
                            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getRetention() != null && !currentClassificationNames.contains("Retention")) {
                                response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Retention");
                            }
                            if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getCriticality() != null && !currentClassificationNames.contains("Criticality")) {
                                response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Criticality");
                            }
                            if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getConfidence() != null && !currentClassificationNames.contains("Confidence")) {
                                response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Confidence");
                            }
                            if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getConfidentiality() != null && !currentClassificationNames.contains("Confidentility")) {
                                response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Confidentility");
                            }
                        }
                        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                            response = this.getTermByGuid(serverName, userId, guid);
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTerm(String serverName, String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "deleteTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteTerm,userId=" + userId + ", guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "deleteTerm")) == null) {
            OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
                String source = this.oMRSAPIHelper.getServiceName();
                String typeDefName = "GlossaryTerm";
                String typeDefGuid = repositoryHelper.getTypeDefByName(source, typeDefName).getGUID();
                if (isPurge.booleanValue()) {
                    response = this.oMRSAPIHelper.callOMRSPurgeEntity("deleteTerm", userId, typeDefName, typeDefGuid, guid);
                } else {
                    response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteTerm", userId, typeDefName, typeDefGuid, guid);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                        TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
                        Term term = (Term)termMapper.mapEntityDetailToNode(entityDetail);
                        response = new TermResponse(term);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTerm(String serverName, String userId, String guid) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "restoreTerm";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreTerm,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "restoreTerm")) == null) {
            try {
                InputValidator.validateGUIDNotNull((String)className, (String)"restoreTerm", (String)guid, (String)"guid");
                response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreTerm", userId, guid);
                if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                    response = this.getTermByGuid(serverName, userId, guid);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

