/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.InstanceGraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAPIHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSAPIHelper.class);
    private static final String className = OMRSAPIHelper.class.getName();
    private OMRSMetadataCollection oMRSMetadataCollection = null;
    private ErrorHandler errorHandler = null;
    private final String serviceName;
    private String serverName = null;
    private OMRSRepositoryHelper omrsRepositoryHelper = null;

    public OMRSMetadataCollection getOMRSMetadataCollection(String restAPIName) throws MetadataServerUncontactableException {
        this.validateInitialization(restAPIName);
        return this.oMRSMetadataCollection;
    }

    public OMRSRepositoryHelper getOMRSRepositoryHelper() {
        return this.omrsRepositoryHelper;
    }

    public void setOMRSRepositoryConnector(OMRSRepositoryConnector connector, String restAPIName) throws MetadataServerUncontactableException {
        String methodName = "setOMRSRepositoryConnector";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + "connector=" + connector);
        }
        try {
            this.oMRSMetadataCollection = connector.getMetadataCollection();
            this.omrsRepositoryHelper = connector.getRepositoryHelper();
        }
        catch (RepositoryErrorException e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{e.getMessage(), restAPIName, this.serviceName, this.serverName});
            log.error(errorMessage);
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
    }

    private void validateInitialization(String restAPIName) throws MetadataServerUncontactableException {
        if (this.oMRSMetadataCollection == null && this.omrsRepositoryHelper == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{restAPIName});
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), this.getClass().getName(), restAPIName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public OMRSAPIHelper(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SubjectAreaOMASAPIResponse callOMRSAddEntity(String restAPIName, String userId, EntityDetail entityDetail) {
        String methodName = "callOMRSAddEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            EntityDetail addedEntityDetail = this.getOMRSMetadataCollection(restAPIName).addEntity(userId, entityDetail.getType().getTypeDefGUID(), instanceProperties, entityDetail.getClassifications(), InstanceStatus.ACTIVE);
            response = new EntityDetailResponse(addedEntityDetail);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSGetEntityByGuid(String restAPIName, String userId, String entityGUID) {
        String methodName = "callOMRSGetEntityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        EntityDetailResponse response = null;
        try {
            EntityDetail gotEntityDetail = this.getOMRSMetadataCollection(restAPIName).getEntityDetail(userId, entityGUID);
            response = new EntityDetailResponse(gotEntityDetail);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityProxyOnlyException e) {
            response = ErrorHandler.handleEntityProxyOnlyException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callFindEntitiesByPropertyValue(String restAPIName, String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callFindEntitiesByPropertyValue";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List foundEntities = this.getOMRSMetadataCollection(restAPIName).findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new EntityDetailsResponse(foundEntities);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetEntitiesByType(String restAPIName, String userId, String entityTypeGUID, Date asOfTime, int fromEntityElement, int pageSize) {
        String methodName = "callGetEntitiesByType";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List foundEntities = this.getOMRSMetadataCollection(restAPIName).findEntitiesByProperty(userId, entityTypeGUID, null, null, fromEntityElement, null, null, asOfTime, null, null, pageSize);
            response = new EntityDetailsResponse(foundEntities);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSUpdateEntityProperties(String restAPIName, String userId, EntityDetail entityDetail) {
        String methodName = "callOMRSUpdateEntityProperties";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        EntityDetail updatedEntity = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            updatedEntity = this.getOMRSMetadataCollection(restAPIName).updateEntityProperties(userId, entityDetail.getGUID(), instanceProperties);
            response = new EntityDetailResponse(updatedEntity);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityDetail.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeleteEntity(String restAPIName, String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) {
        String methodName = "callOMRSDeleteEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail deletedEntity = this.getOMRSMetadataCollection(restAPIName).deleteEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
            response = new EntityDetailResponse(deletedEntity);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSPurgeEntity(String restAPIName, String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) {
        String methodName = "callOMRSPurgeEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        VoidResponse response = null;
        try {
            this.getOMRSMetadataCollection(restAPIName).purgeEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
            response = new VoidResponse();
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotDeletedException e) {
            response = this.errorHandler.handleEntityNotPurgedException(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSRestoreEntity(String restAPIName, String userId, String guid) {
        String methodName = "callOMRSRestoreEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        EntityDetailResponse response = null;
        try {
            EntityDetail restoredEntity = this.getOMRSMetadataCollection(restAPIName).restoreEntity(userId, guid);
            response = new EntityDetailResponse(restoredEntity);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotDeletedException e) {
            response = ErrorHandler.handleEntityNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSClassifyEntity(String restAPIName, String userId, String entityGUID, String classificationName, InstanceProperties instanceProperties) {
        String methodName = "callOMRSClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail entity = this.getOMRSMetadataCollection(restAPIName).classifyEntity(userId, entityGUID, classificationName, instanceProperties);
            response = new EntityDetailResponse(entity);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeClassifyEntity(String restAPIName, String userId, String entityGUID, String classificationName) {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail entity = this.getOMRSMetadataCollection(restAPIName).declassifyEntity(userId, entityGUID, classificationName);
            response = new EntityDetailResponse(entity);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSAddRelationship(String restAPIName, String userId, Relationship relationship) {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Relationship addedRelationship = this.getOMRSMetadataCollection(restAPIName).addRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getProperties(), relationship.getEntityOneProxy().getGUID(), relationship.getEntityTwoProxy().getGUID(), InstanceStatus.ACTIVE);
            response = new RelationshipResponse(addedRelationship);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSGetRelationshipByGuid(String restAPIName, String userId, String relationshipGUID) {
        String methodName = "callOMRSGetRelationshipByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        RelationshipResponse response = null;
        try {
            Relationship relationship = this.getOMRSMetadataCollection(restAPIName).getRelationship(userId, relationshipGUID);
            response = new RelationshipResponse(relationship);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(relationshipGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSUpdateRelationship(String restAPIName, String userId, Relationship relationship) {
        String methodName = "callOMRSUpdateRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        Relationship updatedRelationship = null;
        try {
            updatedRelationship = this.getOMRSMetadataCollection(restAPIName).updateRelationshipProperties(userId, relationship.getGUID(), relationship.getProperties());
            if (relationship.getStatus() != null && updatedRelationship != null && !relationship.getStatus().equals((Object)updatedRelationship.getStatus())) {
                updatedRelationship = this.getOMRSMetadataCollection(restAPIName).updateRelationshipStatus(userId, relationship.getGUID(), relationship.getStatus());
            }
            response = new RelationshipResponse(updatedRelationship);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeleteRelationship(String restAPIName, String userId, String typeGuid, String typeName, String guid) {
        String methodName = "callOMRSDeleteRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Relationship deletedRelationship = this.getOMRSMetadataCollection(restAPIName).deleteRelationship(userId, typeGuid, typeName, guid);
            response = new RelationshipResponse(deletedRelationship);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSRestoreRelationship(String restAPIName, String userId, String guid) {
        String methodName = "callOMRSRestoreRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        RelationshipResponse response = null;
        Relationship restoredRelationship = null;
        try {
            restoredRelationship = this.getOMRSMetadataCollection(restAPIName).restoreRelationship(userId, guid);
            response = new RelationshipResponse(restoredRelationship);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            response = ErrorHandler.handleRelationshipNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSPurgeRelationship(String restAPIName, String userId, String typeGuid, String typeName, String guid) {
        String methodName = "callOMRSPurgeRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        VoidResponse response = null;
        try {
            this.getOMRSMetadataCollection(restAPIName).purgeRelationship(userId, typeGuid, typeName, guid);
            response = new VoidResponse();
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            response = this.errorHandler.handleRelationshipNotPurgedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetRelationshipsForEntity(String restAPIName, String userId, String entityGUID, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
        statusList.add(InstanceStatus.ACTIVE);
        List relationships = null;
        try {
            relationships = this.getOMRSMetadataCollection(restAPIName).getRelationshipsForEntity(userId, entityGUID, relationshipTypeGuid, fromRelationshipElement, statusList, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new RelationshipsResponse(relationships);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetRelationshipsForEntity(String restAPIName, String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List relationships = this.getOMRSMetadataCollection(restAPIName).getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new RelationshipsResponse(relationships);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetEntityNeighbourhood(String restAPIName, String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) {
        String methodName = "callgetEntityNeighborhood";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InstanceGraph instanceGraph = this.getOMRSMetadataCollection(restAPIName).getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
            return new InstanceGraphResponse(instanceGraph);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = this.errorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            String method_not_implemented_msg_id = OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getErrorMessageId();
            if (!e.getErrorMessage().startsWith(method_not_implemented_msg_id)) {
                response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
            }
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findEntitiesByPropertyValue(String restAPIName, String userId, String typeName, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty, String methodName) {
        if (offset == null) {
            offset = new Integer(0);
        }
        if (pageSize == null) {
            pageSize = new Integer(0);
        }
        if (sequencingProperty != null) {
            try {
                sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (searchCriteria != null) {
            try {
                searchCriteria = URLDecoder.decode(searchCriteria, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
        TypeDef typeDef = this.omrsRepositoryHelper.getTypeDefByName("findEntitiesByPropertyValue", typeName);
        String entityTypeGUID = typeDef.getGUID();
        return this.callFindEntitiesByPropertyValue(restAPIName, userId, entityTypeGUID, searchCriteria, offset, null, null, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
    }

    public SubjectAreaOMASAPIResponse getEntitiesByType(OMRSAPIHelper oMRSAPIHelper, String restAPIName, String userId, String typeName, Date asOfTime, Integer offset, Integer pageSize) {
        if (offset == null) {
            offset = new Integer(0);
        }
        if (pageSize == null) {
            pageSize = new Integer(0);
        }
        TypeDef typeDef = this.omrsRepositoryHelper.getTypeDefByName("getEntitiesByType", typeName);
        String entityTypeGUID = typeDef.getGUID();
        return oMRSAPIHelper.callGetEntitiesByType(restAPIName, userId, entityTypeGUID, asOfTime, offset, pageSize);
    }
}

