/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.IconSummarySetResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.NodeSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ISARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ReplacementTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermHASARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermISATypeOFRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermTYPEDBYRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaUtils {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaUtils.class);
    private static final String className = SubjectAreaUtils.class.getName();

    public static boolean isTopLevelGlossaryObject(String entityName) {
        boolean isTopLevelGlossaryObject = false;
        if (entityName.equals("Glossary") || entityName.equals("Node") || entityName.equals("GlossaryCategory")) {
            isTopLevelGlossaryObject = true;
        }
        return isTopLevelGlossaryObject;
    }

    public static boolean isGovernanceActionClassification(String classificationName) {
        boolean isGovernanceActionClassification = false;
        if (classificationName.equals("Confidence") || classificationName.equals("Confidentiality") || classificationName.equals("Retention") || classificationName.equals("Criticality")) {
            isGovernanceActionClassification = true;
        }
        return isGovernanceActionClassification;
    }

    public static InstanceType createTemplateFromTypeDef(TypeDef typeDef) {
        InstanceType template = new InstanceType();
        template.setTypeDefName(typeDef.getName());
        template.setTypeDefCategory(typeDef.getCategory());
        template.setTypeDefDescription(typeDef.getDescription());
        template.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
        template.setTypeDefGUID(typeDef.getGUID());
        ArrayList<TypeDefLink> supertypes = new ArrayList<TypeDefLink>();
        supertypes.add(typeDef.getSuperType());
        template.setTypeDefSuperTypes(supertypes);
        template.setTypeDefVersion(typeDef.getVersion());
        template.setValidStatusList(typeDef.getValidInstanceStatusList());
        return template;
    }

    public static boolean isTerm(String typeName) {
        return typeName.equals("GlossaryTerm");
    }

    public static boolean isCategory(String typeName) {
        return typeName.equals("GlossaryCategory");
    }

    public static boolean isGlossary(String typeName) {
        return typeName.equals("Glossary");
    }

    public static void addStringToInstanceProperty(String key, String value, InstanceProperties instanceProperties) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)value);
        instanceProperties.setProperty(key, (InstancePropertyValue)primitivePropertyValue);
    }

    public static SubjectAreaOMASAPIResponse getIconSummarySet(String userId, OMRSAPIHelper oMRSAPIHelper, String guid) {
        HashSet<IconSummary> icons = new HashSet<IconSummary>();
        IconSummarySetResponse response = new IconSummarySetResponse(icons);
        return response;
    }

    public static SubjectAreaOMASAPIResponse getGlossarySummaryForTerm(String restAPIName, String userId, OMRSAPIHelper omrsapiHelper, TermAnchorRelationship termAnchorRelationship, Term term) {
        String glossaryGuid = termAnchorRelationship.getGlossaryGuid();
        SubjectAreaOMASAPIResponse response = omrsapiHelper.callOMRSGetEntityByGuid(restAPIName, userId, glossaryGuid);
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
            EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
            EntityDetail glossaryEntity = entityDetailResponse.getEntityDetail();
            Glossary glossary = null;
            try {
                glossary = new GlossaryMapper(omrsapiHelper).mapEntityDetailToNode(glossaryEntity);
                GlossarySummary glossarySummary = SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, (Line)termAnchorRelationship);
                response = new GlossarySummaryResponse(glossarySummary);
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        return response;
    }

    public static SubjectAreaOMASAPIResponse getGlossarySummaryForCategory(String restAPIName, String userId, OMRSAPIHelper omrsapiHelper, Line line) {
        CategoryAnchorRelationship categoryAnchorRelationship = (CategoryAnchorRelationship)line;
        String glossaryGuid = categoryAnchorRelationship.getGlossaryGuid();
        SubjectAreaOMASAPIResponse response = omrsapiHelper.callOMRSGetEntityByGuid(restAPIName, userId, glossaryGuid);
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
            EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
            EntityDetail glossaryEntity = entityDetailResponse.getEntityDetail();
            Glossary glossary = null;
            try {
                glossary = new GlossaryMapper(omrsapiHelper).mapEntityDetailToNode(glossaryEntity);
                GlossarySummary glossarySummary = SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, (Line)categoryAnchorRelationship);
                if (glossarySummary != null) {
                    response = new GlossarySummaryResponse(glossarySummary);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        return response;
    }

    public static CategorySummary getParentCategorySummary(String restAPIName, String userId, OMRSAPIHelper omrsapiHelper, Set<Line> lines) throws UserNotAuthorizedException, InvalidParameterException, UnrecognizedGUIDException, MetadataServerUncontactableException, FunctionNotSupportedException {
        CategorySummary parentCategorySummary = null;
        SubjectAreaOMASAPIResponse response = null;
        Iterator<Line> iterator = lines.iterator();
        while (iterator.hasNext() && parentCategorySummary == null) {
            CategoryHierarchyLink parentRelationship = (CategoryHierarchyLink)iterator.next();
            String parentCategoryGuid = parentRelationship.getSuperCategoryGuid();
            response = omrsapiHelper.callOMRSGetEntityByGuid(restAPIName, userId, parentCategoryGuid);
            if (response.getResponseCategory() != ResponseCategory.OmrsEntityDetail) continue;
            EntityDetailResponse parentCategoryEntityResponse = (EntityDetailResponse)response;
            EntityDetail parentCategoryEntity = parentCategoryEntityResponse.getEntityDetail();
            Category category = (Category)new CategoryMapper(omrsapiHelper).mapEntityDetailToNode(parentCategoryEntity);
            parentCategorySummary = SubjectAreaUtils.extractCategorySummaryFromCategory(category, (Line)parentRelationship);
        }
        return parentCategorySummary;
    }

    private static CategorySummary extractCategorySummaryFromCategory(Category category, Line line) {
        CategorySummary categorySummary = new CategorySummary();
        SubjectAreaUtils.extractNodeSummary((Node)category, line, (NodeSummary)categorySummary);
        return categorySummary;
    }

    private static void extractNodeSummary(Node node, Line line, NodeSummary nodeSummary) {
        nodeSummary.setQualifiedName(node.getQualifiedName());
        nodeSummary.setName(node.getName());
        nodeSummary.setGuid(node.getSystemAttributes().getGUID());
        nodeSummary.setFromEffectivityTime(node.getEffectiveFromTime());
        nodeSummary.setToEffectivityTime(node.getEffectiveToTime());
        nodeSummary.setRelationshipguid(line.getGuid());
        nodeSummary.setFromRelationshipEffectivityTime(line.getEffectiveFromTime());
        nodeSummary.setToRelationshipEffectivityTime(line.getEffectiveToTime());
    }

    public static IconSummary extractIconSummaryFromRelatedMedia(EntityDetail relatedMedia) {
        IconSummary icon = null;
        icon = new IconSummary();
        return icon;
    }

    public static GlossarySummary extractGlossarySummaryFromGlossary(Glossary glossary, Line line) {
        if (glossary == null) {
            return null;
        }
        GlossarySummary glossarySummary = new GlossarySummary();
        SubjectAreaUtils.extractNodeSummary((Node)glossary, line, (NodeSummary)glossarySummary);
        return glossarySummary;
    }

    public static void checkStatusNotDeleted(Status status, SubjectAreaErrorCode errorCode) throws InvalidParameterException {
        String methodName = "checkStatusNotDeleted";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: checkStatusNotDeleted");
        }
        Object response = null;
        if (status.equals((Object)Status.DELETED)) {
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, "checkStatusNotDeleted"});
            log.error(errorMessage);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), className, "checkStatusNotDeleted", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: checkStatusNotDeleted");
        }
    }

    public static Status convertInstanceStatusToStatus(InstanceStatus instanceStatus) {
        Status status = null;
        if (instanceStatus == null) {
            status = Status.ACTIVE;
        } else {
            switch (instanceStatus) {
                case ACTIVE: {
                    status = Status.ACTIVE;
                    break;
                }
                case DELETED: {
                    status = Status.DELETED;
                    break;
                }
                case DRAFT: {
                    status = Status.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    status = Status.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    status = Status.PREPARED;
                    break;
                }
                case PROPOSED: {
                    status = Status.PROPOSED;
                    break;
                }
                case APPROVED: {
                    status = Status.APPROVED;
                }
            }
        }
        return status;
    }

    public static InstanceStatus convertStatusToInstanceStatus(Status status) {
        InstanceStatus instanceStatus = null;
        if (status == null) {
            instanceStatus = InstanceStatus.ACTIVE;
        } else {
            switch (status) {
                case ACTIVE: {
                    instanceStatus = InstanceStatus.ACTIVE;
                    break;
                }
                case DELETED: {
                    instanceStatus = InstanceStatus.DELETED;
                    break;
                }
                case DRAFT: {
                    instanceStatus = InstanceStatus.DRAFT;
                    break;
                }
                case UNKNOWN: {
                    instanceStatus = InstanceStatus.UNKNOWN;
                    break;
                }
                case PREPARED: {
                    instanceStatus = InstanceStatus.PREPARED;
                    break;
                }
                case PROPOSED: {
                    instanceStatus = InstanceStatus.PROPOSED;
                    break;
                }
                case APPROVED: {
                    instanceStatus = InstanceStatus.APPROVED;
                }
            }
        }
        return instanceStatus;
    }

    public static SubjectAreaOMASAPIResponse convertOMRSRelationshipsToOMASLines(OMRSAPIHelper omrsapiHelper, List<Relationship> omrsRelationships) {
        ArrayList<Line> omasLines = new ArrayList<Line>();
        for (Relationship omrsRelationship : omrsRelationships) {
            String omrsName = omrsRelationship.getType().getTypeDefName();
            Line omasLine = null;
            switch (omrsName) {
                case "TermHASARelationship": {
                    omasLine = new TermHASARelationshipMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "RelatedTerm": {
                    omasLine = new RelatedTermMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Synonym": {
                    omasLine = new SynonymMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Antonym": {
                    omasLine = new AntonymMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Translation": {
                    omasLine = new TranslationMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ISARelationship": {
                    omasLine = new ISARelationshipMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "PreferredTerm": {
                    omasLine = new PreferredTermMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermISATypeOFRelationship": {
                    omasLine = new TermISATypeOFRelationshipMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ReplacementTerm": {
                    omasLine = new ReplacementTermMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermTYPEDBYRelationship": {
                    omasLine = new TermTYPEDBYRelationshipMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "UsedInContext": {
                    omasLine = new UsedInContextMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ValidValue": {
                    omasLine = new ValidValueMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "LibraryCategoryReferenceRelationshipRelationship": {
                    break;
                }
                case "LibraryTermReferenceRelationshipRelationship": {
                    break;
                }
                case "SemanticAssignment": {
                    omasLine = new SemanticAssignmentMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermCategorization": {
                    omasLine = new TermCategorizationMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermAnchor": {
                    omasLine = new TermAnchorMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "CategoryAnchor": {
                    omasLine = new CategoryAnchorMapper(omrsapiHelper).mapRelationshipToLine(omrsRelationship);
                }
            }
            if (omasLine == null) continue;
            omasLines.add(omasLine);
        }
        return new LinesResponse(omasLines);
    }

    public static org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder convertOMASToOMRSSequencingOrder(SequencingOrder sequencingOrder) {
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = null;
        if (sequencingOrder == null) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
        } else if (sequencingOrder.equals((Object)SequencingOrder.ANY)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
        } else if (sequencingOrder.equals((Object)SequencingOrder.CREATION_DATE_RECENT)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT;
        } else if (sequencingOrder.equals((Object)SequencingOrder.CREATION_DATE_OLDEST)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_OLDEST;
        } else if (sequencingOrder.equals((Object)SequencingOrder.LAST_UPDATE_RECENT)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_RECENT;
        } else if (sequencingOrder.equals((Object)SequencingOrder.LAST_UPDATE_OLDEST)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_OLDEST;
        } else if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_ASCENDING;
        } else if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_DESCENDING;
        } else if (sequencingOrder.equals((Object)SequencingOrder.GUID)) {
            omrsSequencingOrder = org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.GUID;
        }
        return omrsSequencingOrder;
    }

    public static SystemAttributes createSystemAttributes(InstanceHeader instanceHeader) {
        SystemAttributes systemAttributes = new SystemAttributes();
        InstanceStatus instanceStatus = instanceHeader.getStatus();
        Status omas_status = SubjectAreaUtils.convertInstanceStatusToStatus(instanceStatus);
        systemAttributes.setStatus(omas_status);
        systemAttributes.setCreatedBy(instanceHeader.getCreatedBy());
        systemAttributes.setUpdatedBy(instanceHeader.getUpdatedBy());
        systemAttributes.setCreateTime(instanceHeader.getCreateTime());
        systemAttributes.setUpdateTime(instanceHeader.getUpdateTime());
        systemAttributes.setVersion(Long.valueOf(instanceHeader.getVersion()));
        systemAttributes.setGUID(instanceHeader.getGUID());
        return systemAttributes;
    }

    public static void populateSystemAttributesForInstanceAuditHeader(SystemAttributes systemAttributes, InstanceAuditHeader instanceAuditHeader) {
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                instanceAuditHeader.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                instanceAuditHeader.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                instanceAuditHeader.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                instanceAuditHeader.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                instanceAuditHeader.setVersion(systemAttributes.getVersion().longValue());
            }
        }
    }

    public static void setStringPropertyInInstanceProperties(InstanceProperties instanceProperties, String stringValue, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue((Object)stringValue);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }

    public static void setIntegerPropertyInInstanceProperties(InstanceProperties instanceProperties, Integer integerValue, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        primitivePropertyValue.setPrimitiveValue((Object)integerValue);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }

    public static void setDatePropertyInInstanceProperties(InstanceProperties instanceProperties, Date date, String propertyName) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        Long timestamp = date.getTime();
        primitivePropertyValue.setPrimitiveValue((Object)timestamp);
        instanceProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
    }
}

