/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.validators;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaCategoryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestValidator {
    private static final Logger log = LoggerFactory.getLogger(RestValidator.class);
    private static final String className = SubjectAreaTermRESTServices.class.getName();

    public static void validateOMASServerURLNotNull(String className, String methodName, String omasServerURL) throws MetadataServerUncontactableException {
        if (omasServerURL == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public static SubjectAreaOMASAPIResponse validateGlossarySummaryDuringCreation(String serverName, String userId, String methodName, GlossarySummary suppliedGlossary, SubjectAreaGlossaryRESTServices glossaryRESTServices) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        if (suppliedGlossary == null) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            log.error(errorMessage);
            InvalidParameterException e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        } else {
            InvalidParameterException e;
            String errorMessage;
            SubjectAreaErrorCode errorCode;
            guid = suppliedGlossary.getGuid();
            relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                errorCode = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, relationshipGuid});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (response == null) {
                if (guid == null) {
                    errorCode = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY;
                    errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
                    log.error(errorMessage);
                    e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                } else {
                    response = glossaryRESTServices.getGlossaryByGuid(serverName, userId, guid);
                    errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_GUID;
                    if (response.getResponseCategory() != ResponseCategory.Glossary) {
                        errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, relationshipGuid});
                        log.error(errorMessage);
                        e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                }
            }
        }
        return response;
    }

    public static SubjectAreaOMASAPIResponse validateCategorySummaryDuringCreation(String serverName, String userId, String methodName, CategorySummary suppliedCategory, SubjectAreaCategoryRESTServices categoryRESTServices) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        String name = null;
        if (suppliedCategory != null) {
            InvalidParameterException e;
            String errorMessage;
            SubjectAreaErrorCode errorCode;
            guid = suppliedCategory.getGuid();
            relationshipGuid = suppliedCategory.getRelationshipguid();
            name = suppliedCategory.getName();
            if (relationshipGuid != null) {
                errorCode = SubjectAreaErrorCode.CREATE_WITH_CATEGORY_RELATIONSHIP;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, relationshipGuid});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (guid == null) {
                errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_CATEGORY_GUID;
                errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName});
                log.error(errorMessage);
                e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (response == null && guid != null) {
                response = categoryRESTServices.getCategory(serverName, userId, guid);
                if (!response.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                    errorCode = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_CATEGORY_GUID;
                    errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{className, methodName, name});
                    log.error(errorMessage);
                    e = new InvalidParameterException(errorCode.getHTTPErrorCode(), className, methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                }
            }
        }
        return response;
    }
}

