/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);
    protected String serviceName;
    protected String serverName;
    protected RepositoryHandler repositoryHandler;
    protected OMRSRepositoryHelper repositoryHelper;
    protected InvalidParameterHandler invalidParameterHandler;
    protected OMRSAPIHelper oMRSAPIHelper;

    public SubjectAreaHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, OMRSAPIHelper oMRSAPIHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.oMRSAPIHelper = oMRSAPIHelper == null ? new OMRSAPIHelper(serviceName) : oMRSAPIHelper;
        this.oMRSAPIHelper.setOmrsRepositoryHelper(repositoryHelper);
        this.oMRSAPIHelper.setOMRSMetadataCollection(repositoryHandler.getMetadataCollection());
    }

    protected abstract SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse var1);

    protected SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getRelationshipsFromGuid";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
        glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            RelationshipsResponse relationshipsResponse;
            InputValidator.validateGUIDNotNull((String)className, (String)restAPIName, (String)guid, (String)"guid");
            if (sequencingProperty != null) {
                sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
            }
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
            List<Relationship> omrsRelationships = null;
            response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships())).getResponseCategory() == ResponseCategory.Lines) {
                LinesResponse linesResponse = (LinesResponse)response;
                List linesToReturn = linesResponse.getLines();
                if (pageSize > 0) {
                    int sizeToGet = 0;
                    if (omrsRelationships.size() > linesToReturn.size()) {
                        sizeToGet = omrsRelationships.size() - linesToReturn.size();
                    }
                    offset += omrsRelationships.size();
                    while (sizeToGet > 0) {
                        List moreLines;
                        List<Relationship> moreOmrsRelationships;
                        response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, sizeToGet);
                        sizeToGet = 0;
                        if (response.getResponseCategory() != ResponseCategory.OmrsRelationships || (moreOmrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) == null || moreOmrsRelationships.size() <= 0 || (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships)).getResponseCategory() != ResponseCategory.Lines || (moreLines = (linesResponse = (LinesResponse)response).getLines()) == null || moreLines.isEmpty()) continue;
                        linesToReturn.addAll(moreLines);
                        sizeToGet = moreOmrsRelationships.size() - moreLines.size();
                        offset += moreOmrsRelationships.size();
                    }
                    response = new LinesResponse(linesToReturn);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnsupportedEncodingException e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)new InvalidParameterException(errorCode.getMessageDefinition(), className, methodName, "sequencingProperty", sequencingProperty));
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",entity userId=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            RelationshipsResponse relationshipsResponse;
            List<Relationship> omrsRelationships;
            InputValidator.validateUserIdNotNull((String)className, (String)"getRelationshipsFromGuid", (String)userId);
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)entityGuid, (String)"entityGuid");
            response = this.oMRSAPIHelper.callGetRelationshipsForEntity(restAPIName, userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) != null) {
                HashSet<Relationship> relationshipSet = new HashSet<Relationship>(omrsRelationships);
                response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ",userId=" + entityGuid);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse validateGlossarySummaryDuringCreation(SubjectAreaGlossaryHandler glossaryHandler, String userId, String methodName, GlossarySummary suppliedGlossary) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        if (suppliedGlossary == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
            InvalidParameterException e = new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        } else {
            InvalidParameterException e;
            ExceptionMessageDefinition messageDefinition;
            guid = suppliedGlossary.getGuid();
            relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                messageDefinition = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP.getMessageDefinition();
                e = new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            if (response == null) {
                if (guid == null) {
                    messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
                    e = new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                } else {
                    response = glossaryHandler.getGlossaryByGuid(userId, guid);
                    messageDefinition = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_GUID.getMessageDefinition();
                    if (response.getResponseCategory() != ResponseCategory.Glossary) {
                        e = new InvalidParameterException(messageDefinition, className, methodName, "glossary guid", guid);
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
                    }
                }
            }
        }
        return response;
    }
}

