/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.LineType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.ProjectMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaProjectRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectHandler
extends SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaProjectHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaProjectHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, OMRSAPIHelper oMRSAPIHelper) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler, oMRSAPIHelper);
    }

    @Override
    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        ProjectMapper projectMapper = new ProjectMapper(this.oMRSAPIHelper);
        try {
            Project project = projectMapper.mapEntityDetailToNode(entityDetail);
            if (project.getNodeType() == NodeType.GlossaryProject) {
                GlossaryProject glossaryProject = (GlossaryProject)project;
                response = new ProjectResponse((Project)glossaryProject);
            } else {
                response = new ProjectResponse(project);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createProject(String userId, Project suppliedProject) {
        String methodName = "createProject";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            String suppliedProjectName = suppliedProject.getName();
            if (suppliedProjectName == null || suppliedProjectName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_PROJECT_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createProject", "Name", null);
            }
            ProjectMapper projectMapper = new ProjectMapper(this.oMRSAPIHelper);
            EntityDetail projectEntityDetail = projectMapper.mapNodeToEntityDetail((Node)suppliedProject);
            response = this.oMRSAPIHelper.callOMRSAddEntity("createProject", userId, projectEntityDetail);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                response = this.getProjectByGuid(userId, entityDetail.getGUID());
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectByGuid(String userId, String guid) {
        String methodName = "getProjectByGuid";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getProjectByGuid", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getProjectByGuid", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                response = this.getResponse(response);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findProject(String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType(this.oMRSAPIHelper, "findProject", userId, "Project", asOfTime, offset, pageSize) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findProject", userId, "Project", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findProject");
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entityDetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Project> projects = new ArrayList<Project>();
            if (entityDetails == null) {
                response = new ProjectsResponse(projects);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entityDetails.iterator();
                while (iterator.hasNext() && (response = this.getProjectByGuid(userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Project) {
                    ProjectResponse projectResponse = (ProjectResponse)response;
                    Project project = projectResponse.getProject();
                    projects.add(project);
                }
                if (response.getResponseCategory() == ResponseCategory.Project) {
                    response = new ProjectsResponse(projects);
                }
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectRelationships(String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        return this.getRelationshipsFromGuid(methodName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateProject(String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateProject", suppliedProject.getNodeType(), NodeType.Project, NodeType.GlossaryProject});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateProject", (String)guid, (String)"guid");
            response = this.getProjectByGuid(userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Project)) {
                Project updateProject = ((ProjectResponse)response).getProject();
                if (isReplace) {
                    updateProject.setName(suppliedProject.getName());
                    updateProject.setQualifiedName(suppliedProject.getQualifiedName());
                    updateProject.setDescription(suppliedProject.getDescription());
                    updateProject.setStartDate(suppliedProject.getStartDate());
                    updateProject.setPlannedEndDate(suppliedProject.getPlannedEndDate());
                    updateProject.setStatus(suppliedProject.getStatus());
                    updateProject.setAdditionalProperties(suppliedProject.getAdditionalProperties());
                } else {
                    if (suppliedProject.getName() != null) {
                        updateProject.setName(suppliedProject.getName());
                    }
                    if (suppliedProject.getQualifiedName() != null) {
                        updateProject.setQualifiedName(suppliedProject.getQualifiedName());
                    }
                    if (suppliedProject.getDescription() != null) {
                        updateProject.setDescription(suppliedProject.getDescription());
                    }
                    if (suppliedProject.getStartDate() != null) {
                        updateProject.setStartDate(suppliedProject.getStartDate());
                    }
                    if (suppliedProject.getPlannedEndDate() != null) {
                        updateProject.setPlannedEndDate(suppliedProject.getPlannedEndDate());
                    }
                    if (suppliedProject.getStatus() != null) {
                        updateProject.setStatus(suppliedProject.getStatus());
                    }
                    if (suppliedProject.getAdditionalProperties() != null) {
                        updateProject.setAdditionalProperties(suppliedProject.getAdditionalProperties());
                    }
                }
                Date termFromTime = suppliedProject.getEffectiveFromTime();
                Date termToTime = suppliedProject.getEffectiveToTime();
                updateProject.setEffectiveFromTime(termFromTime);
                updateProject.setEffectiveToTime(termToTime);
                ProjectMapper projectMapper = new ProjectMapper(this.oMRSAPIHelper);
                EntityDetail entityDetail = projectMapper.mapNodeToEntityDetail((Node)updateProject);
                String projectGuid = entityDetail.getGUID();
                response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateProject", userId, entityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getProjectByGuid(userId, projectGuid);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteProject(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteProject";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteProject", (String)guid, (String)"guid");
            ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
            statusList.add(InstanceStatus.ACTIVE);
            OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            String source = this.oMRSAPIHelper.getServiceName();
            String projectTypeDefName = "Project";
            String projectTypeDefGuid = repositoryHelper.getTypeDefByName(source, projectTypeDefName).getGUID();
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeEntity("deleteProject", userId, projectTypeDefName, projectTypeDefGuid, guid);
                response = new VoidResponse();
            } else {
                String termAnchorGuid = repositoryHelper.getTypeDefByName("deleteProject", "TermAnchor").getGUID();
                String categoryAnchorGuid = repositoryHelper.getTypeDefByName("deleteProject", "TermAnchor").getGUID();
                response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteProject", userId, guid, termAnchorGuid, 0, statusList, null, null, null, 1);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                    RelationshipsResponse termAnchorRelationshipsResponse = (RelationshipsResponse)response;
                    List<Relationship> termRelationships = termAnchorRelationshipsResponse.getRelationships();
                    response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteProject", userId, guid, categoryAnchorGuid, 0, statusList, null, null, null, 1);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                        RelationshipsResponse categoryAnchorRelationshipsResponse = (RelationshipsResponse)response;
                        List<Relationship> categoryRelationships = categoryAnchorRelationshipsResponse.getRelationships();
                        if ((termRelationships == null || termRelationships.isEmpty()) && (categoryRelationships == null || categoryRelationships.isEmpty())) {
                            response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteProject", userId, projectTypeDefName, projectTypeDefGuid, guid);
                            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                                response = this.getResponse(response);
                            }
                        } else {
                            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE.getMessageDefinition();
                            response = new EntityNotDeletedExceptionResponse((SubjectAreaCheckedException)new EntityNotDeletedException(messageDefinition, className, "deleteProject", guid));
                        }
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreProject(String userId, String guid) {
        String methodName = "restoreProject";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaProjectRESTServices projectRESTServices = new SubjectAreaProjectRESTServices();
        projectRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreProject", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreProject", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                response = this.getProjectByGuid(userId, guid);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectTerms(SubjectAreaGraphHandler subjectAreaGraphHandler, String userId, String guid, Date asOfTime) {
        String nodeFilter = new HashSet<NodeType>(Arrays.asList(NodeType.Project, NodeType.Term, NodeType.GlossaryProject, NodeType.Activity)).toString();
        String lineFilter = new HashSet<LineType>(Arrays.asList(LineType.ProjectScope)).toString();
        SubjectAreaOMASAPIResponse response = subjectAreaGraphHandler.getGraph(userId, guid, asOfTime, nodeFilter, lineFilter, null, 1);
        ArrayList<Term> terms = null;
        if (response.getResponseCategory() == ResponseCategory.Graph) {
            Set nodes;
            GraphResponse graphResponse = (GraphResponse)response;
            Graph graph = graphResponse.getGraph();
            if (graph != null && (nodes = graph.getNodes()) != null) {
                for (Node node : nodes) {
                    if (node.getNodeType() != NodeType.Term) continue;
                    if (terms == null) {
                        terms = new ArrayList<Term>();
                    }
                    terms.add((Term)node);
                }
            }
            response = new TermsResponse(terms);
        }
        return response;
    }
}

