/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.Map;
import java.util.StringTokenizer;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineBundle;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineBundleFactory;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ResponseFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRelationshipHandler
extends SubjectAreaHandler {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRelationshipHandler.class);

    public SubjectAreaRelationshipHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, OMRSAPIHelper oMRSAPIHelper, RepositoryErrorHandler errorHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler, oMRSAPIHelper);
    }

    @Override
    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        return response;
    }

    public SubjectAreaOMASAPIResponse createLine(String restAPIName, String userId, String className, Line line) {
        String methodName = "createLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
        ILineBundle bundle = factory.getInstance(className);
        ILineMapper mapper = bundle.getMapper();
        try {
            Relationship omrsRelationship = mapper.mapLineToRelationship(line);
            response = this.oMRSAPIHelper.callOMRSAddRelationship(restAPIName, userId, omrsRelationship);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                Relationship createdOMRSRelationship = ((RelationshipResponse)response).getRelationship();
                Line createdLine = mapper.mapRelationshipToLine(createdOMRSRelationship);
                response = new ResponseFactory().getInstance(className, createdLine);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getLine(String restAPIName, String userId, String className, String guid) {
        String methodName = "getLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
        ILineBundle bundle = factory.getInstance(className);
        ILineMapper mapper = bundle.getMapper();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, guid);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                Relationship createdOMRSRelationship = ((RelationshipResponse)response).getRelationship();
                Line gotLine = mapper.mapRelationshipToLine(createdOMRSRelationship);
                response = new ResponseFactory().getInstance(className, gotLine);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateLine(String restAPIName, String userId, String className, Line line, boolean isReplace) {
        String methodName = "updateLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",className=" + className, (Object)(",isReplace=" + isReplace));
        }
        SubjectAreaOMASAPIResponse response = null;
        ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
        ILineBundle bundle = factory.getInstance(className);
        ILineMapper mapper = bundle.getMapper();
        try {
            String relationshipGuid = line.getGuid();
            InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)relationshipGuid, (String)"termGuid");
            response = this.oMRSAPIHelper.callOMRSGetRelationshipByGuid(restAPIName, userId, relationshipGuid);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                Relationship originalRelationship = ((RelationshipResponse)response).getRelationship();
                Relationship relationshipToUpdate = mapper.mapLineToRelationship(line);
                if (!isReplace && relationshipToUpdate.getProperties() != null && relationshipToUpdate.getProperties().getPropertyCount() > 0) {
                    Map updateInstanceProperties = relationshipToUpdate.getProperties().getInstanceProperties();
                    if (originalRelationship.getProperties() != null) {
                        Map orgInstanceProperties = originalRelationship.getProperties().getInstanceProperties();
                        for (String orgPropertyName : orgInstanceProperties.keySet()) {
                            if (updateInstanceProperties.containsKey(orgPropertyName)) continue;
                            updateInstanceProperties.put(orgPropertyName, orgInstanceProperties.get(orgPropertyName));
                        }
                    }
                    InstanceProperties instancePropertiesToUpdate = new InstanceProperties();
                    instancePropertiesToUpdate.setInstanceProperties(updateInstanceProperties);
                    instancePropertiesToUpdate.setEffectiveFromTime(line.getEffectiveFromTime());
                    instancePropertiesToUpdate.setEffectiveToTime(line.getEffectiveToTime());
                    relationshipToUpdate.setProperties(instancePropertiesToUpdate);
                }
                if (relationshipToUpdate.getProperties() == null || relationshipToUpdate.getProperties().getPropertyCount() == 0) {
                    ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.LINE_UPDATE_ATTEMPTED_WITH_NO_PROPERTIES.getMessageDefinition();
                    response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)new InvalidParameterException(messageDefinition, className, methodName, "properties", null));
                } else {
                    response = this.oMRSAPIHelper.callOMRSUpdateRelationship(restAPIName, userId, relationshipToUpdate);
                    if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                        Relationship updatedOmrsRelationship = ((RelationshipResponse)response).getRelationship();
                        Line updatedLine = mapper.mapRelationshipToLine(updatedOmrsRelationship);
                        response = new ResponseFactory().getInstance(className, updatedLine);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteLine(String restAPIName, String userId, String className, String guid, Boolean isPurge) {
        String methodName = "deleteLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid + ",isPurge=" + isPurge);
        }
        SubjectAreaOMASAPIResponse response = null;
        OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
        ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
        ILineBundle bundle = factory.getInstance(className);
        ILineMapper mapper = bundle.getMapper();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
            StringTokenizer st = new StringTokenizer(className, ".");
            String typeName = mapper.getTypeName();
            String source = this.oMRSAPIHelper.getServiceName();
            String typeGuid = repositoryHelper.getTypeDefByName(source, typeName).getGUID();
            if (isPurge.booleanValue()) {
                response = this.oMRSAPIHelper.callOMRSPurgeRelationship(restAPIName, userId, typeGuid, typeName, guid);
            } else {
                response = this.oMRSAPIHelper.callOMRSDeleteRelationship(restAPIName, userId, typeGuid, typeName, guid);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    Relationship omrsRelationship = ((RelationshipResponse)response).getRelationship();
                    Line deletedLine = mapper.mapRelationshipToLine(omrsRelationship);
                    response = new ResponseFactory().getInstance(className, deletedLine);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreLine(String restAPIName, String userId, String className, String guid) {
        String methodName = "deleteLine";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        ILineBundleFactory factory = new ILineBundleFactory(this.oMRSAPIHelper);
        ILineBundle bundle = factory.getInstance(className);
        ILineMapper mapper = bundle.getMapper();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)methodName, (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreRelationship(restAPIName, userId, guid);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                Relationship omrsRelationship = ((RelationshipResponse)response).getRelationship();
                Line restoredLine = mapper.mapRelationshipToLine(omrsRelationship);
                response = new ResponseFactory().getInstance(className, restoredLine);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

