/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.GovernanceActions;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Activity;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaTermHandler
extends SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaTermHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaTermHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, OMRSAPIHelper oMRSAPIHelper, RepositoryErrorHandler errorHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler, oMRSAPIHelper);
    }

    @Override
    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
        try {
            Term term = termMapper.mapEntityDetailToNode(entityDetail);
            if (term.getNodeType() == NodeType.Activity) {
                Activity activity = (Activity)term;
                response = new TermResponse((Term)activity);
            } else {
                response = new TermResponse(term);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createTerm(SubjectAreaGlossaryHandler glossaryHandler, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        SubjectAreaOMASAPIResponse response = null;
        Glossary associatedGlossary = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createTerm", suppliedTerm.getNodeType(), NodeType.Term});
            SubjectAreaGlossaryRESTServices glossaryRESTServices = new SubjectAreaGlossaryRESTServices();
            glossaryRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
            String suppliedTermName = suppliedTerm.getName();
            if (suppliedTermName == null || suppliedTermName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_TERM_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createTerm", "Name", null);
            }
            TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
            EntityDetail suppliedTermEntityDetail = termMapper.mapNodeToEntityDetail((Node)suppliedTerm);
            GlossarySummary suppliedGlossary = suppliedTerm.getGlossary();
            SubjectAreaOMASAPIResponse glossaryResponse = this.validateGlossarySummaryDuringCreation(glossaryHandler, userId, "createTerm", suppliedGlossary);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                response = this.oMRSAPIHelper.callOMRSAddEntity("createTerm", userId, suppliedTermEntityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail createdTermEntityDetail = entityDetailResponse.getEntityDetail();
                    String termGuid = createdTermEntityDetail.getGUID();
                    String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                    TermAnchor termAnchor = new TermAnchor();
                    termAnchor.setGlossaryGuid(glossaryGuid);
                    termAnchor.setTermGuid(termGuid);
                    TermAnchorMapper termAnchorMapper = new TermAnchorMapper(this.oMRSAPIHelper);
                    Relationship relationship = termAnchorMapper.mapLineToRelationship((Line)termAnchor);
                    response = this.oMRSAPIHelper.callOMRSAddRelationship("createTerm", userId, relationship);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationship)) {
                        response = this.getTermByGuid(userId, termGuid);
                    }
                }
            } else {
                response = glossaryResponse;
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermByGuid(String userId, String guid) {
        String methodName = "getTermByGuid";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getTermByGuid", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getTermByGuid", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                EntityDetail gotEntityDetail = entityDetailResponse.getEntityDetail();
                TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
                Term gotTerm = termMapper.mapEntityDetailToNode(gotEntityDetail);
                String anchorTypeGuid = TypeGuids.getTermAnchorTypeGuid();
                response = this.oMRSAPIHelper.callGetRelationshipsForEntity("getTermByGuid", userId, guid, anchorTypeGuid, 0, null, null, null, 0);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                    RelationshipsResponse relationshipsResponse = (RelationshipsResponse)response;
                    List<Relationship> glossaryRelationships = relationshipsResponse.getRelationships();
                    if (glossaryRelationships.iterator().hasNext()) {
                        Relationship glossaryRelationship = glossaryRelationships.iterator().next();
                        TermAnchor termAnchor = (TermAnchor)new TermAnchorMapper(this.oMRSAPIHelper).mapRelationshipToLine(glossaryRelationship);
                        response = SubjectAreaUtils.getGlossarySummaryForTerm("getTermByGuid", userId, this.oMRSAPIHelper, termAnchor, gotTerm);
                        if (response.getResponseCategory().equals((Object)ResponseCategory.GlossarySummary)) {
                            GlossarySummaryResponse glossarySummaryResponse = (GlossarySummaryResponse)response;
                            GlossarySummary glossarySummary = glossarySummaryResponse.getGlossarySummary();
                            gotTerm.setGlossary(glossarySummary);
                            response = new TermResponse(gotTerm);
                        }
                    } else {
                        response = new TermResponse(gotTerm);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getTermByGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findTerm(String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findTerm";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType(this.oMRSAPIHelper, "findTerm", userId, "GlossaryTerm", asOfTime, offset, pageSize) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findTerm", userId, "GlossaryTerm", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty, "findTerm");
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entityDetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Term> terms = new ArrayList<Term>();
            if (entityDetails == null) {
                response = new TermsResponse(terms);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entityDetails.iterator();
                while (iterator.hasNext() && (response = this.getTermByGuid(userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Term) {
                    TermResponse termResponse = (TermResponse)response;
                    Term term = termResponse.getTerm();
                    terms.add(term);
                }
                if (response.getResponseCategory() == ResponseCategory.Term) {
                    response = new TermsResponse(terms);
                }
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermRelationships(String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getTermRelationships";
        return this.getRelationshipsFromGuid(methodName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateTerm(String userId, String guid, Term suppliedTerm, boolean isReplace) {
        String methodName = "updateTerm";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateTerm", suppliedTerm.getNodeType(), NodeType.Term, NodeType.Activity});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateTerm", (String)guid, (String)"guid");
            response = this.getTermByGuid(userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Term)) {
                Term originalTerm = ((TermResponse)response).getTerm();
                Term updateTerm = new Term();
                updateTerm.setSystemAttributes(originalTerm.getSystemAttributes());
                if (isReplace) {
                    updateTerm.setName(suppliedTerm.getName());
                    updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                    updateTerm.setDescription(suppliedTerm.getDescription());
                    updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                    updateTerm.setExamples(suppliedTerm.getExamples());
                    updateTerm.setUsage(suppliedTerm.getUsage());
                    updateTerm.setObjectIdentifier(suppliedTerm.isObjectIdentifier());
                    updateTerm.setSpineAttribute(suppliedTerm.isSpineAttribute());
                    updateTerm.setSpineObject(suppliedTerm.isSpineObject());
                    updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                    updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                } else {
                    if (suppliedTerm.getName() == null) {
                        updateTerm.setName(originalTerm.getName());
                    } else {
                        updateTerm.setName(suppliedTerm.getName());
                    }
                    if (suppliedTerm.getQualifiedName() == null) {
                        updateTerm.setQualifiedName(originalTerm.getQualifiedName());
                    } else {
                        updateTerm.setQualifiedName(suppliedTerm.getQualifiedName());
                    }
                    if (suppliedTerm.getDescription() == null) {
                        updateTerm.setDescription(originalTerm.getDescription());
                    } else {
                        updateTerm.setDescription(suppliedTerm.getDescription());
                    }
                    if (suppliedTerm.getUsage() == null) {
                        updateTerm.setUsage(originalTerm.getUsage());
                    } else {
                        updateTerm.setUsage(suppliedTerm.getUsage());
                    }
                    if (suppliedTerm.getAbbreviation() == null) {
                        updateTerm.setAbbreviation(originalTerm.getAbbreviation());
                    } else {
                        updateTerm.setAbbreviation(suppliedTerm.getAbbreviation());
                    }
                    if (suppliedTerm.getAdditionalProperties() == null) {
                        updateTerm.setAdditionalProperties(originalTerm.getAdditionalProperties());
                    } else {
                        updateTerm.setAdditionalProperties(suppliedTerm.getAdditionalProperties());
                    }
                    if (suppliedTerm.getExamples() == null) {
                        updateTerm.setExamples(originalTerm.getExamples());
                    } else {
                        updateTerm.setExamples(suppliedTerm.getExamples());
                    }
                }
                GovernanceActions suppliedGovernanceActions = suppliedTerm.getGovernanceActions();
                updateTerm.setGovernanceActions(suppliedGovernanceActions);
                Date termFromTime = suppliedTerm.getEffectiveFromTime();
                Date termToTime = suppliedTerm.getEffectiveToTime();
                updateTerm.setEffectiveFromTime(termFromTime);
                updateTerm.setEffectiveToTime(termToTime);
                EntityDetail updateEntityDetail = termMapper.mapNodeToEntityDetail((Node)updateTerm);
                response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateTerm", userId, updateEntityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    if (updateEntityDetail.getClassifications() != null && !updateEntityDetail.getClassifications().isEmpty()) {
                        Classification classification;
                        Iterator iterator = updateEntityDetail.getClassifications().iterator();
                        while (iterator.hasNext() && (response = this.oMRSAPIHelper.callOMRSClassifyEntity("updateTerm", userId, guid, (classification = (Classification)iterator.next()).getName(), classification.getProperties())).getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        }
                    }
                    if (updateEntityDetail.getClassifications() != null && !updateEntityDetail.getClassifications().isEmpty()) {
                        Set currentClassificationNames = updateEntityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toSet());
                        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getRetention() != null && !currentClassificationNames.contains("Retention")) {
                            response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Retention");
                        }
                        if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getCriticality() != null && !currentClassificationNames.contains("Criticality")) {
                            response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Criticality");
                        }
                        if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getConfidence() != null && !currentClassificationNames.contains("Confidence")) {
                            response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Confidence");
                        }
                        if (!response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail) && originalTerm.getGovernanceActions().getConfidentiality() != null && !currentClassificationNames.contains("Confidentility")) {
                            response = this.oMRSAPIHelper.callOMRSDeClassifyEntity("updateTerm", userId, guid, "Confidentility");
                        }
                    }
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                        response = this.getTermByGuid(userId, guid);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateTerm,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTerm(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteTerm", (String)guid, (String)"guid");
            String source = this.oMRSAPIHelper.getServiceName();
            String typeDefName = "GlossaryTerm";
            String typeDefGuid = repositoryHelper.getTypeDefByName(source, typeDefName).getGUID();
            if (isPurge.booleanValue()) {
                response = this.oMRSAPIHelper.callOMRSPurgeEntity("deleteTerm", userId, typeDefName, typeDefGuid, guid);
            } else {
                response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteTerm", userId, typeDefName, typeDefGuid, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                    TermMapper termMapper = new TermMapper(this.oMRSAPIHelper);
                    Term term = termMapper.mapEntityDetailToNode(entityDetail);
                    response = new TermResponse(term);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteTerm,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTerm(String userId, String guid) {
        String methodName = "restoreTerm";
        SubjectAreaOMASAPIResponse response = null;
        SubjectAreaTermRESTServices termRESTServices = new SubjectAreaTermRESTServices();
        termRESTServices.setOMRSAPIHelper(this.oMRSAPIHelper);
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreTerm", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreTerm", userId, guid);
            if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                response = this.getTermByGuid(userId, guid);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreTerm,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

