/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeBundle;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.NodeBundle;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;

public class INodeBundleFactory {
    private final OMRSAPIHelper omrsapiHelper;

    public INodeBundleFactory(OMRSAPIHelper omrsapiHelper) {
        this.omrsapiHelper = omrsapiHelper;
    }

    public INodeBundle getInstance(String bundleName) {
        NodeBundle bundle = null;
        if (bundleName.equals(Term.class.getName())) {
            bundle = new NodeBundle(new TermMapper(this.omrsapiHelper), Term.class.getName());
        } else if (bundleName.equals(Category.class.getName())) {
            bundle = new NodeBundle(new CategoryMapper(this.omrsapiHelper), Category.class.getName());
        } else if (bundleName.equals(Glossary.class.getName())) {
            bundle = new NodeBundle(new GlossaryMapper(this.omrsapiHelper), Glossary.class.getName());
        }
        return bundle;
    }
}

