/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryMapper
extends EntityDetailMapper
implements INodeMapper {
    private static final Logger log = LoggerFactory.getLogger(CategoryMapper.class);
    private static final String className = CategoryMapper.class.getName();
    public static final String GLOSSARY_CATEGORY = "GlossaryCategory";

    public CategoryMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    public Category mapEntityDetailToNode(EntityDetail entityDetail) throws InvalidParameterException {
        String methodName = "mapEntityDetailToNode";
        String entityTypeName = entityDetail.getType().getTypeDefName();
        if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), entityTypeName, GLOSSARY_CATEGORY)) {
            Set classificationNames;
            Category category = new Category();
            if (entityDetail.getClassifications() != null && (classificationNames = entityDetail.getClassifications().stream().map(x -> x.getName()).collect(Collectors.toSet())).contains("SubjectArea")) {
                category = new SubjectAreaDefinition();
            }
            this.mapEntityDetailToNode((Node)category, entityDetail);
            return category;
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.MAPPER_ENTITY_GUID_TYPE_ERROR.getMessageDefinition();
        messageDefinition.setMessageParameters(new String[]{entityDetail.getGUID(), entityTypeName, GLOSSARY_CATEGORY});
        throw new InvalidParameterException(messageDefinition, className, methodName, "Node Type", null);
    }

    @Override
    protected void mapNodeToInstanceProperties(Node node, InstanceProperties instanceProperties) {
        if (node.getName() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "displayName");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Node node, Classification omasClassification) {
        Category category = (Category)node;
        boolean handled = false;
        String classificationName = omasClassification.getClassificationName();
        NodeType nodeType = NodeType.Category;
        if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), "SubjectArea", classificationName)) {
            nodeType = NodeType.SubjectAreaDefinition;
            handled = true;
        }
        category.setNodeType(nodeType);
        return handled;
    }

    @Override
    protected List<Classification> getInlinedClassifications(Node node) {
        ArrayList<Classification> inlinedClassifications = new ArrayList<Classification>();
        if (node.getNodeType() == NodeType.SubjectAreaDefinition) {
            SubjectArea subjectArea = new SubjectArea();
            subjectArea.setName(node.getName());
            inlinedClassifications.add((Classification)subjectArea);
        }
        return inlinedClassifications;
    }

    @Override
    protected String getTypeName() {
        return GLOSSARY_CATEGORY;
    }
}

