/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectMapper
extends EntityDetailMapper
implements INodeMapper {
    private static final Logger log = LoggerFactory.getLogger(ProjectMapper.class);
    private static final String className = ProjectMapper.class.getName();
    public static final String PROJECT = "Project";
    public static final String GLOSSARY_PROJECT = "GlossaryProject";

    public ProjectMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    public Project mapEntityDetailToNode(EntityDetail entityDetail) throws InvalidParameterException {
        String methodName = "mapEntityDetailToNode";
        String entityTypeName = entityDetail.getType().getTypeDefName();
        if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), entityTypeName, PROJECT)) {
            Project project = new Project();
            List omrsClassifications = entityDetail.getClassifications();
            if (omrsClassifications != null) {
                for (Classification omrsClassification : omrsClassifications) {
                    if (this.repositoryHelper.isTypeOf(this.omrsapiHelper.getServiceName(), GLOSSARY_PROJECT, omrsClassification.getName())) {
                        project = new GlossaryProject();
                        continue;
                    }
                    project = new Project();
                }
            }
            this.mapEntityDetailToNode((Node)project, entityDetail);
            return project;
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.MAPPER_ENTITY_GUID_TYPE_ERROR.getMessageDefinition();
        messageDefinition.setMessageParameters(new String[]{entityDetail.getGUID(), entityTypeName, PROJECT});
        throw new InvalidParameterException(messageDefinition, className, methodName, "Node Type", null);
    }

    @Override
    protected List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> getInlinedClassifications(Node node) {
        ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> inlinedClassifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
        if (node.getNodeType() == NodeType.GlossaryProject) {
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.GlossaryProject glossaryProjectClassification = new org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.GlossaryProject();
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)glossaryProjectClassification);
        }
        return inlinedClassifications;
    }

    @Override
    protected boolean mapPrimitiveToNode(Node node, String propertyName, Object value) {
        Project project = (Project)node;
        boolean foundProperty = true;
        if (propertyName.equals("startDate")) {
            Date dateValue = (Date)value;
            project.setStartDate(dateValue);
        } else if (propertyName.equals("plannedEndDate")) {
            Date dateValue = (Date)value;
            project.setPlannedEndDate(dateValue);
        } else if (propertyName.equals("status")) {
            String stringValue = (String)value;
            project.setStatus(stringValue);
        } else {
            foundProperty = false;
        }
        return foundProperty;
    }

    @Override
    protected void mapNodeToInstanceProperties(Node node, InstanceProperties instanceProperties) {
        Project project = (Project)node;
        if (project.getStatus() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, project.getStatus(), "status");
        }
        if (project.getStartDate() != null) {
            SubjectAreaUtils.setDatePropertyInInstanceProperties(instanceProperties, project.getStartDate(), "startDate");
        }
        if (project.getPlannedEndDate() != null) {
            SubjectAreaUtils.setDatePropertyInInstanceProperties(instanceProperties, project.getPlannedEndDate(), "plannedEndDate");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Node node, org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        Project project = (Project)node;
        boolean handled = false;
        String classificationName = omasClassification.getClassificationName();
        NodeType existingNodeType = project.getNodeType();
        if (existingNodeType == null) {
            existingNodeType = NodeType.Project;
        }
        String sourceName = this.omrsapiHelper.getServiceName();
        if (existingNodeType == NodeType.Project && this.repositoryHelper.isTypeOf(sourceName, GLOSSARY_PROJECT, classificationName)) {
            project.setNodeType(NodeType.GlossaryProject);
            handled = true;
        } else {
            project.setNodeType(existingNodeType);
            handled = true;
        }
        return handled;
    }

    @Override
    protected String getTypeName() {
        return PROJECT;
    }
}

