/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ExceptionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryRESTServices.class);
    private static final String className = SubjectAreaCategoryRESTServices.class.getName();
    private static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaCategoryRESTServices() {
    }

    public SubjectAreaCategoryRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse createCategory(String serverName, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler categoryHandler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "createCategory");
            SubjectAreaGlossaryHandler glossaryHandler = instanceHandler.getSubjectAreaGlossaryHandler(userId, serverName, "createCategory");
            response = categoryHandler.createCategory(glossaryHandler, userId, suppliedCategory);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategoryByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getCategoryByGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "getCategoryByGuid");
            response = handler.getCategory(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategoryByGuid,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getResponse(Category gotCategory) {
        CategoryResponse response;
        if (gotCategory.getNodeType() == NodeType.SubjectAreaDefinition) {
            SubjectAreaDefinition subjectAreaDefinition = (SubjectAreaDefinition)gotCategory;
            response = new SubjectAreaDefinitionResponse(subjectAreaDefinition);
        } else {
            response = new CategoryResponse(gotCategory);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findCategory(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "findCategory");
            response = handler.findCategory(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, methodName);
            response = handler.getCategoryRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateCategory(String serverName, String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "updateCategory");
            response = handler.updateCategory(userId, guid, suppliedCategory, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "deleteCategory");
            response = handler.deleteCategory(userId, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreCategory,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaCategoryHandler handler = instanceHandler.getSubjectAreaCategoryHandler(userId, serverName, "restoreCategory");
            response = handler.restoreCategory(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

