/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ExceptionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGraphRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaGraphRESTServices.class);
    private static final String className = SubjectAreaGraphRESTServices.class.getName();
    private static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaGraphRESTServices() {
    }

    public SubjectAreaGraphRESTServices(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse getGraph(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String lineFilterStr, StatusFilter statusFilter, Integer level) {
        String methodName = "getGraph";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getGraph,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaGraphHandler handler = instanceHandler.getSubjectAreaGraphHandler(userId, serverName, "getGraph");
            response = handler.getGraph(userId, guid, asOfTime, nodeFilterStr, lineFilterStr, statusFilter, level);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getGraph,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    private void setNodeTypeInNode(String methodName, OMRSRepositoryHelper oMRSRepositoryHelper, EntityDetail entity, Node node) {
        String typeDefName = entity.getType().getTypeDefName();
        String nodeType = null;
        if (oMRSRepositoryHelper.isTypeOf(methodName, typeDefName, "GlossaryTerm")) {
            nodeType = "Term";
        }
        if (oMRSRepositoryHelper.isTypeOf(methodName, typeDefName, "GlossaryCategory")) {
            nodeType = "Category";
        }
        if (oMRSRepositoryHelper.isTypeOf(methodName, typeDefName, "Glossary")) {
            nodeType = "Glossary";
        }
        if (oMRSRepositoryHelper.isTypeOf(methodName, typeDefName, "Asset")) {
            nodeType = "Asset";
        }
        if (oMRSRepositoryHelper.isTypeOf(methodName, typeDefName, "Project")) {
            nodeType = "Project";
        }
        List classifications = entity.getClassifications();
        Set classificationNames = null;
        if (classifications != null && !classifications.isEmpty()) {
            classificationNames = classifications.stream().map(Classification::getName).collect(Collectors.toSet());
        }
        for (NodeType nodeTypeValue : NodeType.values()) {
            if (!nodeTypeValue.name().equals(nodeType)) continue;
            if (classificationNames != null) {
                if (nodeType.equals("Category") && classificationNames.contains("SubjectArea")) {
                    node.setNodeType(NodeType.SubjectAreaDefinition);
                } else if (nodeType.equals("Glossary")) {
                    if (classificationNames.contains("Taxonomy") && classificationNames.contains("CanonicalGlossary")) {
                        node.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
                    } else if (classificationNames.contains("Taxonomy")) {
                        node.setNodeType(NodeType.Taxonomy);
                    } else if (classificationNames.contains("CanonicalGlossary")) {
                        node.setNodeType(NodeType.CanonicalGlossary);
                    }
                } else if (typeDefName.equals("Term") && classificationNames.contains("Activity")) {
                    node.setNodeType(NodeType.Activity);
                } else if (typeDefName.equals("Project") && classificationNames.contains("GlossaryProject")) {
                    node.setNodeType(NodeType.GlossaryProject);
                }
            }
            if (node.getNodeType() != NodeType.Unknown) continue;
            node.setNodeType(nodeTypeValue);
        }
    }
}

