/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaRelationshipHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ExceptionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaRESTServicesInstance.class);
    private static final String className = SubjectAreaRESTServicesInstance.class.getName();
    public static final String PAGE_OFFSET_DEFAULT_VALUE = "0";
    public static final String PAGE_SIZE_DEFAULT_VALUE = "0";
    protected OMRSAPIHelper oMRSAPIHelper = null;
    protected static SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    protected SubjectAreaOMASAPIResponse initializeAPI(String serverName, String userId, String restAPIName) {
        return this.initializeAPI(serverName, userId, null, null, restAPIName);
    }

    protected SubjectAreaOMASAPIResponse initializeAPI(String serverName, String userId, Date from, Date to, String restAPIName) {
        return null;
    }

    public void setOMRSAPIHelper(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    public SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String serverName, String restAPIName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        SubjectAreaOMASAPIResponse response;
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",guid=" + guid);
        }
        if ((response = this.initializeAPI(serverName, userId, "getRelationshipsFromGuid")) == null) {
            try {
                RelationshipsResponse relationshipsResponse;
                InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)guid, (String)"guid");
                if (offset == null) {
                    offset = new Integer(0);
                }
                if (pageSize == null) {
                    pageSize = new Integer(0);
                }
                if (sequencingProperty != null) {
                    sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
                }
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
                List<Relationship> omrsRelationships = null;
                response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships())).getResponseCategory() == ResponseCategory.Lines) {
                    LinesResponse linesResponse = (LinesResponse)response;
                    List linesToReturn = linesResponse.getLines();
                    if (pageSize > 0) {
                        int sizeToGet = 0;
                        if (omrsRelationships.size() > linesToReturn.size()) {
                            sizeToGet = omrsRelationships.size() - linesToReturn.size();
                        }
                        offset = offset + omrsRelationships.size();
                        while (sizeToGet > 0) {
                            List moreLines;
                            List<Relationship> moreOmrsRelationships;
                            response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, sizeToGet);
                            sizeToGet = 0;
                            if (response.getResponseCategory() != ResponseCategory.OmrsRelationships || (moreOmrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) == null || moreOmrsRelationships.size() <= 0 || (response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships)).getResponseCategory() != ResponseCategory.Lines || (moreLines = (linesResponse = (LinesResponse)response).getLines()) == null || moreLines.isEmpty()) continue;
                            linesToReturn.addAll(moreLines);
                            sizeToGet = moreOmrsRelationships.size() - moreLines.size();
                            offset = offset + moreOmrsRelationships.size();
                        }
                        response = new LinesResponse(linesToReturn);
                    }
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
            catch (UnsupportedEncodingException e) {
                SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)new InvalidParameterException(errorCode.getMessageDefinition(), className, "getRelationshipsFromGuid", "sequencingProperty", sequencingProperty));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",entity userId=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            RelationshipsResponse relationshipsResponse;
            List<Relationship> omrsRelationships;
            InputValidator.validateUserIdNotNull((String)className, (String)"getRelationshipsFromGuid", (String)userId);
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)entityGuid, (String)"entityGuid");
            response = this.oMRSAPIHelper.callGetRelationshipsForEntity(restAPIName, userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) != null) {
                HashSet<Relationship> relationshipSet = new HashSet<Relationship>(omrsRelationships);
                response = SubjectAreaUtils.convertOMRSRelationshipsToOMASLines(this.oMRSAPIHelper, omrsRelationships);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ",userId=" + entityGuid);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse createLine(String serverName, String restAPIName, String userId, String className, Line line) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.createLine(restAPIName, userId, className, line);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse getLine(String serverName, String restAPIName, String userId, String className, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.getLine(restAPIName, userId, className, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse updateLine(String serverName, String restAPIName, String userId, String className, Line line, boolean isReplace) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.updateLine(restAPIName, userId, className, line, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteLine(String serverName, String restAPIName, String userId, String className, String guid, Boolean isPurge) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.deleteLine(restAPIName, userId, className, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse restoreLine(String serverName, String restAPIName, String userId, String className, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + restAPIName + ",userId=" + userId + ",className=" + className);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaRelationshipHandler handler = instanceHandler.getSubjectAreaRelationshipHandler(userId, serverName, restAPIName);
            response = handler.restoreLine(restAPIName, userId, className, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ",className=" + className + ", response =" + response);
        }
        return response;
    }
}

