/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.Status;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaDefinitionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.TypeGuids;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaCategoryHandler
extends SubjectAreaHandler {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaCategoryHandler.class);
    private static final String className = SubjectAreaCategoryHandler.class.getName();

    public SubjectAreaCategoryHandler(OMRSAPIHelper oMRSAPIHelper) {
        super(oMRSAPIHelper);
    }

    @Override
    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        CategoryMapper categoryMapper = new CategoryMapper(this.oMRSAPIHelper);
        try {
            Category category = categoryMapper.mapEntityDetailToNode(entityDetail);
            if (category.getNodeType() == NodeType.SubjectAreaDefinition) {
                SubjectAreaDefinition subjectArea = (SubjectAreaDefinition)category;
                response = new CategoryResponse((Category)subjectArea);
            } else {
                response = new CategoryResponse(category);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createCategory(SubjectAreaGlossaryHandler glossaryHandler, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail entityDetail;
            String suppliedCategoryName;
            InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            String suppliedCategoryParentGuid = null;
            if (suppliedCategory.getParentCategory() != null) {
                suppliedCategoryParentGuid = suppliedCategory.getParentCategory().getGuid();
            }
            if ((suppliedCategoryName = suppliedCategory.getName()) == null || suppliedCategoryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME.getMessageDefinition();
                String propertyName = "Name";
                String propertyValue = null;
                messageDefinition.setMessageParameters(new String[]{propertyName, propertyValue});
                throw new InvalidParameterException(messageDefinition, className, "createCategory", propertyName, propertyValue);
            }
            GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
            SubjectAreaOMASAPIResponse glossaryResponse = this.validateGlossarySummaryDuringCreation(glossaryHandler, userId, "createCategory", suppliedGlossary);
            if (glossaryResponse.getResponseCategory().equals((Object)ResponseCategory.Glossary) && (response = this.oMRSAPIHelper.callOMRSAddEntity("createCategory", userId, entityDetail = new CategoryMapper(this.oMRSAPIHelper).mapNodeToEntityDetail((Node)suppliedCategory))).getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                entityDetail = entityDetailResponse.getEntityDetail();
                String categoryGuid = entityDetail.getGUID();
                Glossary associatedGlossary = ((GlossaryResponse)glossaryResponse).getGlossary();
                String glossaryGuid = associatedGlossary.getSystemAttributes().getGUID();
                CategoryAnchor categoryAnchor = new CategoryAnchor();
                categoryAnchor.setGlossaryGuid(glossaryGuid);
                categoryAnchor.setCategoryGuid(categoryGuid);
                Relationship categoryAnchorRelationship = new CategoryAnchorMapper(this.oMRSAPIHelper).mapLineToRelationship((Line)categoryAnchor);
                response = this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, categoryAnchorRelationship);
                if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                    if (suppliedCategoryParentGuid != null) {
                        CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
                        categoryHierarchyLink.setSuperCategoryGuid(suppliedCategoryParentGuid);
                        categoryHierarchyLink.setSubCategoryGuid(categoryGuid);
                        Relationship relationship = new CategoryHierarchyLinkMapper(this.oMRSAPIHelper).mapLineToRelationship((Line)categoryHierarchyLink);
                        response = this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, relationship);
                    }
                    if (response.getResponseCategory() == ResponseCategory.OmrsRelationship) {
                        response = this.getCategory(userId, categoryGuid);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String userId, String guid) {
        String methodName = "getCategory";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getCategory", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getCategory", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                EntityDetail gotEntityDetail = entityDetailResponse.getEntityDetail();
                CategoryMapper categoryMapper = new CategoryMapper(this.oMRSAPIHelper);
                Category gotCategory = categoryMapper.mapEntityDetailToNode(gotEntityDetail);
                String anchorTypeGuid = TypeGuids.getCategoryAnchorTypeGuid();
                response = this.oMRSAPIHelper.callGetRelationshipsForEntity("getCategory", userId, guid, anchorTypeGuid, 0, null, null, null, 0);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                    RelationshipsResponse relationshipsResponse = (RelationshipsResponse)response;
                    List<Relationship> glossaryRelationships = relationshipsResponse.getRelationships();
                    if (glossaryRelationships.iterator().hasNext()) {
                        Relationship glossaryRelationship = glossaryRelationships.iterator().next();
                        CategoryAnchor categoryAnchor = (CategoryAnchor)new CategoryAnchorMapper(this.oMRSAPIHelper).mapRelationshipToLine(glossaryRelationship);
                        response = this.oMRSAPIHelper.getGlossarySummary("getCategory", userId, (Line)categoryAnchor);
                        if (response.getResponseCategory().equals((Object)ResponseCategory.GlossarySummary)) {
                            GlossarySummaryResponse glossarySummaryResponse = (GlossarySummaryResponse)response;
                            GlossarySummary glossarySummary = glossarySummaryResponse.getGlossarySummary();
                            gotCategory.setGlossary(glossarySummary);
                            response = this.createCategoryResponse(gotCategory);
                        }
                    } else {
                        response = this.createCategoryResponse(gotCategory);
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse createCategoryResponse(Category gotCategory) {
        CategoryResponse response;
        if (gotCategory.getNodeType() == NodeType.SubjectAreaDefinition) {
            SubjectAreaDefinition subjectAreaDefinition = (SubjectAreaDefinition)gotCategory;
            response = new SubjectAreaDefinitionResponse(subjectAreaDefinition);
        } else {
            response = new CategoryResponse(gotCategory);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findCategory(String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findCategory,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType("findCategory", userId, "GlossaryCategory", asOfTime, offset, pageSize, sequencingProperty, sequencingOrder) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findCategory", userId, "GlossaryCategory", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetails) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entitydetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Category> categories = new ArrayList<Category>();
            if (entitydetails == null) {
                response = new CategoriesResponse(categories);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entitydetails.iterator();
                while (iterator.hasNext() && (response = this.getCategory(userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Category) {
                    CategoryResponse categoryResponse = (CategoryResponse)response;
                    Category category = categoryResponse.getCategory();
                    categories.add(category);
                }
                if (response.getResponseCategory() == ResponseCategory.Category) {
                    response = new CategoriesResponse(categories);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findCategory,userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryRelationships(String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String restAPIName = "getCategoryRelationships";
        return this.getRelationshipsFromGuid(restAPIName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateCategory(String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateUserIdNotNull((String)className, (String)"updateCategory", (String)userId);
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateCategory", (String)guid, (String)"guid");
            response = this.getCategory(userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Category)) {
                Status status;
                Category originalCategory = ((CategoryResponse)response).getCategory();
                if (originalCategory.getSystemAttributes() != null) {
                    status = originalCategory.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.GLOSSARY_UPDATE_FAILED_ON_DELETED_GLOSSARY);
                }
                if (suppliedCategory.getSystemAttributes() != null) {
                    status = suppliedCategory.getSystemAttributes().getStatus();
                    SubjectAreaUtils.checkStatusNotDeleted(status, SubjectAreaErrorCode.STATUS_UPDATE_TO_DELETED_NOT_ALLOWED);
                }
                Category updateCategory = originalCategory;
                if (isReplace) {
                    updateCategory.setName(suppliedCategory.getName());
                    updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                    updateCategory.setDescription(suppliedCategory.getDescription());
                    updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                } else {
                    if (suppliedCategory.getName() != null) {
                        updateCategory.setName(suppliedCategory.getName());
                    }
                    if (suppliedCategory.getQualifiedName() != null) {
                        updateCategory.setQualifiedName(suppliedCategory.getQualifiedName());
                    }
                    if (suppliedCategory.getDescription() != null) {
                        updateCategory.setDescription(suppliedCategory.getDescription());
                    }
                    if (suppliedCategory.getAdditionalProperties() != null) {
                        updateCategory.setAdditionalProperties(suppliedCategory.getAdditionalProperties());
                    }
                }
                Date termFromTime = suppliedCategory.getEffectiveFromTime();
                Date termToTime = suppliedCategory.getEffectiveToTime();
                updateCategory.setEffectiveFromTime(termFromTime);
                updateCategory.setEffectiveToTime(termToTime);
                CategoryMapper mapper = new CategoryMapper(this.oMRSAPIHelper);
                EntityDetail updateEntityDetail = mapper.mapNodeToEntityDetail((Node)updateCategory);
                String categoryGuid = updateCategory.getSystemAttributes().getGUID();
                response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateCategory", userId, updateEntityDetail);
                if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                    response = this.getCategory(userId, categoryGuid);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateCategory,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        SubjectAreaOMASAPIResponse response = null;
        OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteCategory", (String)guid, (String)"guid");
            String source = this.oMRSAPIHelper.getServiceName();
            String typeDefName = "GlossaryCategory";
            String typeDefGuid = repositoryHelper.getTypeDefByName(source, typeDefName).getGUID();
            if (isPurge.booleanValue()) {
                response = this.oMRSAPIHelper.callOMRSPurgeEntity("deleteCategory", userId, typeDefName, typeDefGuid, guid);
            } else {
                response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteCategory", userId, typeDefName, typeDefGuid, guid);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                    EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                    CategoryMapper categoryMapper = new CategoryMapper(this.oMRSAPIHelper);
                    Category deletedCategory = categoryMapper.mapEntityDetailToNode(entityDetail);
                    response = this.createCategoryResponse(deletedCategory);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteCategory,userId=" + userId);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreCategory(String userId, String guid) {
        String methodName = "restoreCategory";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreCategory", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreCategory", userId, guid);
            if (response.getResponseCategory() == ResponseCategory.OmrsEntityDetail) {
                response = this.getCategory(userId, guid);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreCategory,userId=" + userId + ", response=" + response);
        }
        return response;
    }
}

