/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalTaxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.EntityNotDeletedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaGlossaryHandler
extends SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaGlossaryHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);

    public SubjectAreaGlossaryHandler(OMRSAPIHelper oMRSAPIHelper) {
        super(oMRSAPIHelper);
    }

    @Override
    protected SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse response) {
        EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
        EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
        GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
        try {
            Glossary glossary = glossaryMapper.mapEntityDetailToNode(entityDetail);
            if (glossary.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
                CanonicalTaxonomy canonicalTaxonomy = (CanonicalTaxonomy)glossary;
                response = new GlossaryResponse((Glossary)canonicalTaxonomy);
            } else if (glossary.getNodeType() == NodeType.Taxonomy) {
                Taxonomy taxonomy = (Taxonomy)glossary;
                response = new GlossaryResponse((Glossary)taxonomy);
            } else if (glossary.getNodeType() == NodeType.CanonicalGlossary) {
                CanonicalGlossary canonicalGlossary = (CanonicalGlossary)glossary;
                response = new GlossaryResponse((Glossary)canonicalGlossary);
            } else {
                response = new GlossaryResponse(glossary);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse createGlossary(String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            String suppliedGlossaryName = suppliedGlossary.getName();
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME.getMessageDefinition();
                String propertyName = "Name";
                String propertyValue = null;
                messageDefinition.setMessageParameters(new String[]{propertyName, propertyValue});
                throw new InvalidParameterException(messageDefinition, className, "createGlossary", propertyName, propertyValue);
            }
            GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
            EntityDetail glossaryEntityDetail = glossaryMapper.mapNodeToEntityDetail((Node)suppliedGlossary);
            response = this.oMRSAPIHelper.callOMRSAddEntity("createGlossary", userId, glossaryEntityDetail);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
                EntityDetail entityDetail = entityDetailResponse.getEntityDetail();
                response = this.getGlossaryByGuid(userId, entityDetail.getGUID());
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryByGuid(String userId, String guid) {
        String methodName = "getGlossaryByGuid";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSGetEntityByGuid("getGlossaryByGuid", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                response = this.getResponse(response);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findGlossary(String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        SubjectAreaOMASAPIResponse response = null;
        response = searchCriteria == null ? this.oMRSAPIHelper.getEntitiesByType("findGlossary", userId, "Glossary", asOfTime, offset, pageSize, sequencingProperty, sequencingOrder) : this.oMRSAPIHelper.findEntitiesByPropertyValue("findGlossary", userId, "Glossary", searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetails)) {
            EntityDetailsResponse entityDetailsResponse = (EntityDetailsResponse)response;
            List<EntityDetail> entityDetails = entityDetailsResponse.getEntityDetails();
            ArrayList<Glossary> glossaries = new ArrayList<Glossary>();
            if (entityDetails == null) {
                response = new GlossariesResponse(glossaries);
            } else {
                EntityDetail entityDetail;
                Iterator<EntityDetail> iterator = entityDetails.iterator();
                while (iterator.hasNext() && (response = this.getGlossaryByGuid(userId, (entityDetail = iterator.next()).getGUID())).getResponseCategory() == ResponseCategory.Glossary) {
                    GlossaryResponse glossaryResponse = (GlossaryResponse)response;
                    Glossary glossary = glossaryResponse.getGlossary();
                    glossaries.add(glossary);
                }
                if (response.getResponseCategory() == ResponseCategory.Glossary) {
                    response = new GlossariesResponse(glossaries);
                }
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryRelationships(String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        return this.getRelationshipsFromGuid(methodName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    public SubjectAreaOMASAPIResponse updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            InputValidator.validateGUIDNotNull((String)className, (String)"updateGlossary", (String)guid, (String)"guid");
            response = this.getGlossaryByGuid(userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.Glossary)) {
                Glossary updateGlossary = ((GlossaryResponse)response).getGlossary();
                if (isReplace) {
                    updateGlossary.setName(suppliedGlossary.getName());
                    updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    updateGlossary.setDescription(suppliedGlossary.getDescription());
                    updateGlossary.setUsage(suppliedGlossary.getUsage());
                    updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                } else {
                    if (suppliedGlossary.getName() != null) {
                        updateGlossary.setName(suppliedGlossary.getName());
                    }
                    if (suppliedGlossary.getQualifiedName() != null) {
                        updateGlossary.setQualifiedName(suppliedGlossary.getQualifiedName());
                    }
                    if (suppliedGlossary.getDescription() != null) {
                        updateGlossary.setDescription(suppliedGlossary.getDescription());
                    }
                    if (suppliedGlossary.getUsage() != null) {
                        updateGlossary.setUsage(suppliedGlossary.getUsage());
                    }
                    if (suppliedGlossary.getAdditionalProperties() != null) {
                        updateGlossary.setAdditionalProperties(suppliedGlossary.getAdditionalProperties());
                    }
                }
                Date termFromTime = suppliedGlossary.getEffectiveFromTime();
                Date termToTime = suppliedGlossary.getEffectiveToTime();
                updateGlossary.setEffectiveFromTime(termFromTime);
                updateGlossary.setEffectiveToTime(termToTime);
                GlossaryMapper glossaryMapper = new GlossaryMapper(this.oMRSAPIHelper);
                EntityDetail entityDetail = glossaryMapper.mapNodeToEntityDetail((Node)updateGlossary);
                String glossaryGuid = entityDetail.getGUID();
                response = this.oMRSAPIHelper.callOMRSUpdateEntityProperties("updateGlossary", userId, entityDetail);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                    response = this.getGlossaryByGuid(userId, glossaryGuid);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateGlossary,userId=" + userId + ",response=" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteGlossary(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteGlossary";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"deleteGlossary", (String)guid, (String)"guid");
            ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
            statusList.add(InstanceStatus.ACTIVE);
            OMRSRepositoryHelper repositoryHelper = this.oMRSAPIHelper.getOMRSRepositoryHelper();
            String source = this.oMRSAPIHelper.getServiceName();
            String glossaryTypeDefName = "Glossary";
            String glossaryTypeDefGuid = repositoryHelper.getTypeDefByName(source, glossaryTypeDefName).getGUID();
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeEntity("deleteGlossary", userId, glossaryTypeDefName, glossaryTypeDefGuid, guid);
                response = new VoidResponse();
            } else {
                String termAnchorGuid = repositoryHelper.getTypeDefByName("deleteGlossary", "TermAnchor").getGUID();
                String categoryAnchorGuid = repositoryHelper.getTypeDefByName("deleteGlossary", "TermAnchor").getGUID();
                response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteGlossary", userId, guid, termAnchorGuid, 0, statusList, null, null, null, 1);
                if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                    RelationshipsResponse termAnchorRelationshipsResponse = (RelationshipsResponse)response;
                    List<Relationship> termRelationships = termAnchorRelationshipsResponse.getRelationships();
                    response = this.oMRSAPIHelper.callGetRelationshipsForEntity("deleteGlossary", userId, guid, categoryAnchorGuid, 0, statusList, null, null, null, 1);
                    if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsRelationships)) {
                        RelationshipsResponse categoryAnchorRelationshipsResponse = (RelationshipsResponse)response;
                        List<Relationship> categoryRelationships = categoryAnchorRelationshipsResponse.getRelationships();
                        if ((termRelationships == null || termRelationships.isEmpty()) && (categoryRelationships == null || categoryRelationships.isEmpty())) {
                            response = this.oMRSAPIHelper.callOMRSDeleteEntity("deleteGlossary", userId, glossaryTypeDefName, glossaryTypeDefGuid, guid);
                            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                                response = this.getResponse(response);
                            }
                        } else {
                            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid});
                            response = new EntityNotDeletedExceptionResponse((SubjectAreaCheckedException)new EntityNotDeletedException(messageDefinition, className, "deleteGlossary", guid));
                        }
                    }
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreGlossary(String userId, String guid) {
        String methodName = "restoreGlossary";
        SubjectAreaOMASAPIResponse response = null;
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"restoreGlossary", (String)guid, (String)"guid");
            response = this.oMRSAPIHelper.callOMRSRestoreEntity("restoreGlossary", userId, guid);
            if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
                response = this.getGlossaryByGuid(userId, guid);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        return response;
    }
}

