/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGlossaryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubjectAreaHandler {
    private static final Class<?> clazz = SubjectAreaHandler.class;
    private static final String className = clazz.getName();
    private static final Logger log = LoggerFactory.getLogger(clazz);
    protected OMRSAPIHelper oMRSAPIHelper;

    public SubjectAreaHandler(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
    }

    protected abstract SubjectAreaOMASAPIResponse getResponse(SubjectAreaOMASAPIResponse var1);

    protected SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getRelationshipsFromGuid";
        SubjectAreaOMASAPIResponse response = null;
        try {
            RelationshipsResponse relationshipsResponse;
            InputValidator.validateGUIDNotNull((String)className, (String)restAPIName, (String)guid, (String)"guid");
            if (sequencingProperty != null) {
                sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
            }
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
            List<Relationship> omrsRelationships = null;
            response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (response = this.oMRSAPIHelper.convertOMRSRelationshipsToOMASLines(omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships())).getResponseCategory() == ResponseCategory.Lines) {
                LinesResponse linesResponse = (LinesResponse)response;
                List linesToReturn = linesResponse.getLines();
                if (pageSize > 0) {
                    int sizeToGet = 0;
                    if (omrsRelationships.size() > linesToReturn.size()) {
                        sizeToGet = omrsRelationships.size() - linesToReturn.size();
                    }
                    offset += omrsRelationships.size();
                    while (sizeToGet > 0) {
                        List moreLines;
                        List<Relationship> moreOmrsRelationships;
                        response = this.getRelationshipsFromGuid(restAPIName, userId, guid, null, offset, asOfTime, sequencingProperty, omrsSequencingOrder, sizeToGet);
                        sizeToGet = 0;
                        if (response.getResponseCategory() != ResponseCategory.OmrsRelationships || (moreOmrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) == null || moreOmrsRelationships.size() <= 0 || (response = this.oMRSAPIHelper.convertOMRSRelationshipsToOMASLines(omrsRelationships)).getResponseCategory() != ResponseCategory.Lines || (moreLines = (linesResponse = (LinesResponse)response).getLines()) == null || moreLines.isEmpty()) continue;
                        linesToReturn.addAll(moreLines);
                        sizeToGet = moreOmrsRelationships.size() - moreLines.size();
                        offset += moreOmrsRelationships.size();
                    }
                    response = new LinesResponse(linesToReturn);
                }
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        catch (UnsupportedEncodingException e) {
            SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
            String propertyName = "sequencingProperty";
            String propertyValue = sequencingProperty;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{propertyName, propertyValue});
            InvalidParameterException invalidParameterException = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)invalidParameterException);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + restAPIName + ",userId=" + userId + ", Response=" + response);
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getRelationshipsFromGuid(String restAPIName, String userId, String entityGuid, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "getRelationshipsFromGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getRelationshipsFromGuid,userId=" + userId + ",entity userId=" + entityGuid + ",relationship Type Guid=" + relationshipTypeGuid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            RelationshipsResponse relationshipsResponse;
            List<Relationship> omrsRelationships;
            InputValidator.validateUserIdNotNull((String)className, (String)"getRelationshipsFromGuid", (String)userId);
            InputValidator.validateGUIDNotNull((String)className, (String)"getRelationshipsFromGuid", (String)entityGuid, (String)"entityGuid");
            response = this.oMRSAPIHelper.callGetRelationshipsForEntity(restAPIName, userId, entityGuid, relationshipTypeGuid, fromRelationshipElement, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            if (response.getResponseCategory() == ResponseCategory.OmrsRelationships && (omrsRelationships = (relationshipsResponse = (RelationshipsResponse)response).getRelationships()) != null) {
                HashSet<Relationship> relationshipSet = new HashSet<Relationship>(omrsRelationships);
                response = this.oMRSAPIHelper.convertOMRSRelationshipsToOMASLines(omrsRelationships);
            }
        }
        catch (InvalidParameterException e) {
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getRelationshipsFromGuid,userId=" + userId + ",userId=" + entityGuid);
        }
        return response;
    }

    protected SubjectAreaOMASAPIResponse validateGlossarySummaryDuringCreation(SubjectAreaGlossaryHandler glossaryHandler, String userId, String methodName, GlossarySummary suppliedGlossary) {
        SubjectAreaOMASAPIResponse response = null;
        String guid = null;
        String relationshipGuid = null;
        if (suppliedGlossary == null) {
            String propertyName = "glossary";
            String propertyValue = null;
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition(new String[]{propertyName, propertyValue});
            InvalidParameterException invalidParameterException = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
            response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
        } else {
            InvalidParameterException invalidParameterException;
            ExceptionMessageDefinition messageDefinition;
            String propertyValue;
            String propertyName;
            guid = suppliedGlossary.getGuid();
            relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                propertyName = "glossaryRelationshipGuid";
                propertyValue = null;
                messageDefinition = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP.getMessageDefinition(new String[]{propertyName, propertyValue});
                invalidParameterException = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
            }
            if (response == null) {
                if (guid == null) {
                    propertyName = "glossary guid";
                    propertyValue = null;
                    messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition(new String[]{propertyName, propertyValue});
                    invalidParameterException = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
                    response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
                } else {
                    response = glossaryHandler.getGlossaryByGuid(userId, guid);
                    if (response.getResponseCategory() != ResponseCategory.Glossary) {
                        propertyName = "glossary Guid";
                        propertyValue = guid;
                        messageDefinition = SubjectAreaErrorCode.CREATE_WITH_NON_EXISTANT_GLOSSARY_GUID.getMessageDefinition(new String[]{propertyName, propertyValue});
                        invalidParameterException = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
                        response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)invalidParameterException);
                    }
                }
            }
        }
        return response;
    }
}

