/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.listener;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.outtopic.SubjectAreaPublisher;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaOMRSTopicListener
extends OMRSTopicListenerBase {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaOMRSTopicListener.class);
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private String componentName;
    private List<String> supportedZones;
    private SubjectAreaPublisher publisher;

    public SubjectAreaOMRSTopicListener(Connection subjectAreaOutTopic, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String componentName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        super(componentName, auditLog);
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.componentName = componentName;
        this.publisher = new SubjectAreaPublisher(subjectAreaOutTopic, auditLog);
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event: " + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventType != null && instanceEventOriginator != null) {
                switch (instanceEventType) {
                    case NEW_ENTITY_EVENT: {
                        break;
                    }
                    case UPDATED_ENTITY_EVENT: {
                        break;
                    }
                    case CLASSIFIED_ENTITY_EVENT: {
                        break;
                    }
                    case RECLASSIFIED_ENTITY_EVENT: {
                        break;
                    }
                    case DECLASSIFIED_ENTITY_EVENT: {
                        break;
                    }
                    case DELETED_ENTITY_EVENT: {
                        break;
                    }
                    case PURGED_ENTITY_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring entity purge org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case UNDONE_ENTITY_EVENT: {
                        break;
                    }
                    case RESTORED_ENTITY_EVENT: {
                        break;
                    }
                    case REFRESH_ENTITY_REQUEST: 
                    case REFRESHED_ENTITY_EVENT: 
                    case RE_HOMED_ENTITY_EVENT: 
                    case RETYPED_ENTITY_EVENT: 
                    case RE_IDENTIFIED_ENTITY_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring entity repository maintenance org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case NEW_RELATIONSHIP_EVENT: {
                        break;
                    }
                    case UPDATED_RELATIONSHIP_EVENT: {
                        break;
                    }
                    case UNDONE_RELATIONSHIP_EVENT: {
                        break;
                    }
                    case DELETED_RELATIONSHIP_EVENT: {
                        break;
                    }
                    case PURGED_RELATIONSHIP_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring relationship purge org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case RESTORED_RELATIONSHIP_EVENT: {
                        break;
                    }
                    case REFRESH_RELATIONSHIP_REQUEST: 
                    case REFRESHED_RELATIONSHIP_EVENT: 
                    case RE_IDENTIFIED_RELATIONSHIP_EVENT: 
                    case RE_HOMED_RELATIONSHIP_EVENT: 
                    case RETYPED_RELATIONSHIP_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring relationship repository maintenance org.odpi.openmetadata.accessservices.subjectarea.common.events");
                        break;
                    }
                    case INSTANCE_ERROR_EVENT: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Ignoring instance error org.odpi.openmetadata.accessservices.subjectarea.common.events");
                    }
                }
            } else {
                log.debug("Ignored instance event - null type");
            }
        }
    }
}

