/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.handlers;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.ClassificationException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.FunctionNotSupportedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.RelationshipNotPurgedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ErrorHandler {
    static String className = ErrorHandler.class.getName();

    public static SubjectAreaOMASAPIResponse handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(new String[]{userId});
        UserNotAuthorizedException oe = new UserNotAuthorizedException(messageDefinition, className, methodName, userId);
        return OMASExceptionToResponse.convertUserNotAuthorizedException((UserNotAuthorizedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR.getMessageDefinition();
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleUnknownAsset(Throwable error, String assetGUID, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST.getMessageDefinition();
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(messageDefinition, className, methodName, assetGUID);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleInvalidParameterException(org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e, String methodName, String serverName, String serviceName) {
        String propertyName = e.getParameterName();
        String propertyValue = "unknown";
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_PARAMETER.getMessageDefinition(new String[]{propertyName, propertyValue});
        InvalidParameterException oe = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
        oe.setRelatedProperties(e.getRelatedProperties());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleTypeDefNotKnownException(String typeName, String methodName, String serverName, String serviceName) {
        String propertyName = "typeName";
        String propertyValue = typeName;
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(new String[]{propertyName, propertyValue});
        InvalidParameterException oe = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handlePropertyErrorException(PropertyErrorException e, String methodName, String serverName, String serviceName) {
        String propertyName = "unknown";
        String propertyValue = "unknown";
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_PARAMETER.getMessageDefinition(new String[]{propertyName, propertyValue});
        InvalidParameterException oe = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
        oe.setRelatedProperties(e.getRelatedProperties());
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleClassificationErrorException(ClassificationErrorException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CLASSIFICATION_ERROR.getMessageDefinition();
        ClassificationException oe = new ClassificationException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertClassificationException((ClassificationException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleStatusNotSupportedException(StatusNotSupportedException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.STATUS_NOT_SUPPORTED_ERROR.getMessageDefinition();
        org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException oe = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertStatusNotsupportedException((org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.StatusNotSupportedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotKnownError(String guid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.ENTITY_NOT_KNOWN_ERROR.getMessageDefinition();
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(messageDefinition, className, methodName, guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityProxyOnlyException(EntityProxyOnlyException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR.getMessageDefinition();
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleTypeErrorException(TypeErrorException e, String methodName, String serverName, String serviceName) {
        String propertyName = "typeName";
        String propertyValue = "unknown";
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.TYPEDEF_ERROR.getMessageDefinition(new String[]{propertyName, propertyValue});
        InvalidParameterException oe = new InvalidParameterException(messageDefinition, className, methodName, propertyName, propertyValue);
        return OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleFunctionNotSupportedException(org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.FUNCTION_NOT_SUPPORTED.getMessageDefinition();
        FunctionNotSupportedException oe = new FunctionNotSupportedException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertFunctionNotSupportedException((FunctionNotSupportedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handlePagingErrorException(PagingErrorException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.PAGING_ERROR.getMessageDefinition();
        PropertyServerException pse = new PropertyServerException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertPropertyServerException((PropertyServerException)pse);
    }

    public static SubjectAreaOMASAPIResponse handleRelationshipNotKnownException(String guid, String methodName, String serverName, String serviceName) {
        String propertyName = "guid";
        String propertyValue = guid;
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST.getMessageDefinition(new String[]{propertyName, propertyValue});
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(messageDefinition, className, methodName, guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotKnownException(String guid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_DOES_NOT_EXIST.getMessageDefinition();
        UnrecognizedGUIDException oe = new UnrecognizedGUIDException(messageDefinition, className, methodName, guid);
        return OMASExceptionToResponse.convertUnrecognizedGUIDException((UnrecognizedGUIDException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotDeletedException(String guid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR.getMessageDefinition(new String[]{guid});
        EntityNotDeletedException oe = new EntityNotDeletedException(messageDefinition, className, methodName, guid);
        return OMASExceptionToResponse.convertEntityNotDeletedException((EntityNotDeletedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRelationshipNotDeletedException(String guid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_NOT_DELETED_ERROR.getMessageDefinition(new String[]{guid});
        RelationshipNotDeletedException oe = new RelationshipNotDeletedException(messageDefinition, className, methodName, guid);
        return OMASExceptionToResponse.convertRelationshipNotDeletedException((RelationshipNotDeletedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleMetadataServerUnContactable(MetadataServerUncontactableException e, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR.getMessageDefinition();
        MetadataServerUncontactableException oe = new MetadataServerUncontactableException(messageDefinition, className, methodName);
        return OMASExceptionToResponse.convertMetadataServerUncontactableException((MetadataServerUncontactableException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleEntityNotPurgedException(String obsoleteGuid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR.getMessageDefinition();
        messageDefinition.setMessageParameters(new String[]{obsoleteGuid});
        EntityNotPurgedException oe = new EntityNotPurgedException(messageDefinition, className, methodName, obsoleteGuid);
        return OMASExceptionToResponse.convertEntityNotPurgedException((EntityNotPurgedException)oe);
    }

    public static SubjectAreaOMASAPIResponse handleRelationshipNotPurgedException(String obsoleteGuid, String methodName, String serverName, String serviceName) {
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GUID_NOT_PURGED_ERROR.getMessageDefinition(new String[]{obsoleteGuid});
        RelationshipNotPurgedException oe = new RelationshipNotPurgedException(messageDefinition, className, methodName, obsoleteGuid);
        return OMASExceptionToResponse.convertRelationshipNotPurgedException((RelationshipNotPurgedException)oe);
    }
}

