/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Isa;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISARelationshipMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(ISARelationshipMapper.class);
    private static final String className = ISARelationshipMapper.class.getName();
    public static final String ISA_RELATIONSHIP = "ISARelationship";

    public ISARelationshipMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        Isa iSARelationship = (Isa)line;
        if (iSARelationship.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, iSARelationship.getDescription(), "description");
        }
        if (iSARelationship.getExpression() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, iSARelationship.getExpression(), "expression");
        }
        if (iSARelationship.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, iSARelationship.getSteward(), "steward");
        }
        if (iSARelationship.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, iSARelationship.getSource(), "source");
        }
        if (iSARelationship.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(iSARelationship.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        Isa iSARelationship = (Isa)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            iSARelationship.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("expression")) {
            iSARelationship.setExpression(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            iSARelationship.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            iSARelationship.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToLine(Line line, String propertyName, EnumPropertyValue enumPropertyValue) {
        Isa iSARelationship = (Isa)line;
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            iSARelationship.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        Isa iSARelationship = (Isa)line;
        return iSARelationship.getTermGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        Isa iSARelationship = (Isa)line;
        return iSARelationship.getSpecialisedTermGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), ISA_RELATIONSHIP).getGUID();
    }

    @Override
    public String getTypeName() {
        return ISA_RELATIONSHIP;
    }

    @Override
    protected Line getLineInstance() {
        return new Isa();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        Isa isaRelationship = (Isa)line;
        isaRelationship.setTermGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        Isa isaRelationship = (Isa)line;
        isaRelationship.setSpecialisedTermGuid(guid);
    }
}

