/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectScopeMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(ProjectScopeMapper.class);
    private static final String className = ProjectScopeMapper.class.getName();
    public static final String PROJECT_SCOPE = "ProjectScope";

    public ProjectScopeMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected String getProxy1Guid(Line line) {
        ProjectScope projectScope = (ProjectScope)line;
        return projectScope.getProjectGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        ProjectScope projectScope = (ProjectScope)line;
        return projectScope.getNodeGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), PROJECT_SCOPE).getGUID();
    }

    @Override
    public String getTypeName() {
        return PROJECT_SCOPE;
    }

    @Override
    protected Line getLineInstance() {
        return new ProjectScope();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        ProjectScope ProjectScopeRelationship = (ProjectScope)line;
        ProjectScopeRelationship.setProjectGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        ProjectScope ProjectScopeRelationship = (ProjectScope)line;
        ProjectScopeRelationship.setNodeGuid(guid);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        ProjectScope projectScope = (ProjectScope)line;
        if (projectScope.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, projectScope.getDescription(), "description");
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        ProjectScope projectScope = (ProjectScope)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            projectScope.setDescription(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }
}

