/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsaTypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.LineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermISATypeOFRelationshipMapper
extends LineMapper {
    private static final Logger log = LoggerFactory.getLogger(TermISATypeOFRelationshipMapper.class);
    private static final String className = TermISATypeOFRelationshipMapper.class.getName();
    private static final String TERM_ISA_TYPE_OF_RELATIONSHIP = "TermISATypeOFRelationship";

    public TermISATypeOFRelationshipMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapLineToInstanceProperties(Line line, InstanceProperties instanceProperties) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        if (termISATypeOFRelationship.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termISATypeOFRelationship.getDescription(), "description");
        }
        if (termISATypeOFRelationship.getSteward() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termISATypeOFRelationship.getSteward(), "steward");
        }
        if (termISATypeOFRelationship.getSource() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termISATypeOFRelationship.getSource(), "source");
        }
        if (termISATypeOFRelationship.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(termISATypeOFRelationship.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToLine(Line line, String propertyName, Object value) {
        String stringValue = (String)value;
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            termISATypeOFRelationship.setDescription(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("steward")) {
            termISATypeOFRelationship.setSteward(stringValue);
            foundProperty = true;
        }
        if (propertyName.equals("source")) {
            termISATypeOFRelationship.setSource(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToLine(Line line, String propertyName, EnumPropertyValue enumPropertyValue) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            termISATypeOFRelationship.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected String getProxy1Guid(Line line) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        return termISATypeOFRelationship.getSuperTypeGuid();
    }

    @Override
    protected String getProxy2Guid(Line line) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        return termISATypeOFRelationship.getSubTypeGuid();
    }

    @Override
    protected String getRelationshipTypeDefGuid(Relationship relationship) {
        return this.repositoryHelper.getTypeDefByName(this.omrsapiHelper.getServiceName(), TERM_ISA_TYPE_OF_RELATIONSHIP).getGUID();
    }

    @Override
    public String getTypeName() {
        return TERM_ISA_TYPE_OF_RELATIONSHIP;
    }

    @Override
    protected Line getLineInstance() {
        return new IsaTypeOf();
    }

    @Override
    protected void setEnd1GuidInLine(Line line, String guid) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        termISATypeOFRelationship.setSuperTypeGuid(guid);
    }

    @Override
    protected void setEnd2GuidInLine(Line line, String guid) {
        IsaTypeOf termISATypeOFRelationship = (IsaTypeOf)line;
        termISATypeOFRelationship.setSubTypeGuid(guid);
    }
}

