/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaGraphHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaProjectHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ExceptionMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaProjectRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaProjectRESTServices.class);
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();

    public SubjectAreaOMASAPIResponse createProject(String serverName, String userId, Project suppliedProject) {
        String methodName = "createProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: createProject,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "createProject");
            response = handler.createProject(userId, suppliedProject);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : createProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectByGuid(String serverName, String userId, String guid) {
        String methodName = "getProjectByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getProjectByGuid,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "getProjectByGuid");
            response = handler.getProjectByGuid(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getProjectByGuid,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findProject(String serverName, String userId, String searchCriteria, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: findProject,userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "findProject");
            response = handler.findProject(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : findProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, methodName);
            response = handler.getProjectRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectTerms(String serverName, String userId, String guid, Date asOfTime) {
        String methodName = "getProjectTerms";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler projectHandler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, methodName);
            SubjectAreaGraphHandler graphHandler = instanceHandler.getSubjectAreaGraphHandler(userId, serverName, methodName);
            response = projectHandler.getProjectTerms(graphHandler, userId, guid, asOfTime);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse updateProject(String serverName, String userId, String guid, Project suppliedProject, boolean isReplace) {
        String methodName = "updateProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: updateProject,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "updateProject");
            response = handler.updateProject(userId, guid, suppliedProject, isReplace);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : updateProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteProject(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: deleteProject,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "deleteProject");
            response = handler.deleteProject(userId, guid, isPurge);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : deleteProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreProject(String serverName, String userId, String guid) {
        String methodName = "restoreProject";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: restoreProject,userId=" + userId + ",guid=" + guid);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            SubjectAreaProjectHandler handler = instanceHandler.getSubjectAreaProjectHandler(userId, serverName, "restoreProject");
            response = handler.restoreProject(userId, guid);
        }
        catch (OCFCheckedExceptionBase e) {
            response = ExceptionMapper.getResponseFromOCFCheckedExceptionBase(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : restoreProject,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

