/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.utilities;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.EntityDetailsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.GlossarySummaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.IconSummarySetResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.InstanceGraphResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.internalresponse.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.IconSummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.OMASExceptionToResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ResponseCategory;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.AntonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ISARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.PreferredTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.RelatedTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ReplacementTermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SemanticAssignmentMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.SynonymMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermCategorizationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermHASARelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermISATypeOFRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TermTYPEDBYRelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.TranslationMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.UsedInContextMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.ValidValueMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSAPIHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSAPIHelper.class);
    private static final String className = OMRSAPIHelper.class.getName();
    private final String serviceName;
    private final String serverName;
    private OMRSRepositoryHelper omrsRepositoryHelper;
    private OMRSMetadataCollection omrsMetadataCollection;

    public OMRSAPIHelper(String serviceName, String serverName, OMRSRepositoryHelper repositoryHelper, OMRSMetadataCollection omrsMetadataCollection) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.omrsRepositoryHelper = repositoryHelper;
        this.omrsMetadataCollection = omrsMetadataCollection;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public OMRSMetadataCollection getOMRSMetadataCollection(String restAPIName) throws MetadataServerUncontactableException {
        this.validateInitialization(restAPIName);
        return this.omrsMetadataCollection;
    }

    public OMRSRepositoryHelper getOMRSRepositoryHelper() {
        return this.omrsRepositoryHelper;
    }

    public void setOMRSRepositoryConnector(OMRSRepositoryConnector connector, String restAPIName) throws MetadataServerUncontactableException {
        String methodName = "setOMRSRepositoryConnector";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + "connector=" + connector);
        }
        try {
            this.omrsMetadataCollection = connector.getMetadataCollection();
            this.omrsRepositoryHelper = connector.getRepositoryHelper();
        }
        catch (RepositoryErrorException e) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.METADATA_SERVER_UNCONTACTABLE_ERROR.getMessageDefinition();
            throw new MetadataServerUncontactableException(messageDefinition, this.getClass().getName(), restAPIName, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
    }

    private void validateInitialization(String restAPIName) throws MetadataServerUncontactableException {
        if (this.omrsMetadataCollection == null && this.omrsRepositoryHelper == null) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED.getMessageDefinition();
            throw new MetadataServerUncontactableException(messageDefinition, this.getClass().getName(), restAPIName);
        }
    }

    public SubjectAreaOMASAPIResponse callOMRSAddEntity(String restAPIName, String userId, EntityDetail entityDetail) {
        String methodName = "callOMRSAddEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            EntityDetail addedEntityDetail = this.getOMRSMetadataCollection(restAPIName).addEntity(userId, entityDetail.getType().getTypeDefGUID(), instanceProperties, entityDetail.getClassifications(), InstanceStatus.ACTIVE);
            response = new EntityDetailResponse(addedEntityDetail);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSGetEntityByGuid(String restAPIName, String userId, String entityGUID) {
        String methodName = "callOMRSGetEntityByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail gotEntityDetail = this.getOMRSMetadataCollection(restAPIName).getEntityDetail(userId, entityGUID);
            response = new EntityDetailResponse(gotEntityDetail);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityProxyOnlyException e) {
            response = ErrorHandler.handleEntityProxyOnlyException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callFindEntitiesByPropertyValue(String restAPIName, String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callFindEntitiesByPropertyValue";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List foundEntities = this.getOMRSMetadataCollection(restAPIName).findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new EntityDetailsResponse(foundEntities);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetEntitiesByType(String restAPIName, String userId, String entityTypeGUID, Date asOfTime, int fromEntityElement, int pageSize, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder) {
        String methodName = "callGetEntitiesByType";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List foundEntities = this.getOMRSMetadataCollection(restAPIName).findEntitiesByProperty(userId, entityTypeGUID, null, null, fromEntityElement, null, null, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new EntityDetailsResponse(foundEntities);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSUpdateEntityProperties(String restAPIName, String userId, EntityDetail entityDetail) {
        String methodName = "callOMRSUpdateEntityProperties";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        EntityDetail updatedEntity = null;
        InstanceProperties instanceProperties = entityDetail.getProperties();
        try {
            updatedEntity = this.getOMRSMetadataCollection(restAPIName).updateEntityProperties(userId, entityDetail.getGUID(), instanceProperties);
            response = new EntityDetailResponse(updatedEntity);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityDetail.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeleteEntity(String restAPIName, String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) {
        String methodName = "callOMRSDeleteEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail deletedEntity = this.getOMRSMetadataCollection(restAPIName).deleteEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
            response = new EntityDetailResponse(deletedEntity);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSPurgeEntity(String restAPIName, String userId, String typeDefName, String typeDefGuid, String obsoleteGuid) {
        String methodName = "callOMRSPurgeEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            this.getOMRSMetadataCollection(restAPIName).purgeEntity(userId, typeDefGuid, typeDefName, obsoleteGuid);
            response = new VoidResponse();
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotDeletedException e) {
            response = ErrorHandler.handleEntityNotPurgedException(obsoleteGuid, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSRestoreEntity(String restAPIName, String userId, String guid) {
        String methodName = "callOMRSRestoreEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail restoredEntity = this.getOMRSMetadataCollection(restAPIName).restoreEntity(userId, guid);
            response = new EntityDetailResponse(restoredEntity);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotDeletedException e) {
            response = ErrorHandler.handleEntityNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSClassifyEntity(String restAPIName, String userId, String entityGUID, String classificationName, InstanceProperties instanceProperties) {
        String methodName = "callOMRSClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail entity = this.getOMRSMetadataCollection(restAPIName).classifyEntity(userId, entityGUID, classificationName, instanceProperties);
            response = new EntityDetailResponse(entity);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeClassifyEntity(String restAPIName, String userId, String entityGUID, String classificationName) {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            EntityDetail entity = this.getOMRSMetadataCollection(restAPIName).declassifyEntity(userId, entityGUID, classificationName);
            response = new EntityDetailResponse(entity);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (ClassificationErrorException e) {
            response = ErrorHandler.handleClassificationErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSAddRelationship(String restAPIName, String userId, Relationship relationship) {
        String methodName = "callOMRSDeClassifyEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Relationship addedRelationship = this.getOMRSMetadataCollection(restAPIName).addRelationship(userId, relationship.getType().getTypeDefGUID(), relationship.getProperties(), relationship.getEntityOneProxy().getGUID(), relationship.getEntityTwoProxy().getGUID(), InstanceStatus.ACTIVE);
            response = new RelationshipResponse(addedRelationship);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSGetRelationshipByGuid(String restAPIName, String userId, String relationshipGUID) {
        String methodName = "callOMRSGetRelationshipByGuid";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Relationship relationship = this.getOMRSMetadataCollection(restAPIName).getRelationship(userId, relationshipGUID);
            response = new RelationshipResponse(relationship);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(relationshipGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSUpdateRelationship(String restAPIName, String userId, Relationship relationship) {
        String methodName = "callOMRSUpdateRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        Relationship updatedRelationship = null;
        try {
            updatedRelationship = this.getOMRSMetadataCollection(restAPIName).updateRelationshipProperties(userId, relationship.getGUID(), relationship.getProperties());
            if (relationship.getStatus() != null && updatedRelationship != null && !relationship.getStatus().equals((Object)updatedRelationship.getStatus())) {
                updatedRelationship = this.getOMRSMetadataCollection(restAPIName).updateRelationshipStatus(userId, relationship.getGUID(), relationship.getStatus());
            }
            response = new RelationshipResponse(updatedRelationship);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(relationship.getGUID(), restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (StatusNotSupportedException e) {
            response = ErrorHandler.handleStatusNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSDeleteRelationship(String restAPIName, String userId, String typeGuid, String typeName, String guid) {
        String methodName = "callOMRSDeleteRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            Relationship deletedRelationship = this.getOMRSMetadataCollection(restAPIName).deleteRelationship(userId, typeGuid, typeName, guid);
            response = new RelationshipResponse(deletedRelationship);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSRestoreRelationship(String restAPIName, String userId, String guid) {
        String methodName = "callOMRSRestoreRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        Relationship restoredRelationship = null;
        try {
            restoredRelationship = this.getOMRSMetadataCollection(restAPIName).restoreRelationship(userId, guid);
            response = new RelationshipResponse(restoredRelationship);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            response = ErrorHandler.handleRelationshipNotDeletedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callOMRSPurgeRelationship(String restAPIName, String userId, String typeGuid, String typeName, String guid) {
        String methodName = "callOMRSPurgeRelationship";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            this.getOMRSMetadataCollection(restAPIName).purgeRelationship(userId, typeGuid, typeName, guid);
            response = new VoidResponse();
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotKnownException e) {
            response = ErrorHandler.handleRelationshipNotKnownException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (RelationshipNotDeletedException e) {
            response = ErrorHandler.handleRelationshipNotPurgedException(guid, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetRelationshipsForEntity(String restAPIName, String userId, String entityGUID, String relationshipTypeGuid, int fromRelationshipElement, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        ArrayList<InstanceStatus> statusList = new ArrayList<InstanceStatus>();
        statusList.add(InstanceStatus.ACTIVE);
        List relationships = null;
        try {
            relationships = this.getOMRSMetadataCollection(restAPIName).getRelationshipsForEntity(userId, entityGUID, relationshipTypeGuid, fromRelationshipElement, statusList, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new RelationshipsResponse(relationships);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetRelationshipsForEntity(String restAPIName, String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder sequencingOrder, int pageSize) {
        String methodName = "callGetRelationshipsForEntity";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            List relationships = this.getOMRSMetadataCollection(restAPIName).getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response = new RelationshipsResponse(relationships);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PagingErrorException e) {
            response = ErrorHandler.handlePagingErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== Method: " + methodName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse callGetEntityNeighbourhood(String restAPIName, String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) {
        String methodName = "callgetEntityNeighborhood";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName);
        }
        SubjectAreaOMASAPIResponse response = null;
        try {
            InstanceGraph instanceGraph = this.getOMRSMetadataCollection(restAPIName).getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
            return new InstanceGraphResponse(instanceGraph);
        }
        catch (UserNotAuthorizedException e) {
            response = ErrorHandler.handleUnauthorizedUser(userId, restAPIName, this.serverName, this.serviceName);
        }
        catch (MetadataServerUncontactableException e) {
            response = ErrorHandler.handleMetadataServerUnContactable(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (RepositoryErrorException e) {
            String method_not_implemented_msg_id = OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition().getMessageId();
            if (!e.getReportedErrorMessage().startsWith(method_not_implemented_msg_id)) {
                response = ErrorHandler.handleRepositoryError(e, restAPIName, this.serverName, this.serviceName);
            }
        }
        catch (TypeErrorException e) {
            response = ErrorHandler.handleTypeErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (EntityNotKnownException e) {
            response = ErrorHandler.handleEntityNotKnownError(entityGUID, restAPIName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException e) {
            response = ErrorHandler.handleInvalidParameterException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (PropertyErrorException e) {
            response = ErrorHandler.handlePropertyErrorException(e, restAPIName, this.serverName, this.serviceName);
        }
        catch (FunctionNotSupportedException e) {
            response = ErrorHandler.handleFunctionNotSupportedException(e, restAPIName, this.serverName, this.serviceName);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse findEntitiesByPropertyValue(String restAPIName, String userId, String typeName, String searchCriteria, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        ExceptionMessageDefinition messageDefinition;
        SubjectAreaErrorCode errorCode;
        String propertyValue;
        String propertyName;
        SubjectAreaOMASAPIResponse response = null;
        if (sequencingProperty != null) {
            try {
                sequencingProperty = URLDecoder.decode(sequencingProperty, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                propertyName = "sequencingProperty";
                propertyValue = sequencingProperty;
                errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
                messageDefinition = errorCode.getMessageDefinition(new String[]{propertyName, propertyValue});
                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)new InvalidParameterException(messageDefinition, className, restAPIName, propertyName, propertyValue));
            }
        }
        if (response == null && searchCriteria != null) {
            try {
                searchCriteria = URLDecoder.decode(searchCriteria, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                propertyName = "searchCriteria";
                propertyValue = searchCriteria;
                errorCode = SubjectAreaErrorCode.ERROR_ENCODING_QUERY_PARAMETER;
                messageDefinition = errorCode.getMessageDefinition(new String[]{propertyName, propertyValue});
                response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)new InvalidParameterException(messageDefinition, className, restAPIName, propertyName, propertyValue));
            }
        }
        if (response == null) {
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
            TypeDef typeDef = this.omrsRepositoryHelper.getTypeDefByName("findEntitiesByPropertyValue", typeName);
            String entityTypeGUID = typeDef.getGUID();
            response = this.callFindEntitiesByPropertyValue(restAPIName, userId, entityTypeGUID, searchCriteria, offset, null, null, asOfTime, sequencingProperty, omrsSequencingOrder, pageSize);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse getEntitiesByType(String restAPIName, String userId, String typeName, Date asOfTime, int offset, int pageSize, String sequencingProperty, SequencingOrder sequencingOrder) {
        TypeDef typeDef = this.omrsRepositoryHelper.getTypeDefByName("getEntitiesByType", typeName);
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder omrsSequencingOrder = SubjectAreaUtils.convertOMASToOMRSSequencingOrder(sequencingOrder);
        String entityTypeGUID = typeDef.getGUID();
        return this.callGetEntitiesByType(restAPIName, userId, entityTypeGUID, asOfTime, offset, pageSize, sequencingProperty, omrsSequencingOrder);
    }

    public SubjectAreaOMASAPIResponse getIconSummarySet(String userId, String guid) {
        HashSet<IconSummary> icons = new HashSet<IconSummary>();
        IconSummarySetResponse response = new IconSummarySetResponse(icons);
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossarySummary(String restAPIName, String userId, Line line) {
        String glossaryGuid = SubjectAreaUtils.getGlossaryGuidFromAnchor(line);
        SubjectAreaOMASAPIResponse response = this.callOMRSGetEntityByGuid(restAPIName, userId, glossaryGuid);
        if (response.getResponseCategory().equals((Object)ResponseCategory.OmrsEntityDetail)) {
            EntityDetailResponse entityDetailResponse = (EntityDetailResponse)response;
            EntityDetail glossaryEntity = entityDetailResponse.getEntityDetail();
            Glossary glossary = null;
            try {
                glossary = new GlossaryMapper(this).mapEntityDetailToNode(glossaryEntity);
                GlossarySummary glossarySummary = SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, line);
                if (glossarySummary != null) {
                    response = new GlossarySummaryResponse(glossarySummary);
                }
            }
            catch (InvalidParameterException e) {
                response = OMASExceptionToResponse.convertInvalidParameterException((InvalidParameterException)e);
            }
        }
        return response;
    }

    public CategorySummary getParentCategorySummary(String restAPIName, String userId, Set<Line> lines) throws InvalidParameterException {
        CategorySummary parentCategorySummary = null;
        SubjectAreaOMASAPIResponse response = null;
        Iterator<Line> iterator = lines.iterator();
        while (iterator.hasNext() && parentCategorySummary == null) {
            CategoryHierarchyLink parentRelationship = (CategoryHierarchyLink)iterator.next();
            String parentCategoryGuid = parentRelationship.getSuperCategoryGuid();
            response = this.callOMRSGetEntityByGuid(restAPIName, userId, parentCategoryGuid);
            if (response.getResponseCategory() != ResponseCategory.OmrsEntityDetail) continue;
            EntityDetailResponse parentCategoryEntityResponse = (EntityDetailResponse)response;
            EntityDetail parentCategoryEntity = parentCategoryEntityResponse.getEntityDetail();
            Category category = new CategoryMapper(this).mapEntityDetailToNode(parentCategoryEntity);
            parentCategorySummary = SubjectAreaUtils.extractCategorySummaryFromCategory(category, (Line)parentRelationship);
        }
        return parentCategorySummary;
    }

    public SubjectAreaOMASAPIResponse convertOMRSRelationshipsToOMASLines(List<Relationship> omrsRelationships) {
        ArrayList<Line> omasLines = new ArrayList<Line>();
        for (Relationship omrsRelationship : omrsRelationships) {
            String omrsName = omrsRelationship.getType().getTypeDefName();
            Line omasLine = null;
            switch (omrsName) {
                case "TermHASARelationship": {
                    omasLine = new TermHASARelationshipMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "RelatedTerm": {
                    omasLine = new RelatedTermMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Synonym": {
                    omasLine = new SynonymMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Antonym": {
                    omasLine = new AntonymMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "Translation": {
                    omasLine = new TranslationMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ISARelationship": {
                    omasLine = new ISARelationshipMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "PreferredTerm": {
                    omasLine = new PreferredTermMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermISATypeOFRelationship": {
                    omasLine = new TermISATypeOFRelationshipMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ReplacementTerm": {
                    omasLine = new ReplacementTermMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermTYPEDBYRelationship": {
                    omasLine = new TermTYPEDBYRelationshipMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "UsedInContext": {
                    omasLine = new UsedInContextMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "ValidValue": {
                    omasLine = new ValidValueMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "LibraryCategoryReferenceRelationshipRelationship": {
                    break;
                }
                case "LibraryTermReferenceRelationshipRelationship": {
                    break;
                }
                case "SemanticAssignment": {
                    omasLine = new SemanticAssignmentMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermCategorization": {
                    omasLine = new TermCategorizationMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "TermAnchor": {
                    omasLine = new TermAnchorMapper(this).mapRelationshipToLine(omrsRelationship);
                    break;
                }
                case "CategoryAnchor": {
                    omasLine = new CategoryAnchorMapper(this).mapRelationshipToLine(omrsRelationship);
                }
            }
            if (omasLine == null) continue;
            omasLines.add(omasLine);
        }
        return new LinesResponse(omasLines);
    }
}

