/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.OmasObject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.ILineMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.Mapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.MappersFactory;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public abstract class SubjectAreaHandler {
    private static final String className = SubjectAreaHandler.class.getName();
    protected static final String GLOSSARY_TYPE_NAME = "Glossary";
    protected static final String CATEGORY_TYPE_NAME = "GlossaryCategory";
    protected static final String TERM_TYPE_NAME = "GlossaryTerm";
    protected static final String PROJECT_TYPE_NAME = "Project";
    protected static final String TERM_ANCHOR_RELATIONSHIP_NAME = "TermAnchor";
    protected static final String PROJECT_SCOPE_RELATIONSHIP_NAME = "ProjectScope";
    protected static final String CATEGORY_ANCHOR_RELATIONSHIP_NAME = "CategoryAnchor";
    protected static final String CATEGORY_HIERARCHY_LINK_RELATIONSHIP_NAME = "CategoryHierarchyLink";
    protected final MappersFactory mappersFactory;
    protected final OMRSAPIHelper oMRSAPIHelper;

    public SubjectAreaHandler(OMRSAPIHelper oMRSAPIHelper) {
        this.oMRSAPIHelper = oMRSAPIHelper;
        this.mappersFactory = new MappersFactory(oMRSAPIHelper);
    }

    GlossarySummary getGlossarySummary(String restAPIName, String userId, Line line) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        String guid = SubjectAreaUtils.getGlossaryGuidFromAnchor(line);
        Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, GLOSSARY_TYPE_NAME, restAPIName);
        if (entityDetail.isPresent()) {
            GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
            Glossary glossary = glossaryMapper.map(entityDetail.get());
            return SubjectAreaUtils.extractGlossarySummaryFromGlossary(glossary, line);
        }
        return null;
    }

    protected <T extends Node> List<T> findEntities(String userId, String typeEntityName, FindRequest findRequest, Class<? extends INodeMapper<T>> mapperClass, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> entityDetails = null;
        ArrayList<T> foundEntities = null;
        entityDetails = findRequest.getSearchCriteria() == null ? this.oMRSAPIHelper.getEntitiesByType(methodName, userId, typeEntityName, findRequest) : this.oMRSAPIHelper.findEntitiesByPropertyValue(methodName, userId, typeEntityName, findRequest);
        if (entityDetails != null) {
            INodeMapper<T> iNodeMapper = this.mappersFactory.get(mapperClass);
            foundEntities = new ArrayList<T>();
            for (EntityDetail entityDetail : entityDetails) {
                foundEntities.add(iNodeMapper.map(entityDetail));
            }
        }
        return foundEntities;
    }

    public SubjectAreaOMASAPIResponse<Line> getAllRelationshipsForEntity(String methodName, String userId, String guid, FindRequest findRequest) {
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            response.addAllResults(this.getAllLineForEntity(methodName, userId, guid, findRequest));
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public List<Line> getAllLineForEntity(String restAPIName, String userId, String entityGuid, FindRequest findRequest) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.oMRSAPIHelper.getAllRelationshipsForEntity(restAPIName, userId, entityGuid, findRequest);
        return this.getLinesFromRelationships(relationships);
    }

    public List<Line> getLinesFromRelationships(Collection<Relationship> relationships) {
        return this.convertOrmsToOmas(relationships, ILineMapper.class);
    }

    public List<Node> getNodesFromEntityDetails(Collection<EntityDetail> entityDetails) {
        return this.convertOrmsToOmas(entityDetails, INodeMapper.class);
    }

    public <R extends InstanceHeader, T extends OmasObject> List<T> convertOrmsToOmas(Collection<R> list, Class<? extends Mapper> mapperInterface) {
        ArrayList result = new ArrayList();
        if (list != null) {
            HashMap<String, Mapper> cache = new HashMap<String, Mapper>();
            for (InstanceHeader entityDetail : list) {
                String typeDefName = entityDetail.getType().getTypeDefName();
                if (cache.containsKey(typeDefName)) {
                    Mapper mapper = (Mapper)cache.get(typeDefName);
                    result.add(mapper.map(entityDetail));
                    continue;
                }
                Set<Class<?>> allMapperClasses = this.mappersFactory.getAllMapperClasses();
                for (Class<?> mapperClass : allMapperClasses) {
                    Mapper mapper;
                    if (!mapperInterface.isAssignableFrom(mapperClass) || !(mapper = mapperInterface.cast(this.mappersFactory.get(mapperClass))).getTypeName().equals(typeDefName)) continue;
                    cache.put(typeDefName, mapper);
                    result.add(mapper.map(entityDetail));
                }
            }
        }
        return result;
    }

    protected String validateGlossarySummaryDuringCreation(String userId, String methodName, GlossarySummary suppliedGlossary) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, SubjectAreaCheckedException {
        if (suppliedGlossary != null) {
            String guid = suppliedGlossary.getGuid();
            String relationshipGuid = suppliedGlossary.getRelationshipguid();
            if (relationshipGuid != null) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITH_GLOSSARY_RELATIONSHIP.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
            }
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, GLOSSARY_TYPE_NAME, methodName);
            if (entityDetail.isPresent()) {
                return entityDetail.get().getGUID();
            }
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
            throw new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
        }
        ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.CREATE_WITHOUT_GLOSSARY.getMessageDefinition();
        throw new InvalidParameterException(messageDefinition, className, methodName, "glossary", null);
    }
}

