/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SystemAttributes;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.INodeMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.classifications.ClassificationFactory;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchiveAccessor;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class EntityDetailMapper<N extends Node>
implements INodeMapper<N> {
    protected final OMRSRepositoryHelper repositoryHelper;
    protected final OMRSAPIHelper omrsapiHelper;

    public EntityDetailMapper(OMRSAPIHelper omrsapiHelper) {
        this.omrsapiHelper = omrsapiHelper;
        this.repositoryHelper = omrsapiHelper.getOMRSRepositoryHelper();
    }

    protected void mapEntityDetailToNode(N node, EntityDetail omrsEntityDetail) {
        node.setSystemAttributes(SubjectAreaUtils.createSystemAttributes((InstanceHeader)omrsEntityDetail));
        InstanceProperties omrsEntityDetailProperties = omrsEntityDetail.getProperties();
        if (omrsEntityDetailProperties != null) {
            this.mapEntityDetailPropertiesToNode(node, omrsEntityDetailProperties);
        }
        this.mapOmrsClassificationsToNode(omrsEntityDetail, node);
    }

    private void mapEntityDetailPropertiesToNode(N node, InstanceProperties omrsEntityDetailProperties) {
        node.setEffectiveFromTime(omrsEntityDetailProperties.getEffectiveFromTime());
        node.setEffectiveToTime(omrsEntityDetailProperties.getEffectiveToTime());
        Iterator omrsPropertyIterator = omrsEntityDetailProperties.getPropertyNames();
        NodeType nodeType = node.getNodeType();
        while (omrsPropertyIterator.hasNext()) {
            String propertyName = (String)omrsPropertyIterator.next();
            InstancePropertyValue value = omrsEntityDetailProperties.getPropertyValue(propertyName);
            switch (value.getInstancePropertyCategory()) {
                case PRIMITIVE: {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)value;
                    Object actualValue = primitivePropertyValue.getPrimitiveValue();
                    if (propertyName.equals("qualifiedName")) {
                        if (actualValue == null) break;
                        node.setQualifiedName((String)actualValue);
                        break;
                    }
                    if (propertyName.equals("displayName") || propertyName.equals("name")) {
                        if (actualValue == null) break;
                        node.setName((String)actualValue);
                        break;
                    }
                    if (propertyName.equals("description")) {
                        if (actualValue == null) break;
                        node.setDescription((String)actualValue);
                        break;
                    }
                    if (propertyName.equals("scope") && (nodeType == NodeType.Taxonomy || nodeType == NodeType.TaxonomyAndCanonicalGlossary)) {
                        if (actualValue == null) break;
                        node.setDescription((String)actualValue);
                        break;
                    }
                    if (propertyName.equals("organisingPrinciple") && (nodeType == NodeType.CanonicalGlossary || nodeType == NodeType.TaxonomyAndCanonicalGlossary)) {
                        if (actualValue == null) break;
                        node.setDescription((String)actualValue);
                        break;
                    }
                    if (this.mapPrimitiveToNode(node, propertyName, actualValue)) break;
                    if (null == node.getAdditionalProperties()) {
                        node.setAdditionalProperties(new HashMap());
                    }
                    node.getAdditionalProperties().put(propertyName, (String)actualValue);
                    break;
                }
                case ENUM: {
                    EnumPropertyValue enumPropertyValue = (EnumPropertyValue)value;
                    if (this.mapEnumToNode(node, propertyName, enumPropertyValue)) break;
                    if (null == node.getAdditionalProperties()) {
                        node.setAdditionalProperties(new HashMap());
                    }
                    node.getAdditionalProperties().put(propertyName, enumPropertyValue.valueAsString());
                    break;
                }
                case MAP: {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)value;
                    InstanceProperties instancePropertyForMap = mapPropertyValue.getMapValues();
                    if (propertyName.equals("additionalProperties")) {
                        HashMap<String, String> actualMap = new HashMap<String, String>();
                        Iterator iter = instancePropertyForMap.getPropertyNames();
                        while (iter.hasNext()) {
                            String mapkey = (String)iter.next();
                            PrimitivePropertyValue primitivePropertyMapValue = (PrimitivePropertyValue)instancePropertyForMap.getPropertyValue(mapkey);
                            String mapvalue = primitivePropertyMapValue.getPrimitiveValue().toString();
                            actualMap.put(mapkey, mapvalue);
                        }
                        node.setAdditionalProperties(actualMap);
                    }
                    if (this.mapMapToNode(node, propertyName, instancePropertyForMap)) break;
                    if (null == node.getAdditionalProperties()) {
                        node.setAdditionalProperties(new HashMap());
                    }
                    node.getAdditionalProperties().put(propertyName, mapPropertyValue.valueAsString());
                    break;
                }
            }
        }
    }

    protected boolean mapPrimitiveToNode(N node, String propertyName, Object value) {
        return false;
    }

    protected boolean mapEnumToNode(N node, String propertyName, EnumPropertyValue enumPropertyValue) {
        return false;
    }

    protected boolean mapMapToNode(N node, String propertyName, InstanceProperties instancePropertyForMap) {
        return false;
    }

    private void mapNodeEffectivityToInstanceProperties(N node, InstanceProperties instanceProperties) {
        instanceProperties.setEffectiveFromTime(node.getEffectiveFromTime());
        instanceProperties.setEffectiveToTime(node.getEffectiveToTime());
    }

    private void mapOmrsClassificationsToNode(EntityDetail omrsEntityDetail, N node) {
        List omrsclassifications = omrsEntityDetail.getClassifications();
        if (CollectionUtils.isNotEmpty((Collection)omrsclassifications)) {
            ClassificationFactory classficationFactory = new ClassificationFactory(this.omrsapiHelper);
            ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> existingClassifications = node.getClassifications();
            if (existingClassifications == null) {
                existingClassifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
            }
            for (Classification omrsClassification : omrsclassifications) {
                String omrsClassificationName = omrsClassification.getName();
                org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification = classficationFactory.getOMASClassification(omrsClassificationName, omrsClassification);
                if (omasClassification == null) continue;
                this.updateNodeWithClassification(node, omasClassification);
                existingClassifications.add(omasClassification);
            }
            node.setClassifications(existingClassifications);
        }
    }

    abstract boolean updateNodeWithClassification(N var1, org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification var2);

    private void populateOmrsEntityWithBeanClassifications(EntityDetail entityDetail, List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> omasClassifications) {
        if (omasClassifications != null && omasClassifications.size() > 0) {
            ArrayList<Classification> omrsClassifications = new ArrayList<Classification>();
            for (org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification : omasClassifications) {
                ClassificationFactory classificationFactory = new ClassificationFactory(this.omrsapiHelper);
                Classification omrsClassification = classificationFactory.getOMRSClassification(omasClassification);
                omrsClassifications.add(omrsClassification);
            }
            entityDetail.setClassifications(omrsClassifications);
        }
    }

    public EntityDetail toEntityDetail(N node) {
        String methodName = "mapNodeToEntityDetail";
        EntityDetail omrsEntityDetail = new EntityDetail();
        SystemAttributes systemAttributes = node.getSystemAttributes();
        if (systemAttributes != null) {
            if (systemAttributes.getCreatedBy() != null) {
                omrsEntityDetail.setCreatedBy(systemAttributes.getCreatedBy());
            }
            if (systemAttributes.getUpdatedBy() != null) {
                omrsEntityDetail.setUpdatedBy(systemAttributes.getUpdatedBy());
            }
            if (systemAttributes.getCreateTime() != null) {
                omrsEntityDetail.setCreateTime(systemAttributes.getCreateTime());
            }
            if (systemAttributes.getUpdateTime() != null) {
                omrsEntityDetail.setUpdateTime(systemAttributes.getUpdateTime());
            }
            if (systemAttributes.getVersion() != null) {
                omrsEntityDetail.setVersion(systemAttributes.getVersion().longValue());
            }
            if (systemAttributes.getGUID() != null) {
                omrsEntityDetail.setGUID(systemAttributes.getGUID());
            }
            if (systemAttributes.getStatus() != null) {
                InstanceStatus instanceStatus = SubjectAreaUtils.convertStatusToInstanceStatus(systemAttributes.getStatus());
                omrsEntityDetail.setStatus(instanceStatus);
            }
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        this.mapNodeEffectivityToInstanceProperties(node, instanceProperties);
        if (node.getQualifiedName() != null) {
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "qualifiedName", node.getQualifiedName(), methodName);
        }
        if (node.getName() != null) {
            if (node.getNodeType() == NodeType.Project || node.getNodeType() == NodeType.GlossaryProject) {
                SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "name");
                this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "name", node.getName(), methodName);
            } else {
                SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "displayName");
                this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "displayName", node.getName(), methodName);
            }
        }
        if (node.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getDescription(), "description");
            this.repositoryHelper.addStringPropertyToInstance(this.omrsapiHelper.getServiceName(), instanceProperties, "description", node.getDescription(), methodName);
        }
        if (node.getAdditionalProperties() != null) {
            this.populateAdditionalProperties(node, instanceProperties);
        }
        this.mapNodeToInstanceProperties(node, instanceProperties);
        omrsEntityDetail.setProperties(instanceProperties);
        OpenMetadataTypesArchiveAccessor archiveAccessor = OpenMetadataTypesArchiveAccessor.getInstance();
        String typeName = this.getTypeName();
        EntityDef typeDef = archiveAccessor.getEntityDefByName(typeName);
        InstanceType template = SubjectAreaUtils.createTemplateFromTypeDef((TypeDef)typeDef);
        InstanceType instanceType = new InstanceType(template);
        omrsEntityDetail.setType(instanceType);
        List omasClassifications = node.getClassifications();
        List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> inlinedOmasClassifications = this.getInlinedClassifications(node);
        omasClassifications.addAll(inlinedOmasClassifications);
        if (!omasClassifications.isEmpty()) {
            this.populateOmrsEntityWithBeanClassifications(omrsEntityDetail, omasClassifications);
        }
        return omrsEntityDetail;
    }

    @Override
    public abstract String getTypeName();

    @Override
    public String getTypeDefGuid() {
        return this.omrsapiHelper.getTypeDefGUID(this.getTypeName());
    }

    protected void populateAdditionalProperties(N node, InstanceProperties instanceProperties) {
        Map map = node.getAdditionalProperties();
        MapPropertyValue mapPropertyValue = new MapPropertyValue();
        for (String key : map.keySet()) {
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue(map.get(key));
            mapPropertyValue.setMapValue(key, (InstancePropertyValue)primitivePropertyValue);
        }
        instanceProperties.setProperty("additionalProperties", (InstancePropertyValue)mapPropertyValue);
    }

    abstract List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> getInlinedClassifications(N var1);

    protected void mapNodeToInstanceProperties(N node, InstanceProperties instanceProperties) {
    }
}

