/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.EntityNotDeletedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaCategoryHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.GlossaryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

public class SubjectAreaGlossaryHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaGlossaryHandler.class.getName();

    public SubjectAreaGlossaryHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            String suppliedGlossaryName = suppliedGlossary.getName();
            if (suppliedGlossaryName == null || suppliedGlossaryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(messageDefinition, className, "createGlossary", "name");
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedGlossary);
            GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
            EntityDetail glossaryEntityDetail = glossaryMapper.map(suppliedGlossary);
            InstanceProperties instanceProperties = glossaryEntityDetail.getProperties();
            if (instanceProperties == null) {
                instanceProperties = new InstanceProperties();
            }
            if (instanceProperties.getEffectiveFromTime() == null) {
                instanceProperties.setEffectiveFromTime(new Date());
                glossaryEntityDetail.setProperties(instanceProperties);
            }
            String entityDetailGuid = this.oMRSAPIHelper.callOMRSAddEntity("createGlossary", userId, glossaryEntityDetail);
            response = this.getGlossaryByGuid(userId, entityDetailGuid);
        }
        catch (SubjectAreaCheckedException | org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossaryByGuid(String userId, String guid) {
        String methodName = "getGlossaryByGuid";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            InputValidator.validateGUIDNotNull((String)className, (String)"getGlossaryByGuid", (String)guid, (String)"guid");
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "Glossary", "getGlossaryByGuid");
            entityDetail.ifPresent(entity -> {
                GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
                response.addResult((Object)glossaryMapper.map((EntityDetail)entity));
            });
        }
        catch (SubjectAreaCheckedException | org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String userId, FindRequest findRequest) {
        String methodName = "findGlossary";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundGlossaries = this.findEntities(userId, "Glossary", findRequest, GlossaryMapper.class, "findGlossary");
            if (foundGlossaries == null) {
                return response;
            }
            response.addAllResults(foundGlossaries);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(String userId, String guid, FindRequest findRequest) {
        String methodName = "getGlossaryRelationships";
        return this.getAllRelationshipsForEntity(methodName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String userId, String guid, Glossary suppliedGlossary, boolean isReplace) {
        String methodName = "updateGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateGlossary", suppliedGlossary.getNodeType(), NodeType.Glossary, NodeType.Taxonomy, NodeType.TaxonomyAndCanonicalGlossary, NodeType.CanonicalGlossary});
            response = this.getGlossaryByGuid(userId, guid);
            if (response.head().isPresent()) {
                Glossary currentGlossary = (Glossary)response.head().get();
                this.checkReadOnly("updateGlossary", (Node)currentGlossary, "update");
                if (isReplace) {
                    this.replaceAttributes(currentGlossary, suppliedGlossary);
                } else {
                    this.updateAttributes(currentGlossary, suppliedGlossary);
                }
                Long glossaryFromTime = suppliedGlossary.getEffectiveFromTime();
                Long glossaryToTime = suppliedGlossary.getEffectiveToTime();
                currentGlossary.setEffectiveFromTime(glossaryFromTime);
                currentGlossary.setEffectiveToTime(glossaryToTime);
                GlossaryMapper glossaryMapper = this.mappersFactory.get(GlossaryMapper.class);
                EntityDetail entityDetail = glossaryMapper.map(currentGlossary);
                String glossaryGuid = entityDetail.getGUID();
                this.oMRSAPIHelper.callOMRSUpdateEntity("updateGlossary", userId, entityDetail);
                response = this.getGlossaryByGuid(userId, glossaryGuid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void replaceAttributes(Glossary currentGlossary, Glossary newGlossary) {
        currentGlossary.setName(newGlossary.getName());
        currentGlossary.setQualifiedName(newGlossary.getQualifiedName());
        currentGlossary.setDescription(newGlossary.getDescription());
        currentGlossary.setUsage(newGlossary.getUsage());
        currentGlossary.setAdditionalProperties(newGlossary.getAdditionalProperties());
    }

    private void updateAttributes(Glossary oldGlossary, Glossary newGlossary) {
        if (newGlossary.getName() != null) {
            oldGlossary.setName(newGlossary.getName());
        }
        if (newGlossary.getQualifiedName() != null) {
            oldGlossary.setQualifiedName(newGlossary.getQualifiedName());
        }
        if (newGlossary.getDescription() != null) {
            oldGlossary.setDescription(newGlossary.getDescription());
        }
        if (newGlossary.getUsage() != null) {
            oldGlossary.setUsage(newGlossary.getUsage());
        }
        if (newGlossary.getAdditionalProperties() != null) {
            oldGlossary.setAdditionalProperties(newGlossary.getAdditionalProperties());
        }
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String userId, String guid, Boolean isPurge) {
        SubjectAreaOMASAPIResponse<Glossary> response;
        block5: {
            String methodName = "deleteGlossary";
            response = new SubjectAreaOMASAPIResponse<Glossary>();
            try {
                List<String> relationshipTypeNames;
                if (isPurge.booleanValue()) {
                    this.oMRSAPIHelper.callOMRSPurgeEntity("deleteGlossary", userId, "Glossary", guid);
                    break block5;
                }
                response = this.getGlossaryByGuid(userId, guid);
                Glossary currentGlossary = (Glossary)response.head().get();
                if (response.head().isPresent()) {
                    this.checkReadOnly("deleteGlossary", (Node)currentGlossary, "delete");
                }
                if (this.oMRSAPIHelper.isEmptyContent(relationshipTypeNames = Arrays.asList("TermAnchor", "CategoryAnchor"), userId, guid, "Glossary", "deleteGlossary")) {
                    this.oMRSAPIHelper.callOMRSDeleteEntity("deleteGlossary", userId, "Glossary", guid);
                    break block5;
                }
                throw new EntityNotDeletedException(SubjectAreaErrorCode.GLOSSARY_CONTENT_PREVENTED_DELETE.getMessageDefinition(new String[]{guid}), className, "deleteGlossary", guid);
            }
            catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
                response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String userId, String guid) {
        String methodName = "restoreGlossary";
        SubjectAreaOMASAPIResponse<Glossary> response = new SubjectAreaOMASAPIResponse<Glossary>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreGlossary", userId, guid);
            response = this.getGlossaryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTerms(String userId, String guid, FindRequest findRequest) {
        String methodName = "getTerms";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        Integer pageSize = findRequest.getPageSize();
        Integer requestedStartingFrom = findRequest.getStartingFrom();
        String searchCriteria = findRequest.getSearchCriteria();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (requestedStartingFrom == null) {
            requestedStartingFrom = 0;
        }
        boolean isAll = searchCriteria == null || searchCriteria.equals("") || searchCriteria.equals(".*");
        SubjectAreaOMASAPIResponse<Glossary> thisGlossaryResponse = this.getGlossaryByGuid(userId, guid);
        if (thisGlossaryResponse.getRelatedHTTPCode() == 200) {
            if (isAll) {
                response = this.getRelatedNodesForEnd1("getTerms", userId, guid, "TermAnchor", TermMapper.class, requestedStartingFrom, pageSize);
            } else {
                int startingFrom = 0;
                ArrayList<Term> filteredTermsList = new ArrayList<Term>();
                boolean continueGettingTerms = true;
                while (continueGettingTerms) {
                    SubjectAreaOMASAPIResponse relatedTermsResponse = this.getRelatedNodesForEnd1("getTerms", userId, guid, "TermAnchor", TermMapper.class, startingFrom, pageSize);
                    if (relatedTermsResponse.results() != null && relatedTermsResponse.results().size() > 0) {
                        for (Term relatedTerm : relatedTermsResponse.results()) {
                            if (filteredTermsList.size() >= pageSize || !this.termMatchSearchCriteria(relatedTerm, searchCriteria)) continue;
                            filteredTermsList.add(relatedTerm);
                        }
                    }
                    if (relatedTermsResponse.results().size() < pageSize || filteredTermsList.size() == pageSize.intValue()) {
                        continueGettingTerms = false;
                        continue;
                    }
                    startingFrom += pageSize.intValue();
                }
                if (filteredTermsList.size() >= requestedStartingFrom) {
                    int endOffset = requestedStartingFrom + pageSize;
                    if (filteredTermsList.size() < requestedStartingFrom + pageSize) {
                        endOffset = filteredTermsList.size();
                    }
                    List filteredPagedTermsList = filteredTermsList.subList(requestedStartingFrom, endOffset);
                    response.addAllResults(filteredPagedTermsList);
                }
            }
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategories(String userId, String guid, FindRequest findRequest, Boolean onlyTop, SubjectAreaCategoryHandler categoryHandler) {
        String methodName = "getCategories";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        Integer pageSize = findRequest.getPageSize();
        Integer requestedStartingFrom = findRequest.getStartingFrom();
        String searchCriteria = findRequest.getSearchCriteria();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (requestedStartingFrom == null) {
            requestedStartingFrom = 0;
        }
        boolean isAll = searchCriteria == null || searchCriteria.equals("") || searchCriteria.equals(".*");
        SubjectAreaOMASAPIResponse<Glossary> thisGlossaryResponse = this.getGlossaryByGuid(userId, guid);
        if (thisGlossaryResponse.getRelatedHTTPCode() == 200) {
            if (isAll && !onlyTop.booleanValue()) {
                SubjectAreaOMASAPIResponse<Category> relatedCategoriesResponse = this.getCategoriesWithPaging(userId, guid, categoryHandler, requestedStartingFrom, pageSize, "getCategories");
                for (Category relatedCategory : relatedCategoriesResponse.results()) {
                    response.addResult((Object)relatedCategory);
                }
            } else {
                int startingFrom = 0;
                ArrayList<Category> filteredCategoriesList = new ArrayList<Category>();
                boolean continueGettingCategories = true;
                while (continueGettingCategories) {
                    SubjectAreaOMASAPIResponse<Category> relatedCategoriesResponse = this.getCategoriesWithPaging(userId, guid, categoryHandler, startingFrom, pageSize, "getCategories");
                    if (relatedCategoriesResponse.results() != null && relatedCategoriesResponse.results().size() > 0) {
                        for (Category relatedCategory : relatedCategoriesResponse.results()) {
                            if (filteredCategoriesList.size() >= requestedStartingFrom + pageSize) continue;
                            boolean addCategory = false;
                            if (isAll) {
                                if (onlyTop.booleanValue()) {
                                    if (relatedCategory.getParentCategory() == null) {
                                        addCategory = true;
                                    }
                                } else {
                                    addCategory = true;
                                }
                            } else if (this.categoryMatchSearchCriteria(relatedCategory, searchCriteria)) {
                                if (onlyTop.booleanValue()) {
                                    if (relatedCategory.getParentCategory() == null) {
                                        addCategory = true;
                                    }
                                } else {
                                    addCategory = true;
                                }
                            }
                            if (!addCategory) continue;
                            filteredCategoriesList.add(relatedCategory);
                        }
                    }
                    if (relatedCategoriesResponse.results().size() < pageSize || filteredCategoriesList.size() == requestedStartingFrom + pageSize) {
                        continueGettingCategories = false;
                        continue;
                    }
                    startingFrom += pageSize.intValue();
                }
                if (filteredCategoriesList.size() >= requestedStartingFrom) {
                    int endOffset = requestedStartingFrom + pageSize;
                    if (filteredCategoriesList.size() < requestedStartingFrom + pageSize) {
                        endOffset = filteredCategoriesList.size();
                    }
                    List filteredPagedCategoriesList = filteredCategoriesList.subList(requestedStartingFrom, endOffset);
                    response.addAllResults(filteredPagedCategoriesList);
                }
            }
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse<Category> getCategoriesWithPaging(String userId, String guid, SubjectAreaCategoryHandler categoryHandler, Integer startingFrom, Integer pageSize, String methodName) {
        Object response = new SubjectAreaOMASAPIResponse();
        SubjectAreaOMASAPIResponse relatedNodesResponse = this.getRelatedNodesForEnd1(methodName, userId, guid, "CategoryAnchor", CategoryMapper.class, startingFrom, pageSize);
        ArrayList allCategories = new ArrayList();
        if (relatedNodesResponse.getRelatedHTTPCode() == 200 && relatedNodesResponse.results() != null && relatedNodesResponse.results().size() > 0) {
            for (Category mappedCategory : relatedNodesResponse.results()) {
                SubjectAreaOMASAPIResponse<Category> categoryResponse = categoryHandler.getCategoryByGuid(userId, mappedCategory.getSystemAttributes().getGUID());
                if (categoryResponse.getRelatedHTTPCode() == 200) {
                    allCategories.add(categoryResponse.results().get(0));
                    continue;
                }
                response = categoryResponse;
                break;
            }
        } else {
            response = relatedNodesResponse;
        }
        response.addAllResults(allCategories);
        return response;
    }
}

