/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.services;

import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaConfigHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaInstanceHandler;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAreaConfigRESTServices
extends SubjectAreaRESTServicesInstance {
    private static final Logger log = LoggerFactory.getLogger(SubjectAreaConfigRESTServices.class);
    private static final SubjectAreaInstanceHandler instanceHandler = new SubjectAreaInstanceHandler();
    private static final String className = SubjectAreaConfigRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Config> getConfig(String serverName, String userId) {
        String methodName = "getConfig";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: getConfig,userId=" + userId);
        }
        Object response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfig");
            SubjectAreaConfigHandler handler = instanceHandler.getSubjectAreaConfigHandler(userId, serverName, "getConfig");
            response = handler.getConfig(userId);
        }
        catch (OCFCheckedExceptionBase e) {
            response.setExceptionInfo(e, className);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getConfig");
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : getConfig,userId=" + userId + ", response =" + response);
        }
        return response;
    }
}

