/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaHandler;
import org.odpi.openmetadata.accessservices.subjectarea.handlers.SubjectAreaTermHandler;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.CategoryMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.TermMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryAnchorMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.CategoryHierarchyLinkMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.accessservices.subjectarea.validators.InputValidator;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;

public class SubjectAreaCategoryHandler
extends SubjectAreaHandler {
    private static final String className = SubjectAreaCategoryHandler.class.getName();

    public SubjectAreaCategoryHandler(OMRSAPIHelper oMRSAPIHelper, int maxPageSize) {
        super(oMRSAPIHelper, maxPageSize);
    }

    public SubjectAreaOMASAPIResponse<Category> createCategory(String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        String createdCategoryGuid = null;
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "createCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            String suppliedCategoryName = suppliedCategory.getName();
            if (suppliedCategoryName == null || suppliedCategoryName.equals("")) {
                ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.GLOSSARY_CATEGORY_CREATE_WITHOUT_NAME.getMessageDefinition();
                throw new InvalidParameterException(messageDefinition, className, "createCategory", "Name", null);
            }
            this.setUniqueQualifiedNameIfBlank((Node)suppliedCategory);
            CategoryMapper categoryMapper = this.mappersFactory.get(CategoryMapper.class);
            EntityDetail categoryEntityDetail = categoryMapper.map(suppliedCategory);
            GlossarySummary suppliedGlossary = suppliedCategory.getGlossary();
            String glossaryGuid = this.validateGlossarySummaryDuringCreation(userId, "createCategory", suppliedGlossary);
            InstanceProperties instanceProperties = categoryEntityDetail.getProperties();
            if (instanceProperties == null) {
                instanceProperties = new InstanceProperties();
            }
            if (instanceProperties.getEffectiveFromTime() == null) {
                instanceProperties.setEffectiveFromTime(new Date());
                categoryEntityDetail.setProperties(instanceProperties);
            }
            if ((createdCategoryGuid = this.oMRSAPIHelper.callOMRSAddEntity("createCategory", userId, categoryEntityDetail)) != null) {
                CategoryAnchor categoryAnchor = new CategoryAnchor();
                categoryAnchor.getEnd1().setNodeGuid(glossaryGuid);
                categoryAnchor.getEnd2().setNodeGuid(createdCategoryGuid);
                categoryAnchor.setEffectiveFromTime(Long.valueOf(instanceProperties.getEffectiveFromTime().getTime()));
                if (instanceProperties.getEffectiveToTime() != null) {
                    categoryAnchor.setEffectiveToTime(Long.valueOf(instanceProperties.getEffectiveToTime().getTime()));
                }
                CategoryAnchorMapper anchorMapper = this.mappersFactory.get(CategoryAnchorMapper.class);
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationship = anchorMapper.map(categoryAnchor);
                this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, relationship);
            }
            if (suppliedCategory.getParentCategory() != null && suppliedCategory.getParentCategory().getGuid() != null) {
                String parentCategoryGuid = suppliedCategory.getParentCategory().getGuid();
                CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
                categoryHierarchyLink.getEnd1().setNodeGuid(parentCategoryGuid);
                categoryHierarchyLink.getEnd2().setNodeGuid(createdCategoryGuid);
                categoryHierarchyLink.setEffectiveFromTime(Long.valueOf(instanceProperties.getEffectiveFromTime().getTime()));
                if (instanceProperties.getEffectiveToTime() != null) {
                    categoryHierarchyLink.setEffectiveToTime(Long.valueOf(instanceProperties.getEffectiveToTime().getTime()));
                }
                CategoryHierarchyLinkMapper hierarchyMapper = this.mappersFactory.get(CategoryHierarchyLinkMapper.class);
                org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationship = hierarchyMapper.map(categoryHierarchyLink);
                this.oMRSAPIHelper.callOMRSAddRelationship("createCategory", userId, relationship);
            }
            response = this.getCategoryByGuid(userId, createdCategoryGuid);
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            if (createdCategoryGuid != null) {
                this.deleteCategory(userId, createdCategoryGuid, false);
                this.deleteCategory(userId, createdCategoryGuid, true);
            }
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryByGuid(String userId, String guid) {
        String methodName = "getCategory";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            Optional<EntityDetail> entityDetail = this.oMRSAPIHelper.callOMRSGetEntityByGuid(userId, guid, "GlossaryCategory", "getCategory");
            if (entityDetail.isPresent()) {
                CategoryMapper categoryMapper = this.mappersFactory.get(CategoryMapper.class);
                Category category = categoryMapper.map(entityDetail.get());
                this.setGlossary(userId, category, "getCategory");
                this.setParentCategory(userId, category, "getCategory");
                response.addResult((Object)category);
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> findCategory(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) {
        String methodName = "findCategory";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        try {
            List foundCategories = this.findNodes(userId, "GlossaryCategory", findRequest, exactValue, ignoreCase, CategoryMapper.class, "findCategory");
            if (foundCategories != null) {
                for (Category category : foundCategories) {
                    this.setGlossary(userId, category, "findCategory");
                    this.setParentCategory(userId, category, "findCategory");
                    response.addResult((Object)category);
                }
            }
        }
        catch (SubjectAreaCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void setGlossary(String userId, Category category, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String guid = category.getSystemAttributes().getGUID();
        List<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> relationships = this.oMRSAPIHelper.getRelationshipsByType(userId, guid, "GlossaryCategory", "CategoryAnchor", methodName);
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationship : relationships) {
                CategoryAnchorMapper categotyAnchorMapper = this.mappersFactory.get(CategoryAnchorMapper.class);
                CategoryAnchor termAnchor = (CategoryAnchor)categotyAnchorMapper.map(relationship);
                GlossarySummary glossarySummary = this.getGlossarySummary(methodName, userId, (Relationship)termAnchor);
                if (glossarySummary == null) continue;
                category.setGlossary(glossarySummary);
                break;
            }
        }
    }

    private void setParentCategory(String userId, Category category, String methodName) throws SubjectAreaCheckedException, PropertyServerException, UserNotAuthorizedException {
        String currentCategoryGuid = category.getSystemAttributes().getGUID();
        List<EntityDetail> foundEntities = this.oMRSAPIHelper.callGetEntitiesForRelationshipEnd2(methodName, userId, currentCategoryGuid, "GlossaryCategory", "CategoryHierarchyLink");
        if (CollectionUtils.isNotEmpty(foundEntities)) {
            for (EntityDetail entity : foundEntities) {
                String entityGUID = entity.getGUID();
                List<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship> relationships = this.oMRSAPIHelper.getRelationshipsByType(userId, entityGUID, "GlossaryCategory", "CategoryHierarchyLink", methodName);
                for (org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship relationship : relationships) {
                    String parentGuid = relationship.getEntityOneProxy().getGUID();
                    String childGuid = relationship.getEntityTwoProxy().getGUID();
                    if (!entityGUID.equals(parentGuid) || !currentCategoryGuid.equals(childGuid)) continue;
                    CategoryHierarchyLinkMapper hierarchyMapper = this.mappersFactory.get(CategoryHierarchyLinkMapper.class);
                    CategoryMapper categoryMapper = this.mappersFactory.get(CategoryMapper.class);
                    CategoryHierarchyLink link = (CategoryHierarchyLink)hierarchyMapper.map(relationship);
                    Category parentCategory = categoryMapper.map(entity);
                    category.setParentCategory(SubjectAreaUtils.extractCategorySummaryFromCategory(parentCategory, (Relationship)link));
                }
            }
        }
    }

    public SubjectAreaOMASAPIResponse<Relationship> getCategoryRelationships(String userId, String guid, FindRequest findRequest) {
        String restAPIName = "getCategoryRelationships";
        return this.getAllRelationshipsForEntity(restAPIName, userId, guid, findRequest);
    }

    public SubjectAreaOMASAPIResponse<Category> updateCategory(String userId, String guid, Category suppliedCategory, boolean isReplace) {
        String methodName = "updateCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            InputValidator.validateNodeType((Object[])new Object[]{className, "updateCategory", suppliedCategory.getNodeType(), NodeType.Category, NodeType.SubjectAreaDefinition});
            response = this.getCategoryByGuid(userId, guid);
            if (response.head().isPresent()) {
                Category currentCategory = (Category)response.head().get();
                this.checkReadOnly("updateCategory", (Node)currentCategory, "update");
                if (isReplace) {
                    this.replaceAttributes(currentCategory, suppliedCategory);
                } else {
                    this.updateAttributes(currentCategory, suppliedCategory);
                }
                Long categoryFromTime = suppliedCategory.getEffectiveFromTime();
                Long categoryToTime = suppliedCategory.getEffectiveToTime();
                currentCategory.setEffectiveFromTime(categoryFromTime);
                currentCategory.setEffectiveToTime(categoryToTime);
                CategoryMapper mapper = this.mappersFactory.get(CategoryMapper.class);
                EntityDetail entityDetail = mapper.map(currentCategory);
                this.oMRSAPIHelper.callOMRSUpdateEntity("updateCategory", userId, entityDetail);
                response = this.getCategoryByGuid(userId, guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    private void replaceAttributes(Category currentCategory, Category newCategory) {
        currentCategory.setName(newCategory.getName());
        currentCategory.setQualifiedName(newCategory.getQualifiedName());
        currentCategory.setDescription(newCategory.getDescription());
        currentCategory.setAdditionalProperties(newCategory.getAdditionalProperties());
    }

    private void updateAttributes(Category currentCategory, Category newTerm) {
        if (newTerm.getName() != null) {
            currentCategory.setName(newTerm.getName());
        }
        if (newTerm.getQualifiedName() != null) {
            currentCategory.setQualifiedName(newTerm.getQualifiedName());
        }
        if (newTerm.getDescription() != null) {
            currentCategory.setDescription(newTerm.getDescription());
        }
        if (newTerm.getAdditionalProperties() != null) {
            currentCategory.setAdditionalProperties(newTerm.getAdditionalProperties());
        }
    }

    public SubjectAreaOMASAPIResponse<Category> deleteCategory(String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            if (isPurge.booleanValue()) {
                this.oMRSAPIHelper.callOMRSPurgeEntity("deleteCategory", userId, "GlossaryCategory", guid);
            } else {
                response = this.getCategoryByGuid(userId, guid);
                if (response.head().isPresent()) {
                    Category currentCategory = (Category)response.head().get();
                    this.checkReadOnly("deleteCategory", (Node)currentCategory, "delete");
                }
                this.oMRSAPIHelper.callOMRSDeleteEntity("deleteCategory", userId, "GlossaryCategory", guid);
            }
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> restoreCategory(String userId, String guid) {
        String methodName = "restoreCategory";
        SubjectAreaOMASAPIResponse<Category> response = new SubjectAreaOMASAPIResponse<Category>();
        try {
            this.oMRSAPIHelper.callOMRSRestoreEntity("restoreCategory", userId, guid);
            response = this.getCategoryByGuid(userId, guid);
        }
        catch (SubjectAreaCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            response.setExceptionInfo((OCFCheckedExceptionBase)e, className);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getCategorizedTerms(String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, SubjectAreaTermHandler termHandler, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse<Category> thisCategoryResponse;
        String methodName = "getCategorizedTerms";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if ((thisCategoryResponse = this.getCategoryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            ArrayList<Term> termsToReturn = new ArrayList<Term>();
            boolean continueGettingTerms = true;
            while (continueGettingTerms) {
                SubjectAreaOMASAPIResponse childTermsResponse = this.getRelatedNodesForEnd1("getCategorizedTerms", userId, guid, "TermCategorization", TermMapper.class, startingFrom, pageSize);
                if (childTermsResponse.results() != null && childTermsResponse.results().size() > 0) {
                    for (Term term : childTermsResponse.results()) {
                        if (!this.termMatchSearchCriteria(term, searchCriteria) || termsToReturn.size() >= pageSize) continue;
                        termsToReturn.add(term);
                    }
                }
                if (childTermsResponse.results().size() < pageSize || termsToReturn.size() == pageSize.intValue()) {
                    continueGettingTerms = false;
                    continue;
                }
                startingFrom = startingFrom + pageSize;
            }
            response.addAllResults(termsToReturn);
        }
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryChildren(String userId, String guid, String searchCriteria, boolean exactValue, boolean ignoreCase, Integer startingFrom, Integer pageSize) {
        SubjectAreaOMASAPIResponse<Category> thisCategoryResponse;
        String methodName = "getCategoryChildren";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        if (pageSize == null) {
            pageSize = this.maxPageSize;
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if ((thisCategoryResponse = this.getCategoryByGuid(userId, guid)).getRelatedHTTPCode() == 200) {
            String parentCategoryGuid = ((Category)thisCategoryResponse.results().get(0)).getSystemAttributes().getGUID();
            ArrayList<Category> categoriesToReturn = new ArrayList<Category>();
            boolean continueGettingCategories = true;
            while (continueGettingCategories) {
                SubjectAreaOMASAPIResponse relatedCategoriesResponse = this.getRelatedNodesForEnd1("getCategoryChildren", userId, guid, "CategoryHierarchyLink", CategoryMapper.class, startingFrom, pageSize);
                if (relatedCategoriesResponse.results() != null && relatedCategoriesResponse.results().size() > 0) {
                    for (Category relatedCategory : relatedCategoriesResponse.results()) {
                        if (!this.categoryMatchSearchCriteria(relatedCategory, searchCriteria, exactValue, ignoreCase) || parentCategoryGuid.equals(relatedCategory.getSystemAttributes().getGUID()) || categoriesToReturn.size() >= pageSize) continue;
                        categoriesToReturn.add(relatedCategory);
                    }
                }
                if (relatedCategoriesResponse.results().size() < pageSize || categoriesToReturn.size() == pageSize.intValue()) {
                    continueGettingCategories = false;
                    continue;
                }
                startingFrom = startingFrom + pageSize;
            }
            response.addAllResults(categoriesToReturn);
        }
        return response;
    }
}

