/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.CanonicalVocabulary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.CanonicalTaxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.entities.EntityDetailMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SubjectAreaMapper
public class GlossaryMapper
extends EntityDetailMapper<Glossary> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryMapper.class);
    private static final String className = GlossaryMapper.class.getName();
    public static final String GLOSSARY = "Glossary";
    public static final String OMRS_TAXONOMY_NAME = "Taxonomy";
    public static final String OMRS_CANONICAL_VOCABULARY_NAME = "CanonicalVocabulary";

    public GlossaryMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    public Glossary map(EntityDetail entityDetail) {
        Glossary glossary = new Glossary();
        List omrsClassifications = entityDetail.getClassifications();
        if (omrsClassifications != null) {
            for (Classification omrsClassification : omrsClassifications) {
                boolean isTaxonomy = false;
                boolean iscanonicalvocabulary = false;
                if (this.omrsapiHelper.isTypeOf(OMRS_TAXONOMY_NAME, omrsClassification.getName())) {
                    isTaxonomy = true;
                }
                if (this.omrsapiHelper.isTypeOf(OMRS_CANONICAL_VOCABULARY_NAME, omrsClassification.getName())) {
                    iscanonicalvocabulary = true;
                }
                if (iscanonicalvocabulary && isTaxonomy) {
                    glossary = new CanonicalTaxonomy();
                    continue;
                }
                if (iscanonicalvocabulary) {
                    glossary = new CanonicalGlossary();
                    continue;
                }
                if (!isTaxonomy) continue;
                glossary = new Taxonomy();
            }
        }
        this.mapEntityDetailToNode(glossary, entityDetail);
        return glossary;
    }

    @Override
    public EntityDetail map(Glossary node) {
        return super.toEntityDetail(node);
    }

    @Override
    protected List<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> getInlinedClassifications(Glossary node) {
        ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification> inlinedClassifications = new ArrayList<org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification>();
        if (node.getNodeType() == NodeType.TaxonomyAndCanonicalGlossary) {
            CanonicalTaxonomy canonicalTaxonomy = (CanonicalTaxonomy)node;
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Taxonomy taxonomyClassification = new org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Taxonomy();
            taxonomyClassification.setOrganizingPrinciple(canonicalTaxonomy.getOrganizingPrinciple());
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)taxonomyClassification);
            CanonicalVocabulary canonicalVocabulary = new CanonicalVocabulary();
            canonicalVocabulary.setScope(canonicalTaxonomy.getScope());
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)canonicalVocabulary);
        } else if (node.getNodeType() == NodeType.Taxonomy) {
            Taxonomy taxonomy = (Taxonomy)node;
            org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Taxonomy taxonomyClassification = new org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Taxonomy();
            taxonomyClassification.setOrganizingPrinciple(taxonomy.getOrganizingPrinciple());
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)taxonomyClassification);
        } else if (node.getNodeType() == NodeType.CanonicalGlossary) {
            CanonicalGlossary canonicalGlossary = (CanonicalGlossary)node;
            CanonicalVocabulary canonicalVocabulary = new CanonicalVocabulary();
            canonicalVocabulary.setScope(canonicalGlossary.getScope());
            inlinedClassifications.add((org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification)canonicalVocabulary);
        }
        return inlinedClassifications;
    }

    @Override
    protected boolean mapPrimitiveToNode(Glossary glossary, String propertyName, Object value) {
        String stringValue = (String)value;
        boolean foundProperty = true;
        if (propertyName.equals("language")) {
            glossary.setLanguage(stringValue);
        } else if (propertyName.equals("usage")) {
            glossary.setUsage(stringValue);
        } else {
            foundProperty = false;
        }
        return foundProperty;
    }

    @Override
    protected void mapNodeToInstanceProperties(Glossary node, InstanceProperties instanceProperties) {
        Glossary glossary = node;
        if (glossary.getLanguage() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, glossary.getLanguage(), "language");
        }
        if (glossary.getUsage() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, glossary.getUsage(), "usage");
        }
        if (node.getName() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, node.getName(), "displayName");
        }
    }

    @Override
    protected boolean updateNodeWithClassification(Glossary glossary, org.odpi.openmetadata.accessservices.subjectarea.properties.classifications.Classification omasClassification) {
        boolean handled = false;
        String classificationName = omasClassification.getClassificationName();
        NodeType existingNodeType = glossary.getNodeType();
        if (existingNodeType == null) {
            existingNodeType = NodeType.Glossary;
        }
        if (existingNodeType == NodeType.Glossary && this.omrsapiHelper.isTypeOf(OMRS_TAXONOMY_NAME, classificationName)) {
            glossary.setNodeType(NodeType.Taxonomy);
            handled = true;
        } else if (existingNodeType == NodeType.CanonicalGlossary && this.omrsapiHelper.isTypeOf(OMRS_TAXONOMY_NAME, classificationName)) {
            glossary.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
            handled = true;
        } else if (existingNodeType == NodeType.Glossary && this.omrsapiHelper.isTypeOf(OMRS_CANONICAL_VOCABULARY_NAME, classificationName)) {
            glossary.setNodeType(NodeType.CanonicalGlossary);
            handled = true;
        } else if (existingNodeType == NodeType.Taxonomy && this.omrsapiHelper.isTypeOf(OMRS_CANONICAL_VOCABULARY_NAME, classificationName)) {
            glossary.setNodeType(NodeType.TaxonomyAndCanonicalGlossary);
            handled = true;
        } else {
            glossary.setNodeType(existingNodeType);
            handled = true;
        }
        return handled;
    }

    @Override
    public String getTypeName() {
        return GLOSSARY;
    }
}

