/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships;

import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.TermRelationshipStatus;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.SubjectAreaMapper;
import org.odpi.openmetadata.accessservices.subjectarea.server.mappers.relationships.RelationshipMapper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.OMRSAPIHelper;
import org.odpi.openmetadata.accessservices.subjectarea.utilities.SubjectAreaUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

@SubjectAreaMapper
public class TermCategorizationMapper
extends RelationshipMapper<Categorization> {
    public static final String TERM_CATEGORIZATION = "TermCategorization";

    public TermCategorizationMapper(OMRSAPIHelper omrsapiHelper) {
        super(omrsapiHelper);
    }

    @Override
    protected void mapRelationshipToInstanceProperties(Categorization termCategorization, InstanceProperties instanceProperties) {
        if (termCategorization.getDescription() != null) {
            SubjectAreaUtils.setStringPropertyInInstanceProperties(instanceProperties, termCategorization.getDescription(), "description");
        }
        if (termCategorization.getStatus() != null) {
            EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
            enumPropertyValue.setOrdinal(termCategorization.getStatus().getOrdinal());
            instanceProperties.setProperty("status", (InstancePropertyValue)enumPropertyValue);
        }
    }

    @Override
    protected boolean mapPrimitiveToRelationship(Categorization termCategorization, String propertyName, Object value) {
        String stringValue = (String)value;
        boolean foundProperty = false;
        if (propertyName.equals("description")) {
            termCategorization.setDescription(stringValue);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    protected boolean mapEnumToRelationship(Categorization termCategorization, String propertyName, EnumPropertyValue enumPropertyValue) {
        boolean foundProperty = false;
        if (propertyName.equals("status")) {
            TermRelationshipStatus status = TermRelationshipStatus.valueOf((String)enumPropertyValue.getSymbolicName());
            termCategorization.setStatus(status);
            foundProperty = true;
        }
        return foundProperty;
    }

    @Override
    public String getTypeName() {
        return TERM_CATEGORIZATION;
    }

    @Override
    protected Categorization getRelationshipInstance() {
        return new Categorization();
    }
}

